/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import jetbrains.buildServer.agent.AgentCanNotCheckoutReason;
import jetbrains.buildServer.agent.AgentCheckoutMode;
import jetbrains.buildServer.messages.BuildMessage1;
import jetbrains.buildServer.messages.DefaultMessagesInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoCheckoutModeDecision {
    @NotNull
    private final AgentCheckoutMode myResolvedCheckoutMode;
    @Nullable
    private final AgentCanNotCheckoutReason myServerCheckoutReason;
    @Nullable
    private final String myVcsRootName;

    private AutoCheckoutModeDecision(@NotNull AgentCheckoutMode resolvedCheckoutMode, @Nullable AgentCanNotCheckoutReason agentCanNotCheckoutReason, @Nullable String vcsRootName) {
        if (resolvedCheckoutMode == null) {
            AutoCheckoutModeDecision.$$$reportNull$$$0(0);
        }
        this.myResolvedCheckoutMode = resolvedCheckoutMode;
        this.myServerCheckoutReason = agentCanNotCheckoutReason;
        this.myVcsRootName = vcsRootName;
    }

    public static AutoCheckoutModeDecision serverCheckout(@NotNull AgentCanNotCheckoutReason canNotCheckoutReason, @Nullable String vcsRootName) {
        if (canNotCheckoutReason == null) {
            AutoCheckoutModeDecision.$$$reportNull$$$0(1);
        }
        return new AutoCheckoutModeDecision(AgentCheckoutMode.ON_SERVER, canNotCheckoutReason, vcsRootName);
    }

    public static AutoCheckoutModeDecision agentCheckout() {
        return new AutoCheckoutModeDecision(AgentCheckoutMode.ON_AGENT, null, null);
    }

    @NotNull
    public AgentCheckoutMode getResolvedCheckoutMode() {
        AgentCheckoutMode agentCheckoutMode = this.myResolvedCheckoutMode;
        if (agentCheckoutMode == null) {
            AutoCheckoutModeDecision.$$$reportNull$$$0(2);
        }
        return agentCheckoutMode;
    }

    @Nullable
    public AgentCanNotCheckoutReason getServerCheckoutReason() {
        return this.myServerCheckoutReason;
    }

    @Nullable
    public String getVcsRootName() {
        return this.myVcsRootName;
    }

    @NotNull
    public String serialize() {
        String messageText = "";
        if (this.myResolvedCheckoutMode == AgentCheckoutMode.ON_AGENT) {
            messageText = "Will use agent side checkout";
        } else if (this.myResolvedCheckoutMode == AgentCheckoutMode.ON_SERVER && this.myServerCheckoutReason != null) {
            messageText = this.myVcsRootName != null ? "Will use server side checkout: " + this.myServerCheckoutReason.getType() + " for vcs root '" + this.myVcsRootName + "'" : "Will use server side checkout: " + this.myServerCheckoutReason.getType();
            if (this.myServerCheckoutReason.getDetails() != null) {
                messageText = messageText + ". Details: " + this.myServerCheckoutReason.getDetails();
            }
        }
        String string = messageText;
        if (string == null) {
            AutoCheckoutModeDecision.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static AutoCheckoutModeDecision parse(@NotNull String serialized) {
        int vcsRootStartIndex;
        if (serialized == null) {
            AutoCheckoutModeDecision.$$$reportNull$$$0(4);
        }
        if (serialized.equals("Will use agent side checkout")) {
            return AutoCheckoutModeDecision.agentCheckout();
        }
        if (serialized.indexOf("Will use server side checkout") == -1) {
            return null;
        }
        String vcsRootName = null;
        String details = null;
        String remaining = serialized;
        int detailsStartIndex = remaining.lastIndexOf(". Details: ");
        if (detailsStartIndex > 0) {
            details = remaining.substring(detailsStartIndex + ". Details: ".length());
            remaining = remaining.substring(0, detailsStartIndex);
        }
        if ((vcsRootStartIndex = remaining.indexOf(" for vcs root ")) > 0) {
            String vcsRootNameInQuotes = remaining.substring(vcsRootStartIndex + " for vcs root ".length());
            vcsRootName = vcsRootNameInQuotes.substring(1, vcsRootNameInQuotes.length() - 1);
            remaining = remaining.substring(0, vcsRootStartIndex);
        }
        String serverCheckoutReasonType = remaining.substring("Will use server side checkout: ".length());
        return new AutoCheckoutModeDecision(AgentCheckoutMode.ON_SERVER, new AgentCanNotCheckoutReason(serverCheckoutReasonType, details), vcsRootName);
    }

    public BuildMessage1 toBuildMessage() {
        return DefaultMessagesInfo.createTextMessage((String)this.serialize());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoCheckoutModeDecision decision = (AutoCheckoutModeDecision)o;
        if (this.myResolvedCheckoutMode != decision.myResolvedCheckoutMode) {
            return false;
        }
        if (this.myServerCheckoutReason != null ? !this.myServerCheckoutReason.equals((Object)decision.myServerCheckoutReason) : decision.myServerCheckoutReason != null) {
            return false;
        }
        return !(this.myVcsRootName == null ? decision.myVcsRootName != null : !this.myVcsRootName.equals(decision.myVcsRootName));
    }

    public int hashCode() {
        int result = this.myResolvedCheckoutMode.hashCode();
        result = 31 * result + (this.myServerCheckoutReason != null ? this.myServerCheckoutReason.hashCode() : 0);
        result = 31 * result + (this.myVcsRootName != null ? this.myVcsRootName.hashCode() : 0);
        return result;
    }

    public String toString() {
        switch (this.myResolvedCheckoutMode) {
            case ON_AGENT: {
                return "agent-side checkout";
            }
            case ON_SERVER: {
                return "server-side checkout (" + this.myServerCheckoutReason + ")";
            }
        }
        return "unknown";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCheckoutMode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canNotCheckoutReason";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/AutoCheckoutModeDecision";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/AutoCheckoutModeDecision";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedCheckoutMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "serverCheckout";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

