/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.io.File;
import java.io.IOException;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.zip.ZipFactory;
import jetbrains.buildServer.zip.ZipReader;
import jetbrains.buildServer.zip.ZipWriter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class AbstractFileZipFactory
implements ZipFactory {
    @NonNls
    @NotNull
    private static final String TEAMCITY_ARCHIVE_ZIP_LEVEL = "teamcity.archive.zip.level";
    private final boolean myAutoCreateDirectories;
    private final boolean myRewriteExistentFiles;
    final boolean myDynamic;
    private final boolean myShared;
    private volatile int myLevel = -1;
    private volatile boolean myLevelSet;

    protected AbstractFileZipFactory(boolean autoCreateDirectories, boolean rewriteExistentFiles, boolean dynamic, boolean shared) {
        if (shared && !dynamic) {
            throw new IllegalArgumentException("Shared static ZIP factories are not supported");
        }
        this.myAutoCreateDirectories = autoCreateDirectories;
        this.myRewriteExistentFiles = rewriteExistentFiles;
        this.myDynamic = dynamic;
        this.myShared = shared;
    }

    @NotNull
    protected abstract ZipWriter makeNewZipWriter(@NotNull File var1) throws IOException;

    @NotNull
    protected abstract ZipReader makeNewZipReader(@NotNull File var1) throws IOException;

    @Override
    @NotNull
    public final ZipWriter createZipArchive(@NotNull String name) throws IOException {
        if (name == null) {
            AbstractFileZipFactory.$$$reportNull$$$0(0);
        }
        File file = new File(name);
        if (this.myAutoCreateDirectories) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            if (this.myRewriteExistentFiles) {
                if (!file.delete()) {
                    throw new IllegalStateException("Existing file (" + file.getAbsolutePath() + ") cannot be deleted.");
                }
            } else {
                throw new IllegalStateException("File (" + file.getAbsolutePath() + ") already exists.");
            }
        }
        ZipWriter zipWriter = this.makeNewZipWriter(file);
        if (zipWriter == null) {
            AbstractFileZipFactory.$$$reportNull$$$0(1);
        }
        return zipWriter;
    }

    @Override
    public ZipReader openZipArchive(String name) throws IOException, IllegalStateException {
        File file = new File(name);
        if (!file.exists()) {
            throw new IllegalArgumentException("File (" + file.getAbsolutePath() + ") does not exist.");
        }
        if (!file.canRead()) {
            throw new IllegalStateException("File (" + file.getAbsolutePath() + ") could not be read.");
        }
        return this.makeNewZipReader(file);
    }

    @Override
    public boolean isFileExist(String name) {
        return new File(name).exists();
    }

    @Override
    public void rename(String sourceName, String targetName) throws IOException {
        boolean ok;
        File src = new File(sourceName);
        if (!src.exists()) {
            throw new IOException("Failed to rename file \"" + sourceName + "\": such file doesn't exist");
        }
        File trg = new File(targetName);
        if (trg.exists()) {
            throw new IOException("Failed to rename file \"" + sourceName + "\" to \"" + targetName + "\": the destination file already exists");
        }
        File trgDir = trg.getParentFile();
        if (!trgDir.exists()) {
            trg.mkdirs();
            if (!trgDir.exists()) {
                throw new IOException("Failed to rename file \"" + sourceName + "\" to \"" + targetName + "\": couldn't create parent directory");
            }
        }
        if (!(ok = src.renameTo(trg))) {
            throw new IOException("Failed to rename file \"" + sourceName + "\" to \"" + targetName + "\": the renameTo() method returned false");
        }
    }

    final int getLevel() {
        return this.myLevelSet ? this.myLevel : AbstractFileZipFactory.getDefaultCompressionLevel();
    }

    @Override
    public final void setLevel(int level) {
        if ((level < 0 || level > 9) && level != -1) {
            throw new IllegalArgumentException(String.format("Invalid compression level: %d", level));
        }
        if (this.myShared) {
            throw new IllegalStateException("N/A: shared factory");
        }
        this.myLevel = level;
        this.myLevelSet = true;
    }

    private static int getDefaultCompressionLevel() {
        int level = TeamCityProperties.getInteger((String)TEAMCITY_ARCHIVE_ZIP_LEVEL, (int)-1);
        return level >= 0 && level <= 9 ? level : -1;
    }

    @NotNull
    abstract String getName();

    public final String toString() {
        StringBuilder description = new StringBuilder();
        if (this.myDynamic) {
            description.append(" (dynamic");
            if (this.myShared) {
                description.append(", shared");
            }
            description.append(')');
        }
        return String.format("%s%s; compression level %d", this.getName(), description, this.getLevel());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/zip/AbstractFileZipFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/zip/AbstractFileZipFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createZipArchive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createZipArchive";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

