/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jetbrains.buildServer.zip.AbstractZipWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractFileZipWriter
extends AbstractZipWriter {
    @NotNull
    private final FileOutputStream fstream;
    @NotNull
    final BufferedOutputStream bfstream;
    @Nullable
    Closeable innerStreamHandler;

    AbstractFileZipWriter(@NotNull File file) throws FileNotFoundException {
        if (file == null) {
            AbstractFileZipWriter.$$$reportNull$$$0(0);
        }
        this.fstream = new FileOutputStream(file);
        this.bfstream = new BufferedOutputStream(this.fstream);
    }

    protected abstract void closeCurrentZipEntry() throws IOException;

    protected final void checkNoCurrentStreams(String newFileName) {
        if (this.innerStreamHandler != null) {
            throw new IllegalStateException("Could not create a new stream (" + newFileName + ") because another stream (" + this.innerStreamHandler + ") is open at this time.");
        }
    }

    protected abstract boolean isOpened();

    protected abstract void flushZip() throws IOException;

    protected abstract void closeZip() throws IOException;

    @Override
    public final void close() throws IOException {
        if (this.innerStreamHandler != null) {
            this.innerStreamHandler.close();
        }
        this.flushZip();
        this.closeHandles();
    }

    protected final void closeHandles() throws IOException {
        if (this.isOpened()) {
            try {
                this.closeZip();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.bfstream.close();
        this.fstream.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/zip/AbstractFileZipWriter", "<init>"));
    }

    final class InnerOutputStream
    extends FilterOutputStream {
        InnerOutputStream(OutputStream out) {
            if (out == null) {
                InnerOutputStream.$$$reportNull$$$0(0);
            }
            super(out);
            AbstractFileZipWriter.this.innerStreamHandler = this;
        }

        @Override
        public void write(@NotNull byte[] data, int offset, int length) throws IOException {
            if (data == null) {
                InnerOutputStream.$$$reportNull$$$0(1);
            }
            this.out.write(data, offset, length);
        }

        @Override
        public void close() throws IOException {
            super.flush();
            this.out = null;
            AbstractFileZipWriter.this.closeCurrentZipEntry();
            AbstractFileZipWriter.this.innerStreamHandler = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/zip/AbstractFileZipWriter$InnerOutputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

