/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import jetbrains.buildServer.zip.ZipReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractZipReader
implements ZipReader {
    protected abstract Set<String> allNames();

    @Override
    public List<String> listFiles(Pattern regexPattern) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.allNames()) {
            if (!regexPattern.matcher(name).matches()) continue;
            list.add(name);
        }
        return list;
    }

    @Override
    public List<String> listDirectoryFiles(String path) {
        if (path == null || path.length() == 0) {
            return this.listAllFiles();
        }
        if (path.contains("\\")) {
            path = path.replace('\\', '/');
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            return this.listAllFiles();
        }
        path = path + "/";
        int m = path.length();
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.allNames()) {
            if (name.length() <= m || !name.startsWith(path) || name.endsWith("/")) continue;
            list.add(name.substring(m));
        }
        return list;
    }

    private List<String> listAllFiles() {
        return new ArrayList<String>(this.allNames());
    }

    @Override
    @NotNull
    public final BufferedReader openTextFile(@NotNull String name, @Nullable Charset charset) throws IOException {
        if (name == null) {
            AbstractZipReader.$$$reportNull$$$0(0);
        }
        InputStream istream = this.openBinaryFile(name);
        InputStreamReader ireader = charset != null ? new InputStreamReader(istream, charset) : new InputStreamReader(istream);
        BufferedReader bufferedReader = new BufferedReader(ireader);
        if (bufferedReader == null) {
            AbstractZipReader.$$$reportNull$$$0(1);
        }
        return bufferedReader;
    }

    @Override
    public boolean doesFileExist(@NotNull String name) {
        if (name == null) {
            AbstractZipReader.$$$reportNull$$$0(2);
        }
        return this.allNames().contains(name);
    }

    @Override
    public boolean doesFileExist(@NotNull Pattern namePattern) {
        if (namePattern == null) {
            AbstractZipReader.$$$reportNull$$$0(3);
        }
        for (String entry : this.allNames()) {
            if (!namePattern.matcher(entry).matches()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/zip/AbstractZipReader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/zip/AbstractZipReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "openTextFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openTextFile";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doesFileExist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

