/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.io.File;
import java.io.IOException;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.zip.AbstractFileZipFactory;
import jetbrains.buildServer.zip.BigFileZipReader;
import jetbrains.buildServer.zip.BigFileZipWriter;
import jetbrains.buildServer.zip.MemoryConservativeZipWriter;
import jetbrains.buildServer.zip.ZipReader;
import jetbrains.buildServer.zip.ZipWriter;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BigFileZipFactory
extends AbstractFileZipFactory {
    @NonNls
    @NotNull
    private static final String TEAMCITY_ARCHIVE_ZIP_FACTORY = "teamcity.archive.zip.factory";
    @NonNls
    @NotNull
    public static final String CONSERVATIVE = "conservative";
    @NonNls
    @NotNull
    public static final String DISK_BASED = "disk-based";
    @NonNls
    @NotNull
    public static final String COMMONS_COMPRESS = "commons-compress";
    private static final ArchiveStreamFactory ourArchiveStreamFactory = new ArchiveStreamFactory();

    private BigFileZipFactory(boolean autoCreateDirectories, boolean rewriteExistingFiles, boolean dynamic, boolean shared) {
        super(autoCreateDirectories, rewriteExistingFiles, dynamic, shared);
    }

    public BigFileZipFactory(boolean autoCreateDirectories, boolean rewriteExistingFiles) {
        this(autoCreateDirectories, rewriteExistingFiles, false, false);
    }

    @NotNull
    public static BigFileZipFactory newInstance(boolean autoCreateDirectories, boolean rewriteExistingFiles) {
        BigFileZipFactory bigFileZipFactory = new BigFileZipFactory(autoCreateDirectories, rewriteExistingFiles, true, false);
        if (bigFileZipFactory == null) {
            BigFileZipFactory.$$$reportNull$$$0(0);
        }
        return bigFileZipFactory;
    }

    @NotNull
    public static BigFileZipFactory newSharedInstance(boolean autoCreateDirectories, boolean rewriteExistingFiles) {
        BigFileZipFactory bigFileZipFactory = new BigFileZipFactory(autoCreateDirectories, rewriteExistingFiles, true, true);
        if (bigFileZipFactory == null) {
            BigFileZipFactory.$$$reportNull$$$0(1);
        }
        return bigFileZipFactory;
    }

    @Override
    @NotNull
    protected ZipWriter makeNewZipWriter(@NotNull File file) throws IOException {
        if (file == null) {
            BigFileZipFactory.$$$reportNull$$$0(2);
        }
        int level = this.getLevel();
        if (this.myDynamic) {
            String zipFactoryName = TeamCityProperties.getProperty((String)TEAMCITY_ARCHIVE_ZIP_FACTORY, (String)CONSERVATIVE);
            if (zipFactoryName.equals(COMMONS_COMPRESS)) {
                BigFileZipWriter bigFileZipWriter = new BigFileZipWriter(file, ourArchiveStreamFactory, level);
                if (bigFileZipWriter == null) {
                    BigFileZipFactory.$$$reportNull$$$0(3);
                }
                return bigFileZipWriter;
            }
            if (zipFactoryName.equals(DISK_BASED)) {
                ZipWriter zipWriter = MemoryConservativeZipWriter.getDiskBasedCen(file, level);
                if (zipWriter == null) {
                    BigFileZipFactory.$$$reportNull$$$0(4);
                }
                return zipWriter;
            }
            ZipWriter zipWriter = MemoryConservativeZipWriter.getDefault(file, level);
            if (zipWriter == null) {
                BigFileZipFactory.$$$reportNull$$$0(5);
            }
            return zipWriter;
        }
        BigFileZipWriter bigFileZipWriter = new BigFileZipWriter(file, ourArchiveStreamFactory, level);
        if (bigFileZipWriter == null) {
            BigFileZipFactory.$$$reportNull$$$0(6);
        }
        return bigFileZipWriter;
    }

    @Override
    @NotNull
    protected final ZipReader makeNewZipReader(@NotNull File file) throws IOException {
        if (file == null) {
            BigFileZipFactory.$$$reportNull$$$0(7);
        }
        BigFileZipReader bigFileZipReader = new BigFileZipReader(file);
        if (bigFileZipReader == null) {
            BigFileZipFactory.$$$reportNull$$$0(8);
        }
        return bigFileZipReader;
    }

    @Override
    @NotNull
    String getName() {
        if (this.myDynamic) {
            String zipFactoryName = TeamCityProperties.getProperty((String)TEAMCITY_ARCHIVE_ZIP_FACTORY, (String)CONSERVATIVE);
            if (zipFactoryName.equals(COMMONS_COMPRESS)) {
                String string = this.getClass().getSimpleName();
                if (string == null) {
                    BigFileZipFactory.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (zipFactoryName.equals(DISK_BASED)) {
                if ("disk-based CEN" == null) {
                    BigFileZipFactory.$$$reportNull$$$0(10);
                }
                return "disk-based CEN";
            }
            if ("memory-conservative" == null) {
                BigFileZipFactory.$$$reportNull$$$0(11);
            }
            return "memory-conservative";
        }
        String string = this.getClass().getSimpleName();
        if (string == null) {
            BigFileZipFactory.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/zip/BigFileZipFactory";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newSharedInstance";
                break;
            }
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/zip/BigFileZipFactory";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNewZipWriter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNewZipReader";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "makeNewZipWriter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "makeNewZipReader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

