/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import jetbrains.buildServer.zip.AbstractFileZipWriter;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BigFileZipWriter
extends AbstractFileZipWriter {
    private final ZipArchiveOutputStream zip;

    BigFileZipWriter(@NotNull File file, @NotNull ArchiveStreamFactory archiveStreamFactory, int level) throws IOException {
        if (file == null) {
            BigFileZipWriter.$$$reportNull$$$0(0);
        }
        if (archiveStreamFactory == null) {
            BigFileZipWriter.$$$reportNull$$$0(1);
        }
        super(file);
        try {
            ArchiveOutputStream aos = archiveStreamFactory.createArchiveOutputStream("zip", (OutputStream)this.bfstream);
            assert (aos != null) : "Created archive output stream should not be null";
            assert (aos instanceof ZipArchiveOutputStream) : "Created archive output stream should be a ZIP one";
            this.zip = (ZipArchiveOutputStream)aos;
            this.zip.setUseZip64(Zip64Mode.Always);
            this.zip.setMethod(8);
            this.zip.setLevel(level);
        }
        catch (ArchiveException e) {
            this.closeHandles();
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public void setArchiveComment(@Nullable String comment) {
        this.zip.setComment(comment);
    }

    @Override
    @NotNull
    public OutputStream createBinaryFile(@NotNull String name, long mtimeMillis) throws IOException {
        if (name == null) {
            BigFileZipWriter.$$$reportNull$$$0(2);
        }
        this.checkNoCurrentStreams(name);
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(name);
        this.zip.putArchiveEntry((ArchiveEntry)zipEntry);
        AbstractFileZipWriter.InnerOutputStream innerOutputStream = new AbstractFileZipWriter.InnerOutputStream(this, new BufferedOutputStream((OutputStream)this.zip));
        if (innerOutputStream == null) {
            BigFileZipWriter.$$$reportNull$$$0(3);
        }
        return innerOutputStream;
    }

    @Override
    protected void closeCurrentZipEntry() throws IOException {
        this.zip.closeArchiveEntry();
    }

    @Override
    protected boolean isOpened() {
        return this.zip != null;
    }

    @Override
    protected void flushZip() throws IOException {
        this.zip.flush();
    }

    @Override
    protected void closeZip() throws IOException {
        this.zip.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveStreamFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/zip/BigFileZipWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/zip/BigFileZipWriter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryFile";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

