/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ChunkedArrayList<E>
extends AbstractList<E> {
    private static final int CHUNK_CAPACITY = 0x100000;
    @NotNull
    final List<ArrayList<E>> myChunks = new ArrayList<ArrayList<E>>();
    final boolean myRandomAccess = this.myChunks instanceof RandomAccess;
    private int mySize;

    ChunkedArrayList() {
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.myChunks.get(index / 0x100000).get(index % 0x100000);
    }

    @Override
    public boolean add(E e) {
        ArrayList<E> currentChunk;
        if (this.mySize++ % 0x100000 == 0) {
            currentChunk = new ArrayList(0x100000);
            this.myChunks.add(currentChunk);
        } else {
            currentChunk = this.getLastChunk();
        }
        currentChunk.add(e);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.rangeCheckForAdd(index);
        if (index < this.mySize) {
            throw new UnsupportedOperationException(this.outOfBoundsMsg(index));
        }
        this.add(element);
    }

    @Override
    public void clear() {
        for (List list : this.myChunks) {
            list.clear();
        }
        this.myChunks.clear();
        this.mySize = 0;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        if (c == null) {
            ChunkedArrayList.$$$reportNull$$$0(0);
        }
        if (!c.isEmpty()) {
            ArrayList<E> currentChunk = null;
            for (E e : c) {
                if (this.mySize++ % 0x100000 == 0) {
                    currentChunk = new ArrayList<E>(0x100000);
                    this.myChunks.add(currentChunk);
                } else if (currentChunk == null) {
                    currentChunk = this.getLastChunk();
                }
                currentChunk.add(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.rangeCheckForAdd(index);
        if (c.isEmpty()) {
            return false;
        }
        if (index < this.mySize) {
            throw new UnsupportedOperationException(this.outOfBoundsMsg(index));
        }
        return this.addAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @NotNull
    private ArrayList<E> getLastChunk() {
        int chunkCount = this.myChunks.size();
        ArrayList<E> arrayList = this.myRandomAccess ? this.myChunks.get(chunkCount - 1) : this.myChunks.listIterator(chunkCount).previous();
        if (arrayList == null) {
            ChunkedArrayList.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private void rangeCheck(int index) {
        if (index >= this.mySize) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.mySize || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    @NotNull
    private String outOfBoundsMsg(int index) {
        String string = String.format("Index: %d, Size: %d", index, this.mySize);
        if (string == null) {
            ChunkedArrayList.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/zip/ChunkedArrayList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/zip/ChunkedArrayList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastChunk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "outOfBoundsMsg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class Itr
    implements Iterator<E> {
        private int myCursor;
        @NotNull
        private final Iterator<ArrayList<E>> myChunkIterator;
        @Nullable
        private ArrayList<E> myCurrentChunk;

        Itr() {
            this.myChunkIterator = ChunkedArrayList.this.myChunks.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.myCursor != ChunkedArrayList.this.size();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.myCursor % 0x100000 == 0) {
                ArrayList arrayList = this.myCurrentChunk = ChunkedArrayList.this.myRandomAccess ? ChunkedArrayList.this.myChunks.get(this.myCursor / 0x100000) : this.myChunkIterator.next();
            }
            assert (this.myCurrentChunk != null);
            Object e = this.myCurrentChunk.get(this.myCursor % 0x100000);
            ++this.myCursor;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

