/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.zip.Platform;
import jetbrains.buildServer.zip.StringEncoder;
import jetbrains.buildServer.zip.ZipEntry;
import jetbrains.buildServer.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;

final class DiskBasedCenZipOutputStream
extends ZipOutputStream {
    private static final int SIZE_BYTES = 4;
    @NotNull
    final File myEntries;
    @NotNull
    private final OutputStream myEntryOut;
    int myEntryCount;

    DiskBasedCenZipOutputStream(@NotNull File file, @NotNull StringEncoder encoder, @NotNull Platform platform, int level) throws IOException {
        if (file == null) {
            DiskBasedCenZipOutputStream.$$$reportNull$$$0(0);
        }
        if (encoder == null) {
            DiskBasedCenZipOutputStream.$$$reportNull$$$0(1);
        }
        if (platform == null) {
            DiskBasedCenZipOutputStream.$$$reportNull$$$0(2);
        }
        super(new BufferedOutputStream(new FileOutputStream(file)), encoder, platform, level);
        this.myEntries = File.createTempFile(file.getName(), ".entries");
        this.myEntryOut = new BufferedOutputStream(new FileOutputStream(this.myEntries));
    }

    @Override
    void addEntry(@NotNull ZipEntry entry) throws IOException {
        if (entry == null) {
            DiskBasedCenZipOutputStream.$$$reportNull$$$0(3);
        }
        int metadataSize = entry.getMetadataSize();
        byte[] metadata = new byte[4 + metadataSize];
        ByteBuffer buf = ByteBuffer.wrap(metadata);
        buf.putInt(metadataSize);
        entry.write(buf);
        this.myEntryOut.write(metadata);
        ++this.myEntryCount;
    }

    @Override
    int getEntryCount() {
        return this.myEntryCount;
    }

    @Override
    @NotNull
    ZipOutputStream.CloseableIterable<ZipEntry> getEntries() throws IOException {
        this.myEntryOut.close();
        ZipOutputStream.CloseableIterable<ZipEntry> closeableIterable = new ZipOutputStream.CloseableIterable<ZipEntry>(){

            @Override
            @NotNull
            public ZipOutputStream.CloseableIterator<ZipEntry> iterator() {
                EntryIterator entryIterator;
                block2: {
                    try {
                        entryIterator = new EntryIterator();
                        if (entryIterator != null) break block2;
                    }
                    catch (FileNotFoundException fnfe) {
                        throw new RuntimeException(fnfe);
                    }
                    1.$$$reportNull$$$0(0);
                }
                return entryIterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/zip/DiskBasedCenZipOutputStream$1", "iterator"));
            }
        };
        if (closeableIterable == null) {
            DiskBasedCenZipOutputStream.$$$reportNull$$$0(4);
        }
        return closeableIterable;
    }

    @Override
    void clearEntries() throws IOException {
        Loggers.MAINTENANCE.info(String.format("Deleting the temporary file (%s, %d entries): %s...", StringUtil.formatFileSize((File)this.myEntries), this.myEntryCount, this.myEntries));
        this.myEntryCount = 0;
        if (!this.myEntries.delete()) {
            throw new IOException(String.format("Can't delete temporary file: %s", this.myEntries));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/zip/DiskBasedCenZipOutputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/zip/DiskBasedCenZipOutputStream";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEntry";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class EntryIterator
    implements ZipOutputStream.CloseableIterator<ZipEntry> {
        @NotNull
        private final InputStream myEntryIn;
        private int myEntriesRead;
        private final byte[] myLengthHolder;

        EntryIterator() throws FileNotFoundException {
            this.myEntryIn = new BufferedInputStream(new FileInputStream(DiskBasedCenZipOutputStream.this.myEntries));
            this.myLengthHolder = new byte[4];
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.myEntriesRead < DiskBasedCenZipOutputStream.this.myEntryCount;
            if (!hasNext) {
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    Loggers.MAINTENANCE.warn((Throwable)ioe);
                }
            }
            return hasNext;
        }

        @Override
        @NotNull
        public ZipEntry next() {
            ZipEntry zipEntry;
            if (!this.hasNext()) {
                throw new NoSuchElementException(String.format("Entries read: %d; entry count: %d", this.myEntriesRead, DiskBasedCenZipOutputStream.this.myEntryCount));
            }
            try {
                int sizeBytesRead = this.myEntryIn.read(this.myLengthHolder);
                if (sizeBytesRead < 4) {
                    throw new IOException(String.format("Read %d instead of %d byte(s) while reading metadata size of the entry %d out of %d", sizeBytesRead, 4, this.myEntriesRead + 1, DiskBasedCenZipOutputStream.this.myEntryCount));
                }
                int metadataSize = ByteBuffer.wrap(this.myLengthHolder).getInt();
                byte[] metadata = new byte[metadataSize];
                int metadataBytesRead = this.myEntryIn.read(metadata);
                if (metadataBytesRead < metadataSize) {
                    throw new IOException(String.format("Read %d instead of %d byte(s) while reading metadata of the entry %d out of %d", metadataBytesRead, metadataSize, this.myEntriesRead + 1, DiskBasedCenZipOutputStream.this.myEntryCount));
                }
                ++this.myEntriesRead;
                zipEntry = ZipEntry.fromByteArray(metadata);
            }
            catch (IOException ioe) {
                throw (ConcurrentModificationException)new ConcurrentModificationException(ioe.getMessage()).initCause(ioe);
            }
            if (zipEntry == null) {
                EntryIterator.$$$reportNull$$$0(0);
            }
            return zipEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void close() throws IOException {
            this.myEntryIn.close();
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/zip/DiskBasedCenZipOutputStream$EntryIterator", "next"));
        }
    }
}

