/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jetbrains.buildServer.util.ZipSlipAwareZipFile;
import jetbrains.buildServer.zip.AbstractZipReader;
import org.jetbrains.annotations.NotNull;

final class FileZipReader
extends AbstractZipReader {
    private ZipFile zip = null;
    private final Map<String, ZipEntry> directory = new LinkedHashMap<String, ZipEntry>();

    FileZipReader(File file) throws IOException {
        this.zip = new ZipSlipAwareZipFile(file, 1);
        this.readDirectory();
    }

    private void readDirectory() {
        this.directory.clear();
        Enumeration<? extends ZipEntry> zipEntriesEnumeration = this.zip.entries();
        while (zipEntriesEnumeration.hasMoreElements()) {
            ZipEntry entry = zipEntriesEnumeration.nextElement();
            String name = entry.getName();
            if (name == null || name.length() <= 0) continue;
            this.directory.put(name, entry);
        }
    }

    @Override
    protected Set<String> allNames() {
        return this.directory.keySet();
    }

    @Override
    public long getFileSize(String name) {
        ZipEntry entry = this.directory.get(name);
        return entry != null ? entry.getSize() : Long.MIN_VALUE;
    }

    @Override
    @NotNull
    public InputStream openBinaryFile(@NotNull String name) throws IOException {
        ZipEntry entry;
        if (name == null) {
            FileZipReader.$$$reportNull$$$0(0);
        }
        if ((entry = this.directory.get(name)) == null) {
            throw new FileNotFoundException("File (" + name + ") not found in the archive.");
        }
        InputStream inputStream = this.zip.getInputStream(entry);
        if (inputStream == null) {
            FileZipReader.$$$reportNull$$$0(1);
        }
        return inputStream;
    }

    @Override
    public void close() {
        try {
            this.zip.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close an opened-to-read zip archive: " + e.getMessage(), e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/zip/FileZipReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/zip/FileZipReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "openBinaryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openBinaryFile";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

