/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import jetbrains.buildServer.zip.AbstractZipWriter;
import jetbrains.buildServer.zip.DiskBasedCenZipOutputStream;
import jetbrains.buildServer.zip.MemoryConservativeZipOutputStream;
import jetbrains.buildServer.zip.Platform;
import jetbrains.buildServer.zip.StringEncoder;
import jetbrains.buildServer.zip.ZipEntry;
import jetbrains.buildServer.zip.ZipOutputStream;
import jetbrains.buildServer.zip.ZipWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MemoryConservativeZipWriter
extends AbstractZipWriter {
    @NotNull
    private final StringEncoder myEncoder;
    @NotNull
    final ZipOutputStream myOut;
    @NotNull
    private final OutputStream myEntryOut;

    private MemoryConservativeZipWriter(@NotNull ZipOutputStream out, @NotNull StringEncoder encoder) {
        if (out == null) {
            MemoryConservativeZipWriter.$$$reportNull$$$0(0);
        }
        if (encoder == null) {
            MemoryConservativeZipWriter.$$$reportNull$$$0(1);
        }
        this.myEncoder = encoder;
        this.myOut = out;
        this.myEntryOut = new EntryOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.myOut.close();
    }

    @NotNull
    static ZipWriter getDefault(@NotNull File file, int level) throws FileNotFoundException {
        if (file == null) {
            MemoryConservativeZipWriter.$$$reportNull$$$0(2);
        }
        StringEncoder encoder = new StringEncoder();
        MemoryConservativeZipWriter memoryConservativeZipWriter = new MemoryConservativeZipWriter(new MemoryConservativeZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)), encoder, MemoryConservativeZipWriter.getPlatform(), level), encoder);
        if (memoryConservativeZipWriter == null) {
            MemoryConservativeZipWriter.$$$reportNull$$$0(3);
        }
        return memoryConservativeZipWriter;
    }

    @NotNull
    static ZipWriter getDiskBasedCen(@NotNull File file, int level) throws IOException {
        if (file == null) {
            MemoryConservativeZipWriter.$$$reportNull$$$0(4);
        }
        StringEncoder encoder = new StringEncoder();
        MemoryConservativeZipWriter memoryConservativeZipWriter = new MemoryConservativeZipWriter(new DiskBasedCenZipOutputStream(file, encoder, MemoryConservativeZipWriter.getPlatform(), level), encoder);
        if (memoryConservativeZipWriter == null) {
            MemoryConservativeZipWriter.$$$reportNull$$$0(5);
        }
        return memoryConservativeZipWriter;
    }

    @Override
    @NotNull
    public OutputStream createBinaryFile(@NotNull String name, long mtimeMillis) throws IOException {
        if (name == null) {
            MemoryConservativeZipWriter.$$$reportNull$$$0(6);
        }
        ZipEntry zipEntry = new ZipEntry(name, this.myEncoder, mtimeMillis);
        this.myOut.putNextEntry(zipEntry);
        OutputStream outputStream = this.myEntryOut;
        if (outputStream == null) {
            MemoryConservativeZipWriter.$$$reportNull$$$0(7);
        }
        return outputStream;
    }

    @Override
    public void setArchiveComment(@Nullable String comment) {
        this.myOut.setComment(comment);
    }

    @NotNull
    private static Platform getPlatform() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            Platform platform = Platform.DOS;
            if (platform == null) {
                MemoryConservativeZipWriter.$$$reportNull$$$0(8);
            }
            return platform;
        }
        if (Arrays.asList("Windows 95", "Windows 98", "Windows Me").contains(osName)) {
            Platform platform = Platform.WINDOWS_9X;
            if (platform == null) {
                MemoryConservativeZipWriter.$$$reportNull$$$0(9);
            }
            return platform;
        }
        if (osName.startsWith("Windows ")) {
            Platform platform = Platform.WINDOWS_NT;
            if (platform == null) {
                MemoryConservativeZipWriter.$$$reportNull$$$0(10);
            }
            return platform;
        }
        if (osName.equals("Mac OS")) {
            Platform platform = Platform.MACINTOSH;
            if (platform == null) {
                MemoryConservativeZipWriter.$$$reportNull$$$0(11);
            }
            return platform;
        }
        if (osName.equals("Mac OS X")) {
            Platform platform = Platform.OS_X;
            if (platform == null) {
                MemoryConservativeZipWriter.$$$reportNull$$$0(12);
            }
            return platform;
        }
        if (Arrays.asList("Linux", "Solaris", "SunOS", "HP-UX", "AIX", "FreeBSD", "NetBSD", "OpenBSD", "DragonFlyBSD", "Irix", "Digital Unix", "OSF1").contains(osName) || osName.startsWith("NetWare ")) {
            Platform platform = Platform.UNIX;
            if (platform == null) {
                MemoryConservativeZipWriter.$$$reportNull$$$0(13);
            }
            return platform;
        }
        if (osName.equals("OS/2")) {
            Platform platform = Platform.HPFS;
            if (platform == null) {
                MemoryConservativeZipWriter.$$$reportNull$$$0(14);
            }
            return platform;
        }
        if (osName.equals("OpenVMS")) {
            Platform platform = Platform.VMS;
            if (platform == null) {
                MemoryConservativeZipWriter.$$$reportNull$$$0(15);
            }
            return platform;
        }
        Platform platform = Platform.DOS;
        if (platform == null) {
            MemoryConservativeZipWriter.$$$reportNull$$$0(16);
        }
        return platform;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/zip/MemoryConservativeZipWriter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/zip/MemoryConservativeZipWriter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiskBasedCen";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDiskBasedCen";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class EntryOutputStream
    extends FilterOutputStream {
        EntryOutputStream() {
            super(new BufferedOutputStream(MemoryConservativeZipWriter.this.myOut));
        }

        @Override
        public void write(@NotNull byte[] data, int offset, int length) throws IOException {
            if (data == null) {
                EntryOutputStream.$$$reportNull$$$0(0);
            }
            this.out.write(data, offset, length);
        }

        @Override
        public void close() throws IOException {
            this.flush();
            MemoryConservativeZipWriter.this.myOut.closeEntry();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/zip/MemoryConservativeZipWriter$EntryOutputStream", "write"));
        }
    }
}

