/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.nio.ByteBuffer;
import java.util.Calendar;
import jetbrains.buildServer.zip.StringEncoder;
import org.jetbrains.annotations.NotNull;

final class ZipEntry {
    private static final long DOS_TIME_BEFORE_1980 = 0x210000L;
    private static final long UPPER_DOS_TIME_BOUND = 4036608000000L;
    private static final int PRIMITIVE_DATA_LENGTH = 40;
    private final long myMtimeMillis;
    private long myCrc;
    private long mySize;
    private long myCompressedSize;
    private long myOffset;
    @NotNull
    private final byte[] myName;

    ZipEntry(@NotNull String name, @NotNull StringEncoder encoder, long mtimeMillis) {
        if (name == null) {
            ZipEntry.$$$reportNull$$$0(0);
        }
        if (encoder == null) {
            ZipEntry.$$$reportNull$$$0(1);
        }
        this.myCrc = -1L;
        this.mySize = -1L;
        this.myCompressedSize = -1L;
        this.myOffset = -1L;
        int length = name.length();
        if (length > 65535) {
            throw new IllegalArgumentException(String.format("Entry name too long: %s (%d)", name, length));
        }
        String escapedName = name.indexOf(92) == -1 ? name : name.replace('\\', '/');
        this.myName = encoder.getBytes(escapedName);
        this.myMtimeMillis = mtimeMillis;
    }

    /*
     * WARNING - void declaration
     */
    private ZipEntry(@NotNull byte[] name, long mtimeMillis, long crc, long size, long l, long l2) {
        void offset;
        void compressedSize;
        if (name == null) {
            ZipEntry.$$$reportNull$$$0(2);
        }
        this.myCrc = -1L;
        this.mySize = -1L;
        this.myCompressedSize = -1L;
        this.myOffset = -1L;
        this.myName = name;
        this.myMtimeMillis = mtimeMillis;
        this.myCrc = crc;
        this.mySize = size;
        this.myCompressedSize = compressedSize;
        this.myOffset = offset;
    }

    long getExtendedDosTime() {
        return ZipEntry.millisToExtendedDosTime(this.myMtimeMillis);
    }

    long getMtimeMillis() {
        return this.getExtendedDosTime() != 0x210000L && this.myMtimeMillis <= 4036608000000L ? -1L : this.myMtimeMillis;
    }

    long getCrc() {
        return this.myCrc;
    }

    void setCrc(long crc) {
        this.myCrc = crc;
    }

    long getSize() {
        return this.mySize;
    }

    void setSize(long size) {
        this.mySize = size;
    }

    long getCompressedSize() {
        return this.myCompressedSize;
    }

    void setCompressedSize(long compressedSize) {
        this.myCompressedSize = compressedSize;
    }

    long getOffset() {
        return this.myOffset;
    }

    void setOffset(long offset) {
        this.myOffset = offset;
    }

    @NotNull
    byte[] getName() {
        if (this.myName == null) {
            ZipEntry.$$$reportNull$$$0(3);
        }
        return this.myName;
    }

    int getMetadataSize() {
        return 40 + this.myName.length;
    }

    void write(@NotNull ByteBuffer buf) {
        if (buf == null) {
            ZipEntry.$$$reportNull$$$0(4);
        }
        buf.putLong(this.myMtimeMillis);
        buf.putLong(this.myCrc);
        buf.putLong(this.mySize);
        buf.putLong(this.myCompressedSize);
        buf.putLong(this.myOffset);
        buf.put(this.myName);
    }

    @NotNull
    byte[] toByteArray() {
        byte[] metadata = new byte[this.getMetadataSize()];
        this.write(ByteBuffer.wrap(metadata));
        if (metadata == null) {
            ZipEntry.$$$reportNull$$$0(5);
        }
        return metadata;
    }

    @NotNull
    static ZipEntry fromByteArray(@NotNull byte[] metadata) {
        if (metadata == null) {
            ZipEntry.$$$reportNull$$$0(6);
        }
        ByteBuffer buf = ByteBuffer.wrap(metadata);
        long mtimeMillis = buf.getLong();
        long crc = buf.getLong();
        long size = buf.getLong();
        long compressedSize = buf.getLong();
        long offset = buf.getLong();
        byte[] name = new byte[metadata.length - 40];
        buf.get(name);
        ZipEntry zipEntry = new ZipEntry(name, mtimeMillis, crc, size, compressedSize, offset);
        if (zipEntry == null) {
            ZipEntry.$$$reportNull$$$0(7);
        }
        return zipEntry;
    }

    private static long millisToDosTime(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        int year = calendar.get(1);
        return year < 1980 ? 0x210000L : (long)(year - 1980 << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1);
    }

    private static long millisToExtendedDosTime(long millis) {
        if (millis < 0L) {
            return 0x210000L;
        }
        long dosTime = ZipEntry.millisToDosTime(millis);
        return dosTime != 0x210000L ? dosTime + (millis % 2000L << 32) : 0x210000L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoder";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/zip/ZipEntry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/zip/ZipEntry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toByteArray";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromByteArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

