/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.zip.ZipReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipExtractor {
    private final ZipReader myZipReader;

    public ZipExtractor(ZipReader zipReader) {
        this.myZipReader = zipReader;
    }

    public void extractDirectory(@NotNull String zipPath, @NotNull File targetDirectory) throws IOException {
        if (zipPath == null) {
            ZipExtractor.$$$reportNull$$$0(0);
        }
        if (targetDirectory == null) {
            ZipExtractor.$$$reportNull$$$0(1);
        }
        File extractedDir = FileUtil.createDir((File)targetDirectory);
        for (String directoryFile : this.myZipReader.listDirectoryFiles(zipPath)) {
            File file = new File(extractedDir, directoryFile);
            String fileZipPath = zipPath.isEmpty() ? directoryFile : zipPath + "/" + directoryFile;
            this.extractFile(fileZipPath, file);
        }
    }

    public void extractFile(@NotNull String zipPath, @NotNull File targetFile) throws IOException {
        if (zipPath == null) {
            ZipExtractor.$$$reportNull$$$0(2);
        }
        if (targetFile == null) {
            ZipExtractor.$$$reportNull$$$0(3);
        }
        this.extractFile(zipPath, targetFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractFile(@NotNull String zipPath, @NotNull File targetFile, @Nullable TCStreamUtil.ProgressIncrementListener progressListener) throws IOException {
        if (zipPath == null) {
            ZipExtractor.$$$reportNull$$$0(4);
        }
        if (targetFile == null) {
            ZipExtractor.$$$reportNull$$$0(5);
        }
        FileUtil.createParentDirs((File)targetFile);
        try (InputStream input = this.myZipReader.openBinaryFile(zipPath);
             FileOutputStream output = new FileOutputStream(targetFile);){
            TCStreamUtil.writeBinary((InputStream)input, (OutputStream)output, (TCStreamUtil.WriteProgressListener)progressListener, (long)0L);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/zip/ZipExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractDirectory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

