/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.zip;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import jetbrains.buildServer.zip.Platform;
import jetbrains.buildServer.zip.StringEncoder;
import jetbrains.buildServer.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZipOutputStream
extends FilterOutputStream {
    @NotNull
    private final Deflater myDeflater;
    @NotNull
    private final byte[] myBuf;
    @Nullable
    private ZipEntry myCurrentEntry;
    @NotNull
    private final Checksum myCrc;
    private long myBytesWritten;
    @Nullable
    private byte[] myComment;
    private boolean myFinished;
    private boolean myClosed;
    @NotNull
    private final StringEncoder myEncoder;
    @NotNull
    private final Platform myPlatform;

    private void ensureOpen() throws IOException {
        if (this.myClosed) {
            throw new IOException("Stream closed");
        }
    }

    ZipOutputStream(@NotNull OutputStream out, @NotNull StringEncoder encoder, @NotNull Platform platform, int level) {
        if (out == null) {
            ZipOutputStream.$$$reportNull$$$0(0);
        }
        if (encoder == null) {
            ZipOutputStream.$$$reportNull$$$0(1);
        }
        if (platform == null) {
            ZipOutputStream.$$$reportNull$$$0(2);
        }
        super(out);
        this.myDeflater = new Deflater(-1, true);
        this.myBuf = new byte[512];
        this.myCrc = new CRC32();
        this.myEncoder = encoder;
        this.myPlatform = platform;
        this.myDeflater.setLevel(level);
    }

    final void setComment(@Nullable String comment) {
        if (comment != null) {
            byte[] encodedComment = this.myEncoder.getBytes(comment);
            this.myComment = encodedComment;
            if (encodedComment.length > 65535) {
                throw new IllegalArgumentException("ZIP file comment too long");
            }
        }
    }

    final void putNextEntry(@NotNull ZipEntry entry) throws IOException {
        if (entry == null) {
            ZipOutputStream.$$$reportNull$$$0(3);
        }
        this.ensureOpen();
        if (this.myCurrentEntry != null) {
            this.closeEntry();
        }
        entry.setOffset(this.myBytesWritten);
        this.myCurrentEntry = entry;
        this.writeLoc(entry);
    }

    final void closeEntry() throws IOException {
        this.ensureOpen();
        ZipEntry entry = this.myCurrentEntry;
        if (entry != null) {
            this.myDeflater.finish();
            while (!this.myDeflater.finished()) {
                this.deflate();
            }
            entry.setSize(this.myDeflater.getBytesRead());
            entry.setCompressedSize(this.myDeflater.getBytesWritten());
            entry.setCrc(this.myCrc.getValue());
            this.writeExt(entry);
            this.myDeflater.reset();
            this.myBytesWritten += entry.getCompressedSize();
            this.myCrc.reset();
            this.addEntry(entry);
            this.myCurrentEntry = null;
        }
    }

    @Override
    public final void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)(b & 0xFF)};
        this.write(data, 0, 1);
    }

    @Override
    public final void write(@NotNull byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            ZipOutputStream.$$$reportNull$$$0(4);
        }
        this.ensureOpen();
        if (offset < 0 || length < 0 || offset > data.length - length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        if (this.myCurrentEntry == null) {
            throw new ZipException("No current ZIP entry");
        }
        if (this.myDeflater.finished()) {
            throw new IOException("Write beyond the end of stream");
        }
        this.myDeflater.setInput(data, offset, length);
        Thread currentThread = Thread.currentThread();
        while (!this.myDeflater.needsInput()) {
            this.deflate();
            if (!currentThread.isInterrupted()) continue;
            throw new InterruptedIOException();
        }
        this.myCrc.update(data, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() throws IOException {
        this.ensureOpen();
        if (this.myFinished) {
            return;
        }
        if (this.myCurrentEntry != null) {
            this.closeEntry();
        }
        long cenOffset = this.myBytesWritten;
        try (Iterator it = this.getEntries().iterator();){
            while (it.hasNext()) {
                ZipEntry entry = (ZipEntry)it.next();
                this.writeCen(entry);
            }
        }
        this.writeEnd(cenOffset, this.myBytesWritten - cenOffset);
        this.clearEntries();
        this.myFinished = true;
    }

    @Override
    public final void close() throws IOException {
        if (!this.myClosed) {
            this.finish();
            this.myDeflater.end();
            this.out.close();
            this.myClosed = true;
        }
    }

    private void writeLoc(@NotNull ZipEntry entry) throws IOException {
        if (entry == null) {
            ZipOutputStream.$$$reportNull$$$0(5);
        }
        this.writeInt(67324752L);
        this.writeShort(20);
        this.writeShort(2056);
        this.writeShort(8);
        this.writeInt(entry.getExtendedDosTime());
        this.writeInt(0L);
        this.writeInt(0L);
        this.writeInt(0L);
        byte[] name = entry.getName();
        this.writeShort(name.length);
        long mtimeMillis = entry.getMtimeMillis();
        boolean extendedMtimeAvailable = mtimeMillis != -1L;
        int extraDataLength = extendedMtimeAvailable ? 9 : 0;
        this.writeShort(extraDataLength);
        this.writeBytes(name);
        if (extendedMtimeAvailable) {
            this.writeShort(21589);
            this.writeShort(5);
            this.writeByte(1);
            this.writeInt(ZipOutputStream.millisToUnixTime(mtimeMillis));
        }
    }

    private void writeExt(@NotNull ZipEntry entry) throws IOException {
        if (entry == null) {
            ZipOutputStream.$$$reportNull$$$0(6);
        }
        this.writeInt(134695760L);
        this.writeInt(entry.getCrc());
        long size = entry.getSize();
        long compressedSize = entry.getCompressedSize();
        if (size >= 0xFFFFFFFFL || compressedSize >= 0xFFFFFFFFL) {
            this.writeLong(compressedSize);
            this.writeLong(size);
        } else {
            this.writeInt(compressedSize);
            this.writeInt(size);
        }
    }

    private void writeCen(@NotNull ZipEntry entry) throws IOException {
        long mtimeMillis;
        boolean extendedMtimeAvailable;
        if (entry == null) {
            ZipOutputStream.$$$reportNull$$$0(7);
        }
        long zip32CompressedSize = entry.getCompressedSize();
        long zip32Size = entry.getSize();
        long zip32Offset = entry.getOffset();
        int zip64ExtraDataLength = 0;
        boolean hasZip64 = false;
        if (entry.getCompressedSize() >= 0xFFFFFFFFL) {
            zip32CompressedSize = 0xFFFFFFFFL;
            zip64ExtraDataLength += 8;
            hasZip64 = true;
        }
        if (entry.getSize() >= 0xFFFFFFFFL) {
            zip32Size = 0xFFFFFFFFL;
            zip64ExtraDataLength += 8;
            hasZip64 = true;
        }
        if (entry.getOffset() >= 0xFFFFFFFFL) {
            zip32Offset = 0xFFFFFFFFL;
            zip64ExtraDataLength += 8;
            hasZip64 = true;
        }
        this.writeInt(33639248L);
        int versionMadeBy = hasZip64 ? 45 : 20;
        int versionToExtract = hasZip64 ? 45 : 20;
        this.writeShort(this.myPlatform.ordinal() << 8 | versionMadeBy);
        this.writeShort(versionToExtract);
        this.writeShort(2056);
        this.writeShort(8);
        this.writeInt(entry.getExtendedDosTime());
        this.writeInt(entry.getCrc());
        this.writeInt(zip32CompressedSize);
        this.writeInt(zip32Size);
        byte[] name = entry.getName();
        this.writeShort(name.length);
        int extraDataLength = 0;
        if (hasZip64) {
            extraDataLength += zip64ExtraDataLength + 4;
        }
        boolean bl = extendedMtimeAvailable = (mtimeMillis = entry.getMtimeMillis()) != -1L;
        if (extendedMtimeAvailable) {
            extraDataLength += 9;
        }
        this.writeShort(extraDataLength);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(0L);
        this.writeInt(zip32Offset);
        this.writeBytes(name);
        if (hasZip64) {
            this.writeShort(1);
            this.writeShort(zip64ExtraDataLength);
            if (zip32Size == 0xFFFFFFFFL) {
                this.writeLong(entry.getSize());
            }
            if (zip32CompressedSize == 0xFFFFFFFFL) {
                this.writeLong(entry.getCompressedSize());
            }
            if (zip32Offset == 0xFFFFFFFFL) {
                this.writeLong(entry.getOffset());
            }
        }
        if (extendedMtimeAvailable) {
            this.writeShort(21589);
            this.writeShort(5);
            this.writeByte(1);
            this.writeInt(ZipOutputStream.millisToUnixTime(mtimeMillis));
        }
    }

    private void writeEnd(long cenOffset, long cenLength) throws IOException {
        int entryCount;
        int zip32EntryCount;
        long zip32CenOffset;
        boolean hasZip64 = false;
        long zip32CenLength = cenLength;
        if (zip32CenLength >= 0xFFFFFFFFL) {
            zip32CenLength = 0xFFFFFFFFL;
            hasZip64 = true;
        }
        if ((zip32CenOffset = cenOffset) >= 0xFFFFFFFFL) {
            zip32CenOffset = 0xFFFFFFFFL;
            hasZip64 = true;
        }
        if ((zip32EntryCount = (entryCount = this.getEntryCount())) >= 65535) {
            zip32EntryCount = 65535;
            hasZip64 = true;
        }
        if (hasZip64) {
            long endOffset = this.myBytesWritten;
            this.writeInt(101075792L);
            this.writeLong(44L);
            this.writeShort(45);
            this.writeShort(45);
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeLong(entryCount);
            this.writeLong(entryCount);
            this.writeLong(cenLength);
            this.writeLong(cenOffset);
            this.writeInt(117853008L);
            this.writeInt(0L);
            this.writeLong(endOffset);
            this.writeInt(1L);
        }
        this.writeInt(101010256L);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(zip32EntryCount);
        this.writeShort(zip32EntryCount);
        this.writeInt(zip32CenLength);
        this.writeInt(zip32CenOffset);
        if (this.myComment != null) {
            this.writeShort(this.myComment.length);
            this.writeBytes(this.myComment);
        } else {
            this.writeShort(0);
        }
    }

    private void writeByte(int b) throws IOException {
        this.out.write(b & 0xFF);
        ++this.myBytesWritten;
    }

    private void writeShort(int s) throws IOException {
        this.out.write(s & 0xFF);
        this.out.write(s >>> 8 & 0xFF);
        this.myBytesWritten += 2L;
    }

    private void writeInt(long i) throws IOException {
        this.out.write((int)(i & 0xFFL));
        this.out.write((int)(i >>> 8 & 0xFFL));
        this.out.write((int)(i >>> 16 & 0xFFL));
        this.out.write((int)(i >>> 24 & 0xFFL));
        this.myBytesWritten += 4L;
    }

    private void writeLong(long l) throws IOException {
        this.out.write((int)(l & 0xFFL));
        this.out.write((int)(l >>> 8 & 0xFFL));
        this.out.write((int)(l >>> 16 & 0xFFL));
        this.out.write((int)(l >>> 24 & 0xFFL));
        this.out.write((int)(l >>> 32 & 0xFFL));
        this.out.write((int)(l >>> 40 & 0xFFL));
        this.out.write((int)(l >>> 48 & 0xFFL));
        this.out.write((int)(l >>> 56 & 0xFFL));
        this.myBytesWritten += 8L;
    }

    private void writeBytes(@NotNull byte[] data) throws IOException {
        if (data == null) {
            ZipOutputStream.$$$reportNull$$$0(8);
        }
        int length = data.length;
        this.out.write(data, 0, length);
        this.myBytesWritten += (long)length;
    }

    private void deflate() throws IOException {
        int compressedSize = this.myDeflater.deflate(this.myBuf, 0, this.myBuf.length);
        if (compressedSize > 0) {
            this.out.write(this.myBuf, 0, compressedSize);
        }
    }

    private static long millisToUnixTime(long millis) {
        return millis / 1000L;
    }

    abstract void addEntry(@NotNull ZipEntry var1) throws IOException;

    abstract int getEntryCount();

    @NotNull
    abstract CloseableIterable<ZipEntry> getEntries() throws IOException;

    abstract void clearEntries() throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/zip/ZipOutputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "putNextEntry";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "writeLoc";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExt";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "writeCen";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "writeBytes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface CloseableIterator<T>
    extends Iterator<T>,
    Closeable {
    }

    static interface CloseableIterable<T>
    extends Iterable<T> {
        @Override
        @NotNull
        public CloseableIterator<T> iterator();
    }
}

