/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.BuildType;
import org.jetbrains.annotations.NotNull;

public class AddToQueueResult {
    @NotNull
    private final Map<String, String> myFailureReason = new HashMap<String, String>();
    @NotNull
    private final Map<String, String> myWarningReason = new HashMap<String, String>();

    public void failedToAdd(String buildTypeId, String reason) {
        if (reason != null) {
            this.myFailureReason.put(buildTypeId, reason);
        }
    }

    public void warning(String buildTypeId, String reason) {
        if (reason != null) {
            this.myWarningReason.put(buildTypeId, reason);
        }
    }

    public boolean isFailed(String buildTypeId) {
        return this.myFailureReason.get(buildTypeId) != null;
    }

    public boolean hasWarning(String buildTypeId) {
        return this.myWarningReason.get(buildTypeId) != null;
    }

    public String getFailureReason(String buildTypeId) {
        return this.myFailureReason.get(buildTypeId);
    }

    public String getWarning(String buildTypeId) {
        return this.myWarningReason.get(buildTypeId);
    }

    public boolean isSuccessful(String buildTypeId) {
        return !this.isFailed(buildTypeId);
    }

    public boolean hasFailures() {
        return this.myFailureReason.size() > 0;
    }

    public String formatReasons(Collection<BuildType> selectedBuildTypes) {
        HashMap<String, List<BuildType>> buildTypesWithFailuresGroupedByReason = new HashMap<String, List<BuildType>>();
        HashMap<String, List<BuildType>> buildTypesWithWarningsGroupedByReason = new HashMap<String, List<BuildType>>();
        ArrayList<BuildType> buildTypesWithoutErrors = new ArrayList<BuildType>();
        for (BuildType type : selectedBuildTypes) {
            String buildTypeId = type.getBuildTypeId();
            String fReason = this.myFailureReason.get(buildTypeId);
            String wReason = this.myWarningReason.get(buildTypeId);
            if (fReason == null && wReason == null) {
                buildTypesWithoutErrors.add(type);
                continue;
            }
            if (fReason != null) {
                this.addToGroup(type, fReason, buildTypesWithFailuresGroupedByReason);
                continue;
            }
            this.addToGroup(type, wReason, buildTypesWithWarningsGroupedByReason);
        }
        StringBuilder sb = new StringBuilder();
        if (!buildTypesWithFailuresGroupedByReason.isEmpty()) {
            sb.append("Cannot add to queue some of the requested build configurations:\n");
            this.appendGroupedReasons(sb, buildTypesWithFailuresGroupedByReason);
        }
        if (!buildTypesWithWarningsGroupedByReason.isEmpty()) {
            this.appendNewLineIfNeeded(sb);
            sb.append("Some of the requested build configurations were added to queue with warnings:\n");
            this.appendGroupedReasons(sb, buildTypesWithWarningsGroupedByReason);
        }
        if (!buildTypesWithoutErrors.isEmpty()) {
            String s = buildTypesWithoutErrors.size() == 1 ? "" : "s";
            String w = buildTypesWithoutErrors.size() == 1 ? "was" : "were";
            this.appendNewLineIfNeeded(sb);
            sb.append("The following build configuration").append(s).append(" ").append(w).append(" successfully added to queue:\n");
            this.appendNames(sb, buildTypesWithoutErrors);
        }
        return sb.toString();
    }

    private void appendGroupedReasons(StringBuilder sb, Map<String, List<BuildType>> buildTypesGroupedByReason) {
        for (Map.Entry<String, List<BuildType>> entry : buildTypesGroupedByReason.entrySet()) {
            List<BuildType> buildTypes = entry.getValue();
            if (buildTypes.isEmpty()) continue;
            String s = buildTypes.size() == 1 ? "" : "s";
            sb.append("\nBuild configuration").append(s).append(": ");
            this.appendNames(sb, buildTypes);
            sb.append("\nReason: ").append(entry.getKey()).append("\n");
        }
    }

    private void appendNewLineIfNeeded(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append("\n");
        }
    }

    private void addToGroup(BuildType type, String reason, Map<String, List<BuildType>> buildTypesGroupedByReason) {
        if (!buildTypesGroupedByReason.containsKey(reason)) {
            buildTypesGroupedByReason.put(reason, new ArrayList());
        }
        buildTypesGroupedByReason.get(reason).add(type);
    }

    private void appendNames(StringBuilder sb, List<BuildType> buildTypes) {
        Iterator<BuildType> it = buildTypes.iterator();
        if (it.hasNext()) {
            sb.append(it.next().getFullName());
        }
        while (it.hasNext()) {
            sb.append(", ").append(it.next().getFullName());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddToQueueResult)) {
            return false;
        }
        AddToQueueResult that = (AddToQueueResult)o;
        return this.myFailureReason.equals(that.myFailureReason) && this.myWarningReason.equals(that.myWarningReason);
    }

    public int hashCode() {
        int result = this.myFailureReason.hashCode();
        result = 31 * result + this.myWarningReason.hashCode();
        return result;
    }
}

