/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.Build;
import jetbrains.buildServer.BuildInstanceData;
import jetbrains.buildServer.BuildProject;
import jetbrains.buildServer.BuildRunnerData;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.BuildTypeData;
import jetbrains.buildServer.ProjectData;
import jetbrains.buildServer.serverSide.BuildRunnerDescriptor;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.users.UserData;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.vcs.VcsModification;
import jetbrains.buildServer.vcs.VcsModificationData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFactory {
    private final Map<Object, Object> myCreated = new HashMap<Object, Object>();

    public BuildTypeData createData(BuildType buildType, BuildTypeInstancesFilter loadInstances, @Nullable User user) {
        if (!this.myCreated.containsKey(buildType)) {
            this.myCreated.put(buildType, this.createBuildTypeDataOn(buildType));
        }
        BuildTypeData data = (BuildTypeData)this.myCreated.get(buildType);
        if (!loadInstances.loadInstances(buildType)) {
            return data;
        }
        if (!data.lastFinishedLoaded()) {
            data.loadLastFinished(this.createData(buildType.getLastChangesFinished(), user));
        }
        if (!data.runningLoaded()) {
            data.loadRunning(BuildInstanceData.convertBuildsToDatas(buildType.getRunningBuilds(user), this, user));
        }
        if (!data.isLastSuccessfullyFinishedLoaded()) {
            data.loadLastSuccessfullyFinished(this.createData(buildType.getLastChangesSuccessfullyFinished(), user));
        }
        return data;
    }

    public BuildInstanceData createData(Build instance, @Nullable User user) {
        if (instance == null) {
            return null;
        }
        BuildType bt = instance.getBuildType();
        if (bt == null) {
            return null;
        }
        if (!this.myCreated.containsKey(instance)) {
            this.myCreated.put(instance, BuildInstanceData.createOn(instance, this.createData(bt, BuildTypeInstancesFilter.FALSE, user)));
        }
        return (BuildInstanceData)this.myCreated.get(instance);
    }

    public VcsModificationData createData(VcsModification modification) {
        if (!this.myCreated.containsKey(modification)) {
            this.myCreated.put(modification, DataFactory.createOn(modification));
        }
        return (VcsModificationData)this.myCreated.get(modification);
    }

    public ProjectData createData(BuildProject project, BuildTypeInstancesFilter loadInstances, Filter<BuildType> buildTypeFilter, User user) {
        if (!this.myCreated.containsKey(project)) {
            this.myCreated.put(project, ProjectData.createOn(project, this, loadInstances, buildTypeFilter, user));
        }
        return (ProjectData)this.myCreated.get(project);
    }

    public UserData createData(User userById) {
        if (userById == null) {
            return null;
        }
        if (!this.myCreated.containsKey(userById)) {
            this.myCreated.put(userById, UserData.createOn(userById));
        }
        return (UserData)this.myCreated.get(userById);
    }

    @NotNull
    protected BuildTypeData createBuildTypeDataOn(@NotNull BuildType buildType) {
        if (buildType == null) {
            DataFactory.$$$reportNull$$$0(0);
        }
        BuildTypeData buildTypeData = BuildTypeData.createOn(buildType);
        if (buildTypeData == null) {
            DataFactory.$$$reportNull$$$0(1);
        }
        return buildTypeData;
    }

    @NotNull
    public BuildRunnerData createBuildRunnerDataOn(@NotNull BuildRunnerDescriptor descriptor) {
        if (descriptor == null) {
            DataFactory.$$$reportNull$$$0(2);
        }
        BuildRunnerData buildRunnerData = BuildRunnerData.createOn(descriptor);
        if (buildRunnerData == null) {
            DataFactory.$$$reportNull$$$0(3);
        }
        return buildRunnerData;
    }

    private static VcsModificationData createOn(VcsModification vcsModification) {
        return new VcsModificationData(vcsModification.getId(), vcsModification.getUserName(), vcsModification.getDescription(), vcsModification.getVcsDate(), Collections.emptyList(), vcsModification.getVersion(), vcsModification.getDisplayVersion(), vcsModification.isPersonal(), vcsModification.getChangeCount(), vcsModification.getVersionControlName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/DataFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/DataFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildTypeDataOn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildRunnerDataOn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTypeDataOn";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBuildRunnerDataOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface BuildTypeInstancesFilter {
        public static final BuildTypeInstancesFilter TRUE = new BuildTypeInstancesFilter(){

            @Override
            public boolean loadInstances(BuildType type) {
                return true;
            }
        };
        public static final BuildTypeInstancesFilter FALSE = new BuildTypeInstancesFilter(){

            @Override
            public boolean loadInstances(BuildType type) {
                return false;
            }
        };

        public boolean loadInstances(BuildType var1);
    }
}

