/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.buildServer.BuildProject;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.BuildTypeData;
import jetbrains.buildServer.DataFactory;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.Nullable;

public class ProjectData {
    private final String myProjectId;
    private final String myExternalId;
    @Nullable
    private final String myParentProjectId;
    private final String myName;
    private final String myDescription;
    private final Status myStatus;
    private final List<BuildTypeData> myBuildTypes;

    public ProjectData(String projectId, String externalId, @Nullable String parentProjectId, String name, String description, Status status, List<BuildTypeData> buildTypes) {
        this.myProjectId = projectId;
        this.myExternalId = externalId;
        this.myParentProjectId = parentProjectId;
        this.myName = name;
        this.myDescription = description;
        this.myStatus = status;
        this.myBuildTypes = buildTypes;
    }

    public List<BuildTypeData> getBuildTypes() {
        return this.myBuildTypes;
    }

    public String getProjectId() {
        return this.myProjectId;
    }

    public String getExternalId() {
        return this.myExternalId;
    }

    @Nullable
    public String getParentProjectId() {
        return this.myParentProjectId;
    }

    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public Status getStatus() {
        return this.myStatus;
    }

    public static ProjectData createOn(BuildProject project, DataFactory factory, DataFactory.BuildTypeInstancesFilter loadInstances, Filter<BuildType> buildTypeFilter, User user) {
        return new ProjectData(project.getProjectId(), project.getExternalId(), project.getParentProjectId(), project.getName(), project.getDescription(), project.getStatus(), BuildTypeData.createDataListOn(project.getOwnBuildTypes(), factory, loadInstances, buildTypeFilter, user));
    }

    public static List<ProjectData> createDataListOn(Collection<BuildProject> list, DataFactory factory, DataFactory.BuildTypeInstancesFilter loadInstances, @Nullable User user) {
        return ProjectData.createDataListOn(list, factory, loadInstances, (Filter<BuildType>)CollectionsUtil.ACCEPT_ALL, user);
    }

    public static List<ProjectData> createDataListOn(Collection<BuildProject> list, DataFactory factory, DataFactory.BuildTypeInstancesFilter loadInstances, Filter<BuildType> buildTypeFilter, User user) {
        ArrayList<ProjectData> result = new ArrayList<ProjectData>();
        for (BuildProject project : list) {
            result.add(factory.createData(project, loadInstances, buildTypeFilter, user));
        }
        return result;
    }
}

