/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import jetbrains.buildServer.ExceptionUtil;
import jetbrains.buildServer.IncompatiblePluginError;
import jetbrains.buildServer.TeamCitySnapshot;
import jetbrains.buildServer.TeamCityState;
import jetbrains.buildServer.serverSide.auth.AuthenticationFailedException;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import org.apache.log4j.Logger;

public abstract class TeamCityCommand
implements Runnable {
    protected static final Logger LOG = Logger.getLogger(TeamCityCommand.class);
    private final TeamCitySnapshot myServer;

    public TeamCityCommand(TeamCitySnapshot server) {
        if (server == null) {
            throw new IllegalArgumentException("Could not run command on empty Snapshot");
        }
        this.myServer = server;
    }

    @Override
    public final void run() {
        try {
            this.getServer().setProblem(null);
            this.execute();
        }
        catch (Throwable e) {
            this.handleError(e);
        }
    }

    public TeamCitySnapshot getServer() {
        return this.myServer;
    }

    protected void handleError(Throwable e) {
        LOG.error((Object)e, e);
        Throwable cause = ExceptionUtil.getAllCause(e, UnknownHostException.class, SocketTimeoutException.class, AuthenticationFailedException.class, SocketException.class, IncompatiblePluginError.class);
        this.getServer().setProblem(cause);
        if (cause instanceof SocketTimeoutException) {
            this.getServer().addModificationTrackerAlarm();
            return;
        }
        if (cause instanceof AuthenticationFailedException) {
            this.getServer().setState(TeamCityState.AUTHENTICATION_FAILED);
            throw new RuntimeException(e);
        }
        if (cause instanceof SocketException) {
            this.getServer().setState(TeamCityState.SERVER_UNAVAILABLE);
            throw new RemoteCallException(e.getLocalizedMessage(), e);
        }
        if (cause instanceof IncompatiblePluginError) {
            this.getServer().setState(TeamCityState.INCOMPATIBLE_VERSION);
            throw new RuntimeException(e);
        }
        if (cause instanceof UnknownHostException) {
            this.getServer().setState(TeamCityState.SERVER_UNAVAILABLE);
            throw new RemoteCallException(e.getLocalizedMessage(), e);
        }
        this.getServer().setState(TeamCityState.LOGGED_OUT_BY_SYSTEM);
    }

    public abstract void execute() throws AuthenticationFailedException, IncompatiblePluginError, RemoteCallException;
}

