/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.BuildProject;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.UserChangeInfo;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.serverSide.tracker.SubscriptionsCollection;
import jetbrains.buildServer.serverSide.tracker.TrackerEventType;
import jetbrains.buildServer.tests.TestData;
import jetbrains.buildServer.users.User;
import org.jetbrains.annotations.NotNull;

public class TeamServerSummary {
    private final Map<String, BuildProject> myProjects;
    private final Map<String, BuildProject> myAdditionalProjects;
    private final List<UserChangeInfo> myChanges;
    private final List<UserChangeInfo> myPersonalChanges;
    private final Date myCreatedDate = new Date();
    private final Set<String> myWatchedConfigurationIds;
    private final Status myWatchedBuildsStatus;
    private final Map<String, Status> myProjectStatuses;
    private final Map<String, List<TestData>> myTestsWithInvestigation;
    private final boolean myResponsibleExists;
    private final Collection<String> myVisibleProjectIds;
    private final Status myChangesStatus;
    private final int myFilteredOutProjectsCount;
    private final int myFilteredOutChangesCount;
    private int mySummaryCounter;

    public TeamServerSummary(List<BuildProject> projects, List<BuildProject> additionalProjects, Collection<String> visibleProjectIds, List<UserChangeInfo> changes, List<UserChangeInfo> personalChanges, Set<String> watchedConfigurationIds, Status watchedBuildsStatus, Map<String, Status> projectStatuses, Map<String, List<TestData>> testsWithInvestigation, boolean responsibleExists, Status changesStatus, int filteredOutProjectsCount, int filteredOutChangesCount, int counter) {
        this.myProjects = new HashMap<String, BuildProject>();
        for (BuildProject project : projects) {
            this.myProjects.put(project.getProjectId(), project);
        }
        this.myAdditionalProjects = new HashMap<String, BuildProject>();
        for (BuildProject project : additionalProjects) {
            this.myAdditionalProjects.put(project.getProjectId(), project);
        }
        this.myChanges = changes;
        this.myPersonalChanges = personalChanges;
        this.myWatchedConfigurationIds = watchedConfigurationIds;
        this.myWatchedBuildsStatus = watchedBuildsStatus;
        this.myProjectStatuses = projectStatuses;
        this.myTestsWithInvestigation = testsWithInvestigation;
        this.myResponsibleExists = responsibleExists;
        this.myVisibleProjectIds = visibleProjectIds;
        this.myChangesStatus = changesStatus;
        this.myFilteredOutProjectsCount = filteredOutProjectsCount;
        this.myFilteredOutChangesCount = filteredOutChangesCount;
        this.mySummaryCounter = counter;
    }

    public Collection<BuildProject> getProjects() {
        return this.myProjects.values();
    }

    @NotNull
    public BuildProject getRootProject() {
        BuildProject rootProject = this.findProjectById(BuildProject.ROOT_PROJECT_ID, true);
        if (rootProject == null) {
            throw new RuntimeException("Summary does not contain root project");
        }
        BuildProject buildProject = rootProject;
        if (buildProject == null) {
            TeamServerSummary.$$$reportNull$$$0(0);
        }
        return buildProject;
    }

    public List<BuildProject> getAllProjects() {
        ArrayList<BuildProject> result = new ArrayList<BuildProject>();
        result.addAll(this.myProjects.values());
        result.addAll(this.myAdditionalProjects.values());
        return result;
    }

    public List<UserChangeInfo> getChanges() {
        return this.myChanges;
    }

    public List<UserChangeInfo> getPersonalChanges() {
        return this.myPersonalChanges;
    }

    public Date getCreatedDate() {
        return this.myCreatedDate;
    }

    public Status getStatus(BuildProject project) {
        Status status = this.myProjectStatuses.get(project.getProjectId());
        return status == null ? Status.UNKNOWN : status;
    }

    public Status getStatus(BuildType configuration) {
        if (this.getWatchedConfigurationIds().contains(configuration.getBuildTypeId())) {
            return configuration.getStatus();
        }
        return Status.UNKNOWN;
    }

    public boolean responsibleExists() {
        return this.myResponsibleExists;
    }

    public Status getStatus() {
        return this.myWatchedBuildsStatus;
    }

    public boolean projectIsVisible(BuildProject project) {
        return this.myVisibleProjectIds.contains(project.getProjectId());
    }

    public synchronized Set<String> getWatchedConfigurationIds() {
        return this.myWatchedConfigurationIds;
    }

    public boolean configurationIsVisible(BuildType buildConfiguration) {
        return this.getWatchedConfigurationIds().contains(buildConfiguration.getBuildTypeId());
    }

    public Status getChangesStatus() {
        return this.myChangesStatus;
    }

    public BuildType findConfigurationById(String id) {
        if (id == null) {
            return null;
        }
        for (BuildProject project : this.myProjects.values()) {
            for (BuildType buildType : project.getOwnBuildTypes()) {
                if (!id.equals(buildType.getBuildTypeId())) continue;
                return buildType;
            }
        }
        return null;
    }

    public BuildProject findProjectById(String id, boolean findInAdditionalProjects) {
        if (id == null) {
            return null;
        }
        BuildProject buildProject = this.myProjects.get(id);
        if (buildProject != null) {
            return buildProject;
        }
        if (findInAdditionalProjects) {
            return this.myAdditionalProjects.get(id);
        }
        return null;
    }

    public Collection<String> getVisibleProjectIds() {
        return this.myVisibleProjectIds;
    }

    public Map<String, Status> getProjectStatusMap() {
        return this.myProjectStatuses;
    }

    public Collection<BuildProject> getAdditionalProjects() {
        return this.myAdditionalProjects.values();
    }

    public Map<String, List<TestData>> getTestsWithInvestigation() {
        return this.myTestsWithInvestigation;
    }

    public int getFilteredOutProjectsCount() {
        return this.myFilteredOutProjectsCount;
    }

    public int getFilteredOutChangesCount() {
        return this.myFilteredOutChangesCount;
    }

    public void setSummaryCounter(int summaryCounter) {
        this.mySummaryCounter = summaryCounter;
    }

    public int getSummaryCounter() {
        return this.mySummaryCounter;
    }

    public SubscriptionsCollection createSubscription(@NotNull User user) {
        if (user == null) {
            TeamServerSummary.$$$reportNull$$$0(1);
        }
        SubscriptionsCollection subs = new SubscriptionsCollection();
        for (String projectId : this.myVisibleProjectIds) {
            this.subscribeOnProjectEvents(subs, projectId);
        }
        subs.subscribeOnUserEvent(TrackerEventType.CHANGE_ADDED, user.getId());
        subs.subscribeOnUserEvent(TrackerEventType.PERSONAL_BUILD_CHANGED_STATUS, user.getId());
        subs.subscribeOnUserEvent(TrackerEventType.PERSONAL_BUILD_STARTED, user.getId());
        subs.subscribeOnUserEvent(TrackerEventType.PERSONAL_BUILD_FINISHED, user.getId());
        subs.subscribeOnUserEvent(TrackerEventType.PERSONAL_BUILD_INTERRUPTED, user.getId());
        subs.subscribeOnUserEvent(TrackerEventType.USER_ACCOUNT_CHANGED, user.getId());
        subs.subscribeOnUserEvent(TrackerEventType.USER_ACCOUNT_REMOVED, user.getId());
        subs.subscribeOnUserEvent(TrackerEventType.NOTIFICATION_RULES_CHANGED, user.getId());
        return subs;
    }

    private void subscribeOnProjectEvents(@NotNull SubscriptionsCollection subs, @NotNull String projectId) {
        if (subs == null) {
            TeamServerSummary.$$$reportNull$$$0(2);
        }
        if (projectId == null) {
            TeamServerSummary.$$$reportNull$$$0(3);
        }
        subs.subscribeOnProjectEvent(TrackerEventType.BUILD_TYPE_ACTIVE_STATUS_CHANGED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.BUILD_TYPE_RESPONSIBILITY_CHANGES, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.BUILD_TYPE_ADDED_TO_QUEUE, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.BUILD_TYPE_REMOVED_FROM_QUEUE, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.BUILD_TYPE_REGISTERED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.BUILD_TYPE_UNREGISTERED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.BUILD_STARTED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.BUILD_FINISHED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.BUILD_INTERRUPTED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.PROJECT_PERSISTED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.PROJECT_REMOVED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.PROJECT_RESTORED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.PROJECT_ARCHIVED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.PROJECT_DEARCHIVED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.TEST_RESPONSIBILITY_CHANGED, projectId);
        subs.subscribeOnProjectEvent(TrackerEventType.TEST_MUTE_UPDATED, projectId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/TeamServerSummary";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProject";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/TeamServerSummary";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createSubscription";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "subscribeOnProjectEvents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

