/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.Build;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.UserChangeStatus;
import jetbrains.buildServer.serverSide.userChanges.PersonalChangeDescriptor;
import jetbrains.buildServer.vcs.VcsModification;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserChangeInfo
implements Comparable<UserChangeInfo> {
    private final VcsModification myModification;
    private final List<Long> myUserIds;
    private final PersonalChangeDescriptor myPersonalChangeDescriptor;
    private final Map<BuildType, BuildTypeChangeStatus> myType2DetailsMap = new LinkedHashMap<BuildType, BuildTypeChangeStatus>();
    private UserChangeStatus myChangeStatus = UserChangeStatus.PENDING;

    public UserChangeInfo(VcsModification modification, List<Long> usersId, PersonalChangeDescriptor personalChangeDescriptor) {
        this.myModification = modification;
        this.myUserIds = usersId;
        this.myPersonalChangeDescriptor = personalChangeDescriptor != null ? new PersonalChangeDescriptor(personalChangeDescriptor) : null;
    }

    public void setChangeStatus(UserChangeStatus changeStatus) {
        this.myChangeStatus = changeStatus;
    }

    public UserChangeStatus getChangeStatus() {
        return this.myChangeStatus;
    }

    public VcsModification getModification() {
        return this.myModification;
    }

    public String toString() {
        return this.myUserIds.toString() + ' ' + this.myModification;
    }

    public boolean isBuildResultsAvailable() {
        return this.getFirstBuilds().size() > 0;
    }

    public Map<BuildType, BuildTypeChangeStatus> getDetailsMap() {
        return Collections.unmodifiableMap(this.myType2DetailsMap);
    }

    public BuildTypeChangeStatus getDetails(BuildType buildType) {
        return this.myType2DetailsMap.get(buildType);
    }

    public void setFirstRunIn(BuildType type, @Nullable Build instance) {
        if (type == null) {
            return;
        }
        this.getOrCreateBuildTypeStatus(type).setFirstBuildWithChange(instance);
    }

    public void setFixedIn(BuildType type, @Nullable Build instance) {
        if (type == null) {
            return;
        }
        this.getOrCreateBuildTypeStatus(type).setFixedInBuild(instance);
    }

    public void setCurrent(BuildType type, Build instance) {
        if (type == null) {
            return;
        }
        this.getOrCreateBuildTypeStatus(type).setCurrentBuild(instance);
    }

    @NotNull
    public List<BuildType> getBuildTypes() {
        ArrayList<BuildType> list = new ArrayList<BuildType>(this.myType2DetailsMap.keySet());
        Collections.sort(list);
        ArrayList<BuildType> arrayList = list;
        if (arrayList == null) {
            UserChangeInfo.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    public Build getFirstRunIn(BuildType type) {
        BuildTypeChangeStatus changeStatus = this.myType2DetailsMap.get(type);
        return changeStatus == null ? null : changeStatus.getFirstBuildWithChange();
    }

    @Nullable
    public Build getFixedIn(BuildType type) {
        if (type == null) {
            return null;
        }
        return this.getOrCreateBuildTypeStatus(type).getFixedInBuild();
    }

    @Nullable
    public Build getCurrentBuild(BuildType type) {
        if (type == null) {
            return null;
        }
        return this.getOrCreateBuildTypeStatus(type).getCurrentBuild();
    }

    public List<Build> getAllInstances() {
        List<Build> result = this.getFirstBuilds();
        Collections.sort(result, new Comparator<Build>(){

            @Override
            public int compare(Build o1, Build o2) {
                return (int)(o1.getBuildId() - o2.getBuildId());
            }
        });
        return result;
    }

    private List<Build> getFirstBuilds() {
        ArrayList<Build> result = new ArrayList<Build>();
        for (BuildTypeChangeStatus status : this.myType2DetailsMap.values()) {
            if (status == null || status.getFirstBuildWithChange() == null) continue;
            result.add(status.getFirstBuildWithChange());
        }
        return result;
    }

    @Override
    public int compareTo(UserChangeInfo o) {
        return (int)(this.getModification().getId() - o.getModification().getId());
    }

    public void removeType(BuildType type) {
        this.myType2DetailsMap.remove(type);
    }

    public void addBuildType(@NotNull BuildType type) {
        if (type == null) {
            UserChangeInfo.$$$reportNull$$$0(1);
        }
        this.getOrCreateBuildTypeStatus(type);
    }

    public void sortBuildTypes() {
        ArrayList<BuildType> types = new ArrayList<BuildType>(this.myType2DetailsMap.keySet());
        Collections.sort(types, this.createBuildConfigurationsComparator());
        HashMap<BuildType, BuildTypeChangeStatus> copy = new HashMap<BuildType, BuildTypeChangeStatus>(this.myType2DetailsMap);
        this.myType2DetailsMap.clear();
        for (BuildType type : types) {
            this.myType2DetailsMap.put(type, (BuildTypeChangeStatus)copy.get(type));
        }
    }

    private Comparator<BuildType> createBuildConfigurationsComparator() {
        return new Comparator<BuildType>(){

            @Override
            public int compare(BuildType o1, BuildType o2) {
                Build instance1 = this.getFirstInstance(o1);
                Build instance2 = this.getFirstInstance(o2);
                if (instance2 == null && instance1 == null) {
                    return 0;
                }
                if (instance1 == null) {
                    return 1;
                }
                if (instance2 == null) {
                    return -1;
                }
                if (instance1.isFinished() == instance2.isFinished()) {
                    return (int)(instance1.getBuildId() - instance2.getBuildId());
                }
                return instance1.isFinished() ? -1 : 1;
            }

            @Nullable
            private Build getFirstInstance(BuildType type) {
                if (type == null) {
                    return null;
                }
                return UserChangeInfo.this.getOrCreateBuildTypeStatus(type).getFirstBuildWithChange();
            }
        };
    }

    public boolean isSuspicious() {
        for (BuildType type : this.getBuildTypes()) {
            if (!this.isSuspicious(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isSuspicious(BuildType type) {
        if (type == null) {
            return false;
        }
        return !this.getOrCreateBuildTypeStatus(type).isSuccessful();
    }

    public List<Long> getUserIds() {
        return this.myUserIds;
    }

    public PersonalChangeDescriptor getPersonalChangeDescriptor() {
        return this.myPersonalChangeDescriptor;
    }

    @NotNull
    private BuildTypeChangeStatus getOrCreateBuildTypeStatus(@NotNull BuildType type) {
        BuildTypeChangeStatus changeStatus;
        if (type == null) {
            UserChangeInfo.$$$reportNull$$$0(2);
        }
        if ((changeStatus = this.myType2DetailsMap.get(type)) == null) {
            changeStatus = new BuildTypeChangeStatus();
            this.myType2DetailsMap.put(type, changeStatus);
        }
        BuildTypeChangeStatus buildTypeChangeStatus = changeStatus;
        if (buildTypeChangeStatus == null) {
            UserChangeInfo.$$$reportNull$$$0(3);
        }
        return buildTypeChangeStatus;
    }

    public boolean isChangeFinished() {
        return this.findBuilds(SearchMethod.ALL, new BuildFilter(){

            @Override
            public boolean acceptBuild(Build firstBuild) {
                return firstBuild != null && firstBuild.isFinished();
            }
        });
    }

    public boolean isChangeCanceled() {
        return this.findBuilds(SearchMethod.AT_LEAST_ONE, new BuildFilter(){

            @Override
            public boolean acceptBuild(Build firstBuild) {
                return firstBuild != null && firstBuild.getCanceledInfo() != null;
            }
        });
    }

    public boolean isChangeSuccessful() {
        for (BuildTypeChangeStatus status : this.myType2DetailsMap.values()) {
            if (status.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    private boolean findBuilds(SearchMethod searchMethod, BuildFilter filter) {
        for (Map.Entry<BuildType, BuildTypeChangeStatus> entry : this.myType2DetailsMap.entrySet()) {
            Build firstBuildWithChange = entry.getValue().getFirstBuildWithChange();
            switch (searchMethod) {
                case AT_LEAST_ONE: {
                    if (!filter.acceptBuild(firstBuildWithChange)) break;
                    return true;
                }
                case ALL: {
                    if (filter.acceptBuild(firstBuildWithChange)) break;
                    return false;
                }
            }
        }
        return searchMethod == SearchMethod.ALL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/UserChangeInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/UserChangeInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBuildTypeStatus";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addBuildType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBuildTypeStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum SearchMethod {
        AT_LEAST_ONE,
        ALL;

    }

    private static interface BuildFilter {
        public boolean acceptBuild(Build var1);
    }

    public static class BuildTypeChangeStatus {
        private Build myFirstBuildWithChange;
        private Build myCurrentBuild;
        private Build myFixedInBuild;

        @Nullable
        public Build getFirstBuildWithChange() {
            return this.myFirstBuildWithChange;
        }

        public void setFirstBuildWithChange(Build firstBuildWithChange) {
            this.myFirstBuildWithChange = firstBuildWithChange;
        }

        public Build getFixedInBuild() {
            return this.myFixedInBuild;
        }

        public void setFixedInBuild(Build fixedInBuild) {
            this.myFixedInBuild = fixedInBuild;
        }

        @Nullable
        public Build getCurrentBuild() {
            return this.myCurrentBuild;
        }

        public void setCurrentBuild(Build currentBuild) {
            this.myCurrentBuild = currentBuild;
        }

        public boolean isSuccessful() {
            return this.myFixedInBuild != null;
        }

        @Deprecated
        public boolean isSuspicious() {
            return !this.isSuccessful();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("BuildTypeChangeStatus {");
            sb.append("\nmyFirstBuildWithChange=").append(this.myFirstBuildWithChange);
            sb.append("\nmyCurrentBuild        =").append(this.myCurrentBuild);
            sb.append("\nmyFixedInBuild        =").append(this.myFixedInBuild);
            sb.append('}');
            return sb.toString();
        }
    }
}

