/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.activation;

import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import jetbrains.buildServer.Used;
import jetbrains.buildServer.activation.ActivatorBase;
import jetbrains.buildServer.activation.LogUtil;
import jetbrains.buildServer.version.ServerVersionHolder;
import org.jetbrains.annotations.NotNull;

public class HttpActivationServer
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)HttpActivationServer.class.getName());
    private static final int SOCKET_NUMBER_START = 63330;
    private static final int SOCKET_NUMBER_END = 63339;
    private ServerSocket myServerSocket;
    private Thread myListener;
    private Stack<Runner> myThreadpool;
    private ThreadGroup myRunners;
    public static final boolean myDebug = Boolean.getBoolean("teamcity.activation.debug");
    private static final byte[] ctype = HttpActivationServer.toHTTPBytes("Content-Type: image/gif\r\n");
    private static final byte[] clength = HttpActivationServer.toHTTPBytes("Content-Length: ");
    private static final byte[] newline = HttpActivationServer.toHTTPBytes("\r\n");
    private static final byte[] doubleNewline = HttpActivationServer.toHTTPBytes("\r\n\r\n");
    private static final byte[] conclose = HttpActivationServer.toHTTPBytes("Connection: close\r\n");
    private static final byte[] ok = HttpActivationServer.toHTTPBytes(" 200 OK\r\n");
    private static final byte[] server = HttpActivationServer.toHTTPBytes("Server: ");
    private final byte[] successStream = new byte[]{71, 73, 70, 56, 57, 97, 2, 0, 2, 0, -128, -1, 0, -1, -1, -1, 0, 0, 0, 44, 0, 0, 0, 0, 1, 0, 1, 0, 0, 2, 2, 68, 1, 0, 59};
    private final byte[] failureStream = new byte[]{71, 73, 70, 56, 57, 97, 1, 0, 1, 0, -128, -1, 0, -1, -1, -1, 0, 0, 0, 44, 0, 0, 0, 0, 1, 0, 1, 0, 0, 2, 2, 68, 1, 0, 59};
    private static final String HTTP_ENCODING = "US-ASCII";
    private static final int MAX_REQUESTS = 10;
    private ActivatorBase myHandler;
    private static HttpActivationServer ourInstance;
    private static final byte[] LOOPBACK_IP;
    private byte[] myServerName;

    private static byte[] toHTTPBytes(String text) {
        try {
            return text.getBytes(HTTP_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage() + ": HTTP requires US-ASCII encoding");
        }
    }

    private synchronized void setupServerSocket() throws IOException {
        for (int port = 63330; port < 63339 && this.myServerSocket == null; ++port) {
            try {
                this.myServerSocket = new ServerSocket(port, 50, InetAddress.getByAddress(LOOPBACK_IP));
                continue;
            }
            catch (BindException bindException) {
                // empty catch block
            }
        }
        if (this.myServerSocket == null) {
            throw new IOException("Unable to bind to any port in range: 63330 - 63339, do you have antivirus software installed?");
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Opened Open-In-IDE server socket for ");
        msg.append(this.myServerSocket.getInetAddress());
        msg.append(':').append(this.myServerSocket.getLocalPort());
        LogUtil.log(LOG, msg.toString());
        if (this.myServerSocket.getSoTimeout() <= 0) {
            this.myServerSocket.setSoTimeout(4096);
        }
    }

    @Used(value="IDE-plugins")
    public void start(ActivatorBase activator) {
        this.myHandler = activator;
        try {
            this.myServerName = HttpActivationServer.toHTTPBytes("TeamCity Open-In-IDE Handler " + ServerVersionHolder.getVersion().getDisplayVersion());
        }
        catch (Exception e) {
            this.myServerName = HttpActivationServer.toHTTPBytes("TeamCity Open-In-IDE Handler");
        }
        this.myThreadpool = new Stack();
        this.myRunners = new ThreadGroup("TeamCity Open-In-IDE Runner");
        try {
            this.setupServerSocket();
        }
        catch (Exception e) {
            this.myListener = null;
            throw new RuntimeException(e);
        }
        if (this.myListener == null) {
            this.myListener = new Thread((Runnable)this, "TeamCity Open-In-IDE Listener");
            this.myListener.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block41: {
            block37: while (true) {
                try {
                    while (this.myListener != null) {
                        Socket socket = null;
                        Runner runner = null;
                        socket = this.myServerSocket.accept();
                        try {
                            socket.setTcpNoDelay(true);
                        }
                        catch (SocketException socketOptEx2222) {
                            LogUtil.log(LOG, socketOptEx2222.getMessage(), socketOptEx2222);
                        }
                        runner = this.getRunner();
                        runner.handle(socket);
                        if (runner != null || socket == null) continue;
                        try {
                            socket.close();
                            continue block37;
                        }
                        catch (Throwable socketOptEx2222) {
                            continue;
                        }
                        catch (InterruptedIOException socketOptEx2222) {
                            if (runner != null || socket == null) continue;
                            try {
                                socket.close();
                                continue block37;
                            }
                            catch (Throwable socketOptEx2222) {
                                continue;
                            }
                        }
                        catch (Exception ex) {
                            LogUtil.log(LOG, "Exception in Open-In-IDE listener loop", ex);
                            continue block37;
                        }
                        catch (Error err) {
                            LogUtil.log(LOG, "Error in Open-In-IDE listener loop", err);
                            continue block37;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            if (runner != null || socket == null) continue;
                            try {
                                socket.close();
                                continue block37;
                            }
                            catch (Throwable ex) {}
                        }
                    }
                    break block41;
                }
                catch (Exception exception) {
                    LogUtil.log(LOG, "Error accepting Open-In-IDE connections", exception);
                    break block41;
                }
            }
            finally {
                if (this.myServerSocket != null) {
                    try {
                        this.myServerSocket.close();
                        LogUtil.log(LOG, "Closed Open-In-IDE server socket");
                        this.myServerSocket = null;
                    }
                    catch (IOException e) {
                        LogUtil.log(LOG, e.getMessage(), e);
                    }
                }
                if (this.myRunners != null) {
                    ThreadGroup g = this.myRunners;
                    this.myRunners = null;
                    try {
                        g.interrupt();
                    }
                    catch (Exception e) {
                        LogUtil.log(LOG, e.getMessage(), e);
                    }
                }
            }
        }
    }

    @Used(value="IDE-plugins")
    public synchronized void shutdown() {
        if (this.myListener != null) {
            Thread l = this.myListener;
            this.myListener = null;
            l.interrupt();
        }
    }

    private Runner getRunner() {
        try {
            return this.myThreadpool.pop();
        }
        catch (EmptyStackException empty) {
            if (this.myRunners.activeCount() > 10) {
                throw new RuntimeException("System overload: Maximum number of concurrent requests (10) exceeded");
            }
            return new Runner();
        }
    }

    private void repoolRunner(Runner runner) {
        this.myThreadpool.push(runner);
    }

    @Used(value="IDE-plugins")
    public static HttpActivationServer getInstance() {
        if (ourInstance == null) {
            ourInstance = new HttpActivationServer();
        }
        return ourInstance;
    }

    static {
        LOOPBACK_IP = new byte[]{127, 0, 0, 1};
    }

    public class Connection
    implements Runnable {
        private final Socket socket;
        private final BufferedInputStream input;
        private final BufferedOutputStream output;
        private byte[] buffer;
        private static final int READ_TIMEOUT = 1000;
        private String httpVersion;

        Connection(Socket socket) throws IOException {
            if (socket == null) {
                Connection.$$$reportNull$$$0(0);
            }
            socket.setSoTimeout(1000);
            this.socket = socket;
            this.input = new BufferedInputStream(socket.getInputStream());
            this.output = new BufferedOutputStream(socket.getOutputStream());
        }

        @Override
        public void run() {
            try {
                this.doHandle();
            }
            catch (Exception exception) {
                LogUtil.log(LOG, exception.getMessage(), exception);
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void doHandle() throws IOException {
            String line = this.readLine();
            if (line.length() == 0) {
                LogUtil.log(LOG, "skip");
                line = this.readLine();
            }
            LogUtil.log(LOG, String.valueOf(line));
            StringTokenizer tokens = new StringTokenizer(line);
            tokens.nextToken();
            String uri = tokens.nextToken();
            LogUtil.log(LOG, "uri=" + uri);
            this.httpVersion = tokens.nextToken();
            int i = uri.indexOf("?");
            String res = i < 0 ? uri : uri.substring(0, i);
            HashMap<String, String> params = new HashMap<String, String>();
            if (i >= 0) {
                String[] pairs;
                String req = uri.substring(i + 1);
                for (String pair : pairs = req.split("&")) {
                    int s = pair.indexOf("=");
                    if (s <= 0) continue;
                    params.put(pair.substring(0, s), pair.substring(s + 1));
                }
            }
            HttpActivationServer.this.myHandler.handle(res, params, new ActivatorBase.ResultHandler(){

                @Override
                public void done(@NotNull ActivatorBase.ActivationResult result) {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    switch (result) {
                        case SUCCEED: {
                            Connection.this.writeResponse(true);
                            break;
                        }
                        default: {
                            Connection.this.writeResponse(false);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "jetbrains/buildServer/activation/HttpActivationServer$Connection$1", "done"));
                }
            });
        }

        public void writeResponse(boolean succeed) {
            try {
                byte[] data = succeed ? HttpActivationServer.this.successStream : HttpActivationServer.this.failureStream;
                this.output.write(HttpActivationServer.toHTTPBytes(this.httpVersion));
                this.output.write(ok);
                this.output.write(server);
                this.output.write(HttpActivationServer.this.myServerName);
                this.output.write(newline);
                this.output.write(conclose);
                this.output.write(ctype);
                this.output.write(clength);
                this.output.write(HttpActivationServer.toHTTPBytes(Integer.toString(data.length)));
                this.output.write(newline);
                this.output.write(newline);
                this.output.write(data);
                this.output.flush();
            }
            catch (IOException e) {
                LogUtil.log(LOG, e.getMessage(), e);
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (Throwable throwable) {}
            }
        }

        @NotNull
        private String readLine() throws IOException {
            int next;
            if (this.buffer == null) {
                this.buffer = new byte[2048];
            }
            int count = 0;
            while ((next = this.input.read()) >= 0 && next != 10) {
                if (next != 13) {
                    this.buffer[count++] = (byte)next;
                }
                if (count < this.buffer.length) continue;
                throw new IOException("HTTP Header too long");
            }
            String result = new String(this.buffer, 0, count);
            LogUtil.log(LOG, result);
            String string = result;
            if (string == null) {
                Connection.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "socket";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/activation/HttpActivationServer$Connection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/activation/HttpActivationServer$Connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class Runner
    implements Runnable {
        private Thread thread;
        private Connection con;
        private int count;

        private Runner() {
        }

        public synchronized void handle(Socket socket) throws IOException {
            this.con = new Connection(socket);
            this.count = 0;
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread(HttpActivationServer.this.myRunners, this);
                this.thread.start();
            } else {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.con != null && Thread.currentThread() == this.thread) {
                this.con.run();
                ++this.count;
                this.con = null;
                if (this.count > 200 || HttpActivationServer.this.myThreadpool.size() > 20) {
                    return;
                }
                Runner runner = this;
                synchronized (runner) {
                    HttpActivationServer.this.repoolRunner(this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ir) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

