/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.delayedCommit;

import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.UserChangeInfo;
import jetbrains.buildServer.delayedCommit.PersonalBuildsSnapshot;
import jetbrains.buildServer.delayedCommit.RemoteRunSessionData;
import org.apache.log4j.Logger;

class PersonalBuildEventsGenerator {
    private static final Logger LOG = Logger.getLogger((String)PersonalBuildEventsGenerator.class.getName());
    private final List<RemoteRunSessionData> myPreviousState;
    private final List<RemoteRunSessionData> myExistingSessions = new ArrayList<RemoteRunSessionData>();
    private final List<UserChangeInfo> myCurrentState;
    private final PersonalBuildsSnapshot mySnapshot;

    public PersonalBuildEventsGenerator(List<RemoteRunSessionData> previousState, List<UserChangeInfo> currentState, PersonalBuildsSnapshot snapshot, String url, long userId) {
        this.myPreviousState = PersonalBuildEventsGenerator.filterSuitableSessions(previousState, url, userId);
        this.myCurrentState = currentState;
        this.mySnapshot = snapshot;
    }

    private static List<RemoteRunSessionData> filterSuitableSessions(List<RemoteRunSessionData> previousState, String url, long userId) {
        ArrayList<RemoteRunSessionData> result = new ArrayList<RemoteRunSessionData>();
        for (RemoteRunSessionData session : previousState) {
            if (!session.isUrlSuitable(url) || !session.isUserSuitable(userId)) continue;
            result.add(session);
        }
        return result;
    }

    public void generate() {
        for (UserChangeInfo info : this.myCurrentState) {
            RemoteRunSessionData session = this.findSession(info.getModification().getId());
            if (session == null) continue;
            this.myExistingSessions.add(session);
            this.mySnapshot.processPersonalChange(session, info);
        }
        this.processOldSessions();
    }

    private void processOldSessions() {
        ArrayList<RemoteRunSessionData> prevState = new ArrayList<RemoteRunSessionData>(this.myPreviousState);
        ArrayList<RemoteRunSessionData> existingSessions = new ArrayList<RemoteRunSessionData>(this.myExistingSessions);
        for (RemoteRunSessionData session : prevState) {
            if (existingSessions.contains(session)) continue;
            this.processOldSession(session);
        }
    }

    private void processOldSession(RemoteRunSessionData session) {
        long changeId = session.getChangeId();
        LOG.info((Object)("Missed event generated:  sessionDeleted:" + changeId));
        this.mySnapshot.processPersonalChangeDeleted(changeId);
    }

    private RemoteRunSessionData findSession(long changeId) {
        for (RemoteRunSessionData session : this.myPreviousState) {
            if (session.getChangeId() != changeId) continue;
            return session;
        }
        return null;
    }
}

