/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.delayedCommit;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jetbrains.buildServer.TeamCitySnapshot;
import jetbrains.buildServer.UserChangeInfo;
import jetbrains.buildServer.delayedCommit.PersonalBuildEventsGenerator;
import jetbrains.buildServer.delayedCommit.RemoteRunSessionData;
import jetbrains.buildServer.serverMessages.PersonalChangeProcessor;
import jetbrains.buildServer.serverProxy.RemoteBuildServerFacade;
import jetbrains.buildServer.serverSide.userChanges.PersonalChangeCommitDecision;
import jetbrains.buildServer.serverSide.userChanges.PreTestedCommitType;
import jetbrains.buildServer.users.UserData;
import jetbrains.buildServer.util.EventDispatcher;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PersonalBuildsSnapshot {
    private static final Logger LOG = Logger.getLogger(PersonalBuildsSnapshot.class);
    @NotNull
    private final TeamCitySnapshot myParentSnapshot;
    @NotNull
    private final List<RemoteRunSessionData> myRemoteSessions = new ArrayList<RemoteRunSessionData>();
    @NotNull
    private final EventDispatcher<PersonalChangeProcessor> myPersonalChangeDispatcher;
    private boolean myIsUnsaved = false;

    public PersonalBuildsSnapshot(TeamCitySnapshot parentSnapshot) {
        this.myParentSnapshot = parentSnapshot;
        this.myPersonalChangeDispatcher = EventDispatcher.create(PersonalChangeProcessor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processPersonalChangeDeleted(long changeId) {
        try {
            RemoteRunSessionData session = this.findSessionByChangeId(changeId);
            if (session != null) {
                session.delete();
                if (session.isDeleted()) {
                    LOG.info((Object)("Session deleted actually for change " + changeId));
                    this.myRemoteSessions.remove(session);
                }
            }
        }
        finally {
            this.myIsUnsaved = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteRunSessionData startRemoteSession(long changeId, String comment, File file, PreTestedCommitType preTestedCommitType, boolean requestConfirmation, String serverUrl, long userId) {
        try {
            RemoteRunSessionData session = new RemoteRunSessionData(changeId, file, comment, preTestedCommitType, requestConfirmation, serverUrl, userId);
            this.myRemoteSessions.add(session);
            RemoteRunSessionData remoteRunSessionData = session;
            return remoteRunSessionData;
        }
        finally {
            this.myIsUnsaved = true;
        }
    }

    public synchronized List<RemoteRunSessionData> getSessions() {
        return Collections.unmodifiableList(new ArrayList<RemoteRunSessionData>(this.myRemoteSessions));
    }

    public synchronized void setSessions(List<RemoteRunSessionData> newSessions) {
        this.myRemoteSessions.clear();
        this.myRemoteSessions.addAll(newSessions);
    }

    public UserChangeInfo findUserChangeInfo(long changeId) {
        for (UserChangeInfo changeInfo : this.myParentSnapshot.getSummaryProvider().getSummary().getPersonalChanges()) {
            if (changeInfo.getModification().getId() != changeId) continue;
            return changeInfo;
        }
        return null;
    }

    public RemoteRunSessionData findSessionByChangeId(long changeId) {
        for (RemoteRunSessionData remoteSession : this.getSessions()) {
            if (remoteSession.getChangeId() != changeId) continue;
            return remoteSession;
        }
        return null;
    }

    public EventDispatcher<PersonalChangeProcessor> getDispatcher() {
        return this.myPersonalChangeDispatcher;
    }

    @NotNull
    public List<String> getActiveSessionChangeIds() {
        ArrayList<String> changeIds = new ArrayList<String>();
        for (RemoteRunSessionData session : this.getSessions()) {
            if (!session.getPreTestedCommitType().isCommit() || session.isChangeProcessed()) continue;
            changeIds.add(String.valueOf(session.getChangeId()));
        }
        ArrayList<String> arrayList = changeIds;
        if (arrayList == null) {
            PersonalBuildsSnapshot.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSnapshotAvailable(List<UserChangeInfo> personalChanges, String url, long userId) {
        LOG.debug((Object)"Processing new snapshot...");
        ArrayList<RemoteRunSessionData> currentSessions = new ArrayList<RemoteRunSessionData>();
        PersonalBuildsSnapshot personalBuildsSnapshot = this;
        synchronized (personalBuildsSnapshot) {
            currentSessions.addAll(this.myRemoteSessions);
        }
        new PersonalBuildEventsGenerator(currentSessions, personalChanges, this, url, userId).generate();
    }

    public synchronized void addSession(RemoteRunSessionData data) {
        this.myRemoteSessions.add(data);
    }

    public boolean shouldBeSaved() {
        return this.myIsUnsaved;
    }

    public void markAsSaved() {
        this.myIsUnsaved = false;
    }

    long getUserId() {
        UserData user = this.myParentSnapshot.getUser();
        if (user == null) {
            throw new RuntimeException("Session is expired or you're logged out. Please relogin");
        }
        return user.getId();
    }

    String getServerUrl() {
        RemoteBuildServerFacade facade = this.myParentSnapshot.getServerFacade();
        if (facade == null) {
            throw new RuntimeException("Cannot start session: facade is null");
        }
        return facade.getServerUrl();
    }

    public void processPersonalChange(@NotNull RemoteRunSessionData session, @NotNull UserChangeInfo changeInfo) {
        if (session == null) {
            PersonalBuildsSnapshot.$$$reportNull$$$0(1);
        }
        if (changeInfo == null) {
            PersonalBuildsSnapshot.$$$reportNull$$$0(2);
        }
        try {
            this.doProcessPersonalChange(session, changeInfo);
        }
        finally {
            this.myIsUnsaved = true;
        }
    }

    private void doProcessPersonalChange(@NotNull RemoteRunSessionData session, @NotNull UserChangeInfo changeInfo) {
        if (session == null) {
            PersonalBuildsSnapshot.$$$reportNull$$$0(3);
        }
        if (changeInfo == null) {
            PersonalBuildsSnapshot.$$$reportNull$$$0(4);
        }
        if (!session.isPerformPreTestedCommit() || session.isChangeProcessed()) {
            return;
        }
        PersonalChangeCommitDecision commitDecision = changeInfo.getPersonalChangeDescriptor().getPersonalChangeStatus();
        if (commitDecision == PersonalChangeCommitDecision.UNKNOWN) {
            return;
        }
        session.markChangeProcessed();
        if (commitDecision == PersonalChangeCommitDecision.COMMIT) {
            ((PersonalChangeProcessor)this.myPersonalChangeDispatcher.getMulticaster()).processChangeSucceeded(session, changeInfo);
        } else if (commitDecision == PersonalChangeCommitDecision.DO_NOT_COMMIT) {
            ((PersonalChangeProcessor)this.myPersonalChangeDispatcher.getMulticaster()).processChangeFailed(session, changeInfo);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/delayedCommit/PersonalBuildsSnapshot";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveSessionChangeIds";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/delayedCommit/PersonalBuildsSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processPersonalChange";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doProcessPersonalChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

