/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.delayedCommit;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.delayedCommit.EventsProcessingHelper;
import jetbrains.buildServer.delayedCommit.RevisionUpdateListener;
import jetbrains.buildServer.serverSide.userChanges.PreTestedCommitType;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;

public class RemoteRunSessionData {
    private final Map<String, String> myPathToNumber = new HashMap<String, String>();
    private final Map<String, String> myPathToCheckSum = new HashMap<String, String>();
    private Collection<String> myUpdatedPaths;
    private final long myChangeId;
    private final File myFile;
    private String myComment;
    private final PreTestedCommitType myPreTestedCommitType;
    private final boolean myRequestConfirmation;
    private final String myUrl;
    private final long myUserId;
    private transient int myDeleted = 0;
    @Deprecated
    private final EventsProcessingHelper myEventsProcessingHelper = new EventsProcessingHelper();
    private boolean myChangeProcessed = false;

    public boolean isPerformPreTestedCommit() {
        return this.myPreTestedCommitType.isCommit();
    }

    public PreTestedCommitType getPreTestedCommitType() {
        return this.myPreTestedCommitType;
    }

    public RemoteRunSessionData(long changeId, File file, String comment, PreTestedCommitType preTestedCommitType, boolean requestConfirmation, String serverUrl, long userId) {
        this.myChangeId = changeId;
        this.myFile = file;
        this.myComment = comment;
        this.myPreTestedCommitType = preTestedCommitType;
        this.myRequestConfirmation = requestConfirmation;
        this.myUrl = serverUrl;
        this.myUserId = userId;
    }

    void setFileRevision(String filePath, String beforeRevNumber) {
        this.myPathToNumber.put(filePath, beforeRevNumber);
    }

    public boolean isRequestConfirmation() {
        return this.myRequestConfirmation;
    }

    public boolean containsChange(String filePath) {
        return this.myPathToNumber.containsKey(filePath);
    }

    public String getComment() {
        return this.myComment;
    }

    public void setComment(String comment) {
        if (comment == null) {
            throw new IllegalArgumentException("comment must not be null");
        }
        this.myComment = comment;
    }

    public File getFile() {
        return this.myFile;
    }

    public Collection<String> getPaths() {
        return this.myPathToNumber.keySet();
    }

    public void rememberCurrentFilesState() {
        this.myUpdatedPaths = this.computeUpdatedPaths();
    }

    public Collection<String> getUpdatedPaths() {
        if (this.myUpdatedPaths == null) {
            return this.getPaths();
        }
        return this.myUpdatedPaths;
    }

    private Collection<String> computeUpdatedPaths() {
        ArrayList<String> files = new ArrayList<String>();
        for (String path : this.getPaths()) {
            if (new File(path).isDirectory()) {
                files.add(path);
                continue;
            }
            String oldSum = this.getFileCheckSum(path);
            if (oldSum == null) {
                files.add(path);
                continue;
            }
            if (oldSum.equals(RemoteRunSessionData.computeChecksum(new File(path)))) continue;
            files.add(path);
        }
        return files;
    }

    public Map<String, String> getPathsAndVersions() {
        return Collections.unmodifiableMap(this.myPathToNumber);
    }

    public String getVersion(String filePath) {
        return RemoteRunSessionData.convertFromOldFormatIfNeeded(this.myPathToNumber.get(filePath));
    }

    private static String convertFromOldFormatIfNeeded(String version) {
        if (version == null) {
            return null;
        }
        return version.indexOf(91) == -1 ? version : version.replaceFirst("\\[[^\\[\\]]*\\]_", "_");
    }

    public long getChangeId() {
        return this.myChangeId;
    }

    void setFileCheckSum(String path, String checkSum) {
        if (checkSum != null) {
            this.myPathToCheckSum.put(path, checkSum);
        }
    }

    String getFileCheckSum(String filePath) {
        return this.myPathToCheckSum.get(filePath);
    }

    public void addChange(File ioFile, String revisionBefore) {
        this.setFileRevision(ioFile.getAbsolutePath(), revisionBefore);
        if (ioFile.isFile()) {
            this.setFileCheckSum(ioFile.getAbsolutePath(), RemoteRunSessionData.computeChecksum(ioFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String computeChecksum(File file) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[16384];
            try {
                while (true) {
                    int l22;
                    if ((l22 = ((InputStream)is).read(buffer)) <= 0) {
                        return RemoteRunSessionData.toString(digest);
                    }
                    digest.update(buffer, 0, l22);
                }
            }
            catch (IOException e) {
                String string = null;
                return string;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e2) {
            return null;
        }
    }

    private static String toString(MessageDigest digest) {
        byte[] result = digest.digest();
        StringBuffer buff = new StringBuffer();
        for (byte b : result) {
            int lo = b & 0xF;
            int hi = b >> 4 & 0xF;
            buff.append(String.valueOf(Integer.toHexString(hi))).append(String.valueOf(Integer.toHexString(lo)));
        }
        return buff.toString();
    }

    public boolean isUrlSuitable(String url) {
        if (url == null) {
            return false;
        }
        if (this.myUrl == null) {
            return true;
        }
        return this.myUrl.equals(url);
    }

    public boolean isUserSuitable(long userId) {
        if (userId == -1L) {
            return false;
        }
        if (this.myUserId == -1L) {
            return true;
        }
        return userId == this.myUserId;
    }

    public void delete() {
        ++this.myDeleted;
    }

    public boolean isDeleted() {
        return this.myDeleted >= 3;
    }

    public boolean markedForDeletion() {
        return this.myDeleted > 0;
    }

    public void prepare() {
        if (this.myEventsProcessingHelper != null && this.myEventsProcessingHelper.isChangeProcessed()) {
            this.myChangeProcessed = true;
        }
    }

    public boolean isChangeProcessed() {
        this.prepare();
        return this.myChangeProcessed;
    }

    public void markChangeProcessed() {
        this.myChangeProcessed = true;
    }

    public Collection<RevisionUpdateListener> filterToUpdateRevisions(Collection<RemoteRunSessionData> datas) {
        return CollectionsUtil.filterAndConvertCollection(datas, (Converter)new Converter<RevisionUpdateListener, RemoteRunSessionData>(){

            public RevisionUpdateListener createFrom(final @NotNull RemoteRunSessionData source) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new RevisionUpdateListener(){

                    @Override
                    public void updateFileRevisions(String fileAbsolutePath, String oldVersion, String newRevision) {
                        source.updateFileRevisions(fileAbsolutePath, oldVersion, newRevision);
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/delayedCommit/RemoteRunSessionData$1", "createFrom"));
            }
        }, (Filter)new Filter<RemoteRunSessionData>(){

            public boolean accept(@NotNull RemoteRunSessionData data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                return data.getChangeId() <= RemoteRunSessionData.this.getChangeId();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/delayedCommit/RemoteRunSessionData$2", "accept"));
            }
        });
    }

    private void updateFileRevisions(String fileAbsolutePath, String oldVersion, String newRevision) {
        if (oldVersion == null) {
            return;
        }
        if (newRevision == null) {
            return;
        }
        if (!oldVersion.equals(this.getVersion(fileAbsolutePath))) {
            return;
        }
        this.setFileRevision(fileAbsolutePath, newRevision);
    }
}

