/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.issueTracker;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueData
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String SUMMARY_FIELD = "Summary";
    public static final String STATE_FIELD = "State";
    public static final String TYPE_FIELD = "Type";
    public static final String PRIORITY_FIELD = "Priority";
    public static final String SEVERITY_FIELD = "Severity";
    private final String myId;
    private final Map<String, String> myAllFields;
    private final boolean myResolved;
    private final boolean myFeatureRequest;
    private final String myUrl;

    public IssueData(@NotNull String id, @NotNull String summary, @NotNull String state, @NotNull String url, boolean resolved) {
        if (id == null) {
            IssueData.$$$reportNull$$$0(0);
        }
        if (summary == null) {
            IssueData.$$$reportNull$$$0(1);
        }
        if (state == null) {
            IssueData.$$$reportNull$$$0(2);
        }
        if (url == null) {
            IssueData.$$$reportNull$$$0(3);
        }
        this.myId = id;
        this.myResolved = resolved;
        this.myUrl = url;
        this.myAllFields = new HashMap<String, String>();
        this.myAllFields.put(SUMMARY_FIELD, summary);
        this.myAllFields.put(STATE_FIELD, state);
        this.myFeatureRequest = false;
    }

    public IssueData(@NotNull String id, @Nullable Map<String, String> data, boolean resolved, boolean featureRequest, @NotNull String url) {
        if (id == null) {
            IssueData.$$$reportNull$$$0(4);
        }
        if (url == null) {
            IssueData.$$$reportNull$$$0(5);
        }
        this.myId = id;
        this.myAllFields = new HashMap<String, String>(data);
        this.myResolved = resolved;
        this.myFeatureRequest = featureRequest;
        this.myUrl = url;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            IssueData.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getType() {
        String string = StringUtil.notNullize((String)this.myAllFields.get(TYPE_FIELD));
        if (string == null) {
            IssueData.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = StringUtil.notNullize((String)this.myAllFields.get(SUMMARY_FIELD));
        if (string == null) {
            IssueData.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getState() {
        String string = StringUtil.notNullize((String)this.myAllFields.get(STATE_FIELD));
        if (string == null) {
            IssueData.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getPriority() {
        String string = StringUtil.notNullize((String)this.myAllFields.get(PRIORITY_FIELD));
        if (string == null) {
            IssueData.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getSeverity() {
        String string = StringUtil.notNullize((String)this.myAllFields.get(SEVERITY_FIELD));
        if (string == null) {
            IssueData.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public boolean isFeatureRequest() {
        return this.myFeatureRequest;
    }

    @NotNull
    public Map<String, String> getAllFields() {
        Map<String, String> map = Collections.unmodifiableMap(this.myAllFields);
        if (map == null) {
            IssueData.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            IssueData.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean equals(Object o) {
        return o instanceof IssueData && this.myId.equals(((IssueData)o).getId());
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    public String toString() {
        return "[issue " + this.getId() + ", summary: " + this.getSummary() + ", resolved: " + this.isResolved() + ", state: " + this.getState() + ", url: " + this.getUrl() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/issueTracker/IssueData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/issueTracker/IssueData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

