/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverProxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jetbrains.buildServer.BuildProject;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.BuildTypeData;
import jetbrains.buildServer.ProjectData;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.serverProxy.AbstractProxy;
import jetbrains.buildServer.serverProxy.ProjectsProvider;
import jetbrains.buildServer.serverProxy.ProxyFactory;
import jetbrains.buildServer.serverProxy.RemoteBuildServerFacade;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.filters.FilterUtil;
import jetbrains.buildServer.vcs.VcsRoot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildProjectProxy
extends AbstractProxy<ProjectData>
implements BuildProject {
    private final ProjectsProvider myProjectsProvider;
    private final List<BuildType> myBuildTypes = new ArrayList<BuildType>();

    public BuildProjectProxy(RemoteBuildServerFacade remoteServer, ProjectData data, ProxyFactory factory, ProjectsProvider projectsProvider) {
        super(remoteServer, data);
        this.myProjectsProvider = projectsProvider;
        List<BuildTypeData> buildTypes = data.getBuildTypes();
        this.myBuildTypes.addAll(factory.convertConfigurationDataToList(buildTypes, projectsProvider));
    }

    @Override
    @NotNull
    public String getProjectId() {
        String string = ((ProjectData)this.getData()).getProjectId();
        if (string == null) {
            BuildProjectProxy.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string = ((ProjectData)this.getData()).getExternalId();
        if (string == null) {
            BuildProjectProxy.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public BuildProject getParentProject() {
        return this.myProjectsProvider.findProjectById(this.getParentProjectId());
    }

    @Override
    @Nullable
    public String getParentProjectId() {
        return ((ProjectData)this.getData()).getParentProjectId();
    }

    @Override
    @Nullable
    public String getParentProjectExternalId() {
        BuildProject parentProject = this.getParentProject();
        return parentProject == null ? null : parentProject.getExternalId();
    }

    @Override
    public boolean isRootProject() {
        return this.getProjectId().equals(ROOT_PROJECT_ID);
    }

    @Override
    @NotNull
    public List<? extends BuildProject> getOwnProjects() {
        ArrayList<BuildProject> result = new ArrayList<BuildProject>();
        this.collectDirectSubProjects(this, result);
        ArrayList<BuildProject> arrayList = result;
        if (arrayList == null) {
            BuildProjectProxy.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @Deprecated
    @NotNull
    public List<? extends BuildProject> getProjects() {
        ArrayList<BuildProject> result = new ArrayList<BuildProject>();
        this.collectAllSubProjects(this, result);
        ArrayList<BuildProject> arrayList = result;
        if (arrayList == null) {
            BuildProjectProxy.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private void collectAllSubProjects(@NotNull BuildProject project, @NotNull List<BuildProject> result) {
        if (project == null) {
            BuildProjectProxy.$$$reportNull$$$0(4);
        }
        if (result == null) {
            BuildProjectProxy.$$$reportNull$$$0(5);
        }
        int indexFrom = result.size();
        this.collectDirectSubProjects(project, result);
        int indexTo = result.size();
        for (int i = indexFrom; i < indexTo; ++i) {
            this.collectAllSubProjects(result.get(i), result);
        }
    }

    private void collectDirectSubProjects(final @NotNull BuildProject project, @NotNull List<BuildProject> result) {
        if (project == null) {
            BuildProjectProxy.$$$reportNull$$$0(6);
        }
        if (result == null) {
            BuildProjectProxy.$$$reportNull$$$0(7);
        }
        FilterUtil.filterAndCopy(this.myProjectsProvider.getAllProjects(), result, (Filter)new Filter<BuildProject>(){

            public boolean accept(@NotNull BuildProject data) {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                return project.getProjectId().equals(data.getParentProjectId());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/serverProxy/BuildProjectProxy$1", "accept"));
            }
        });
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((ProjectData)this.getData()).getName();
        if (string == null) {
            BuildProjectProxy.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullName() {
        LinkedList<String> names = new LinkedList<String>();
        for (BuildProject project = this; project != null && !project.isRootProject(); project = project.getParentProject()) {
            names.add(0, project.getName());
        }
        String string = StringUtil.join((String)" / ", names);
        if (string == null) {
            BuildProjectProxy.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = ((ProjectData)this.getData()).getDescription();
        if (string == null) {
            BuildProjectProxy.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public Status getStatus() {
        return ((ProjectData)this.getData()).getStatus();
    }

    @NotNull
    public List<BuildType> getOwnBuildTypes() {
        List<BuildType> list = this.myBuildTypes;
        if (list == null) {
            BuildProjectProxy.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends BuildType> getBuildTypes() {
        ArrayList<BuildType> result = new ArrayList<BuildType>(this.myBuildTypes);
        for (BuildProject buildProject : this.getProjects()) {
            result.addAll(buildProject.getOwnBuildTypes());
        }
        ArrayList<BuildType> arrayList = result;
        if (arrayList == null) {
            BuildProjectProxy.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public List<VcsRoot> getOwnVcsRoots() {
        List<VcsRoot> list = Collections.emptyList();
        if (list == null) {
            BuildProjectProxy.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<VcsRoot> getVcsRoots() {
        List<VcsRoot> list = Collections.emptyList();
        if (list == null) {
            BuildProjectProxy.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public String toString() {
        String string = this.isRootProject() ? this.getName() : this.getFullName();
        if (string == null) {
            BuildProjectProxy.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull BuildProject o) {
        if (o == null) {
            BuildProjectProxy.$$$reportNull$$$0(16);
        }
        return this.getName().compareToIgnoreCase(o.getName());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildProjectProxy)) {
            return false;
        }
        return this.getProjectId().equals(((BuildProjectProxy)o).getProjectId());
    }

    @Override
    public int hashCode() {
        return this.getProjectId().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverProxy/BuildProjectProxy";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnProjects";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjects";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverProxy/BuildProjectProxy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnBuildTypes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnVcsRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectAllSubProjects";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectDirectSubProjects";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

