/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverProxy;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jetbrains.buildServer.Build;
import jetbrains.buildServer.BuildInstanceData;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.RunningBuild;
import jetbrains.buildServer.StatusDescriptor;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.serverProxy.AbstractProxy;
import jetbrains.buildServer.serverProxy.RemoteBuildServerFacade;
import jetbrains.buildServer.serverSide.userChanges.CanceledInfo;
import jetbrains.buildServer.tests.TestData;
import jetbrains.buildServer.tests.TestInfo;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.users.UserSet;
import jetbrains.buildServer.vcs.SelectPrevBuildPolicy;
import jetbrains.buildServer.vcs.VcsModification;
import org.jetbrains.annotations.NotNull;

public class BuildProxy
extends AbstractProxy<BuildInstanceData>
implements RunningBuild {
    private final BuildType myBuildType;

    public BuildProxy(RemoteBuildServerFacade remoteServer, BuildInstanceData data, BuildType buildType) {
        super(remoteServer, data);
        this.myBuildType = buildType;
    }

    @Override
    public long getEstimationForTimeLeft() {
        return ((BuildInstanceData)this.getData()).getEstimationForTimeLeft();
    }

    @Override
    public long getDurationEstimate() {
        return 0L;
    }

    @Override
    public long getDurationOvertime() {
        return 0L;
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    @Override
    @NotNull
    public Date getStartDate() {
        Date date = ((BuildInstanceData)this.getData()).getStartDate();
        if (date == null) {
            BuildProxy.$$$reportNull$$$0(0);
        }
        return date;
    }

    @Override
    public String getAgentName() {
        return ((BuildInstanceData)this.getData()).getAgentName();
    }

    @Override
    public long getBuildId() {
        return ((BuildInstanceData)this.getData()).getBuildId();
    }

    @Override
    public StatusDescriptor getStatusDescriptor() {
        return ((BuildInstanceData)this.getData()).getStatusDescriptor();
    }

    @Override
    public List<String> getLogMessages(int skipMessages, int maxCount) {
        return this.getRemoteServer().getBuildInstanceLogMessages(this.getBuildId(), skipMessages, maxCount);
    }

    @Override
    public List<TestInfo> getTestMessages(int startFromIdx, int maxTestsToLoad) {
        List<TestData> testDatas = this.getRemoteServer().getBuildFailedTests(this.getBuildId(), startFromIdx, maxTestsToLoad);
        ArrayList<TestInfo> testInfos = new ArrayList<TestInfo>(testDatas.size());
        for (TestData testData : testDatas) {
            testInfos.add(testData.getTestInfo());
        }
        return testInfos;
    }

    @Override
    public List<String> getCompilationErrorMessages() {
        return this.getRemoteServer().getCompilationErrors(this);
    }

    @Override
    public Date getFinishDate() {
        return ((BuildInstanceData)this.getData()).getFinishDate();
    }

    @Override
    public BuildType getBuildType() {
        return this.myBuildType;
    }

    @Override
    @NotNull
    public String getBuildTypeId() {
        String string = this.myBuildType.getBuildTypeId();
        if (string == null) {
            BuildProxy.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getBuildTypeExternalId() {
        String string = this.myBuildType.getExternalId();
        if (string == null) {
            BuildProxy.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getBuildTypeName() {
        String string = this.myBuildType.getName();
        if (string == null) {
            BuildProxy.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = this.myBuildType.getFullName();
        if (string == null) {
            BuildProxy.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getProjectId() {
        String string = this.myBuildType.getProjectId();
        if (string == null) {
            BuildProxy.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getProjectExternalId() {
        String string = this.myBuildType.getProjectExternalId();
        if (string == null) {
            BuildProxy.$$$reportNull$$$0(6);
        }
        return string;
    }

    public List<VcsModification> getChanges(SelectPrevBuildPolicy policy, boolean includeModificationsIfPreviousBuildIsAbsent) {
        return this.getRemoteServer().getBuildInstanceModifications(this.getBuildId(), policy, includeModificationsIfPreviousBuildIsAbsent);
    }

    public List<VcsModification> getContainingChanges() {
        return this.getChanges(SelectPrevBuildPolicy.SINCE_LAST_BUILD, false);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Build && this.getBuildId() == ((Build)o).getBuildId();
    }

    @Override
    public int hashCode() {
        return (int)this.getBuildId();
    }

    @Override
    public boolean isPersonal() {
        return ((BuildInstanceData)this.getData()).isPersonal();
    }

    @Override
    public Status getBuildStatus() {
        return this.getStatusDescriptor().getStatus();
    }

    @Override
    @NotNull
    public String getBuildNumber() {
        String string = ((BuildInstanceData)this.getData()).getBuildNumber();
        if (string == null) {
            BuildProxy.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean isFinished() {
        return ((BuildInstanceData)this.getData()).getFinishDate() != null;
    }

    public String toString() {
        BuildType buildType = this.getBuildType();
        if (buildType != null) {
            return buildType.getProjectName() + ": " + buildType.getName() + " started at " + this.getStartDate() + ": " + this.getStatusDescriptor().getText();
        }
        return "build type unknown";
    }

    public UserSet<User> getCommitters(SelectPrevBuildPolicy selectPrevBuildPolicy) {
        return this.getRemoteServer().getCommitters(this, selectPrevBuildPolicy);
    }

    @Override
    public CanceledInfo getCanceledInfo() {
        return ((BuildInstanceData)this.getData()).getCanceledInfo();
    }

    @Override
    public long getDuration() {
        return ((BuildInstanceData)this.getData()).getDuration();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "jetbrains/buildServer/serverProxy/BuildProxy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartDate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeExternalId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectExternalId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

