/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverProxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.Build;
import jetbrains.buildServer.BuildInstanceData;
import jetbrains.buildServer.BuildProject;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.BuildTypeData;
import jetbrains.buildServer.BuildTypeDescriptor;
import jetbrains.buildServer.BuildTypeStatusDescriptor;
import jetbrains.buildServer.RunningBuild;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.responsibility.BuildTypeResponsibilityEntry;
import jetbrains.buildServer.responsibility.ResponsibilityEntry;
import jetbrains.buildServer.responsibility.ResponsibilityEntryFactory;
import jetbrains.buildServer.responsibility.ResponsibilityId;
import jetbrains.buildServer.responsibility.impl.BuildTypeResponsibilityId;
import jetbrains.buildServer.serverProxy.AbstractProxy;
import jetbrains.buildServer.serverProxy.ProjectsProvider;
import jetbrains.buildServer.serverProxy.ProxyFactory;
import jetbrains.buildServer.serverProxy.RemoteBuildServerFacade;
import jetbrains.buildServer.serverSide.BuildRunnerDescriptor;
import jetbrains.buildServer.serverSide.ResponsibilityInfoData;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.util.Option;
import jetbrains.buildServer.vcs.VcsModification;
import jetbrains.buildServer.vcs.VcsRoot;
import org.jetbrains.annotations.NotNull;

public class BuildTypeProxy
extends AbstractProxy<BuildTypeData>
implements BuildType {
    private final ProjectsProvider myProjectsProvider;
    private List<RunningBuild> myRunningBuilds;
    private Build myLastFinished;
    private boolean myLastFinishedLoaded;
    private Build myLastSuccessfullyFinished;
    private boolean myLastSuccessfullyFinishedLoaded;
    private List<VcsModification> myPendingChanges;
    private List<VcsModification> myModificationsSinceLastSuccessful;
    private ResponsibilityEntry myResponsibility;

    public BuildTypeProxy(RemoteBuildServerFacade remoteServer, BuildTypeData data, ProxyFactory proxyFactory, ProjectsProvider projectsProvider) {
        super(remoteServer, data);
        this.myProjectsProvider = projectsProvider;
        if (data.runningLoaded()) {
            this.myRunningBuilds = new ArrayList<RunningBuild>();
            for (BuildInstanceData buildInstanceData : data.getRunningBuilds()) {
                Build instance = proxyFactory.getOrCreateInstance(buildInstanceData, this, projectsProvider);
                if (!(instance instanceof RunningBuild)) continue;
                this.myRunningBuilds.add((RunningBuild)instance);
            }
        }
        if (data.lastFinishedLoaded()) {
            this.myLastFinishedLoaded = true;
            if (data.getLastFinished() != null) {
                this.myLastFinished = proxyFactory.getOrCreateInstance(data.getLastFinished(), this, projectsProvider);
            }
        }
        if (data.isLastSuccessfullyFinishedLoaded()) {
            this.myLastSuccessfullyFinishedLoaded = true;
            if (data.getLastSuccessfullyFinished() != null) {
                this.myLastSuccessfullyFinished = proxyFactory.getOrCreateInstance(data.getLastSuccessfullyFinished(), this, projectsProvider);
            }
        }
    }

    @NotNull
    public List<RunningBuild> getRunningBuilds() {
        if (this.myRunningBuilds == null) {
            this.myRunningBuilds = this.getRemoteServer().getRunningBuilds(this);
        }
        List<RunningBuild> list = this.myRunningBuilds;
        if (list == null) {
            BuildTypeProxy.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends RunningBuild> getRunningBuilds(User user) {
        List<RunningBuild> list = this.getRunningBuilds();
        if (list == null) {
            BuildTypeProxy.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean isInQueue() {
        return ((BuildTypeData)this.getData()).isInQueue();
    }

    @Override
    public int getNumberQueued() {
        return 0;
    }

    @Override
    public Status getStatus() {
        return ((BuildTypeData)this.getData()).getStatusDescriptor().getStatusDescriptor().getStatus();
    }

    @Override
    @NotNull
    public BuildTypeStatusDescriptor getStatusDescriptor() {
        throw new UnsupportedOperationException("Use .getData().getStatusDescriptor()");
    }

    @Override
    @NotNull
    public String getBuildTypeId() {
        String string = ((BuildTypeData)this.getData()).getId();
        if (string == null) {
            BuildTypeProxy.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string = ((BuildTypeData)this.getData()).getExternalId();
        if (string == null) {
            BuildTypeProxy.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getProjectName() {
        String string = ((BuildTypeData)this.getData()).getProjectName();
        if (string == null) {
            BuildTypeProxy.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public String getName() {
        return ((BuildTypeData)this.getData()).getName();
    }

    @Override
    public String getFullName() {
        BuildProject project = this.myProjectsProvider.findProjectById(this.getProjectId());
        String projectFullName = project == null ? this.getProjectName() : project.getFullName();
        return projectFullName + " / " + this.getName();
    }

    @Override
    public String getDescription() {
        return ((BuildTypeData)this.getData()).getDescription();
    }

    @Override
    public Collection<String> getRunnerTypes() {
        return ((BuildTypeData)this.getData()).getRunnerTypes();
    }

    @Override
    public Build getLastChangesFinished() {
        return this.getLastFinished(true);
    }

    @Override
    public Build getBuildByBuildNumber(@NotNull String buildNumber) {
        if (buildNumber == null) {
            BuildTypeProxy.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Override
    public BuildRunnerDescriptor findBuildRunnerByType(@NotNull String runnerType) {
        if (runnerType == null) {
            BuildTypeProxy.$$$reportNull$$$0(6);
        }
        return this.getRemoteServer().findBuildRunnerByType(this.getBuildTypeId(), runnerType);
    }

    @Override
    public String getBuildParameter(String key) {
        return this.getRemoteServer().getBuildParameter(this.getBuildTypeId(), key);
    }

    public List<VcsModification> getPendingChanges() {
        if (this.myPendingChanges == null) {
            this.myPendingChanges = this.getRemoteServer().getPendingChanges(this);
        }
        return this.myPendingChanges;
    }

    public List<VcsModification> getModificationsSinceLastSuccessful() {
        if (this.myModificationsSinceLastSuccessful == null) {
            this.myModificationsSinceLastSuccessful = this.getRemoteServer().getModificationsSinceLastSuccessful(this);
        }
        return this.myModificationsSinceLastSuccessful;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof BuildType && this.getBuildTypeId().equals(((BuildType)o).getBuildTypeId());
    }

    @Override
    public int hashCode() {
        return this.getBuildTypeId().hashCode();
    }

    @Override
    public BuildTypeDescriptor.CheckoutType getCheckoutType() {
        return ((BuildTypeData)this.getData()).getCheckoutType();
    }

    @Override
    public boolean isPersonal() {
        return false;
    }

    @Override
    @NotNull
    public synchronized ResponsibilityEntry getResponsibilityInfo() {
        if (this.myResponsibility == null) {
            ResponsibilityInfoData data = ((BuildTypeData)this.getData()).getResponsibilityInfo();
            User responsibleUser = data.getResponsibleUser();
            if (responsibleUser == null) {
                BuildTypeResponsibilityEntry buildTypeResponsibilityEntry = ResponsibilityEntryFactory.createEntry(this);
                if (buildTypeResponsibilityEntry == null) {
                    BuildTypeProxy.$$$reportNull$$$0(7);
                }
                return buildTypeResponsibilityEntry;
            }
            this.myResponsibility = ResponsibilityEntryFactory.createEntry(this, data.getState(), responsibleUser, data.getReporterUser(), data.getTimestamp(), data.getComment(), data.getRemoveMethod());
        }
        ResponsibilityEntry responsibilityEntry = this.myResponsibility;
        if (responsibilityEntry == null) {
            BuildTypeProxy.$$$reportNull$$$0(8);
        }
        return responsibilityEntry;
    }

    @Override
    public void setResponsible(@NotNull User responsibleUser, String userComment, User reporterUser) {
        if (responsibleUser == null) {
            BuildTypeProxy.$$$reportNull$$$0(9);
        }
        List<ResponsibilityId> itemIds = Collections.singletonList(BuildTypeResponsibilityId.createFor(this));
        ResponsibilityEntry.RemoveMethod defaultRemoveMethod = ResponsibilityEntry.RemoveMethod.WHEN_FIXED;
        this.getRemoteServer().updateResponsibility(itemIds, ResponsibilityEntry.State.TAKEN, responsibleUser, reporterUser, userComment, defaultRemoveMethod);
    }

    @Override
    public void removeResponsible(boolean buildWasFixed, User responsibleUser, String comment, User whoPerformsTheAction) {
        List<ResponsibilityId> itemIds = Collections.singletonList(BuildTypeResponsibilityId.createFor(this));
        ResponsibilityEntry.RemoveMethod defaultRemoveMethod = ResponsibilityEntry.RemoveMethod.WHEN_FIXED;
        this.getRemoteServer().updateResponsibility(itemIds, buildWasFixed ? ResponsibilityEntry.State.FIXED : ResponsibilityEntry.State.GIVEN_UP, responsibleUser, whoPerformsTheAction, comment, defaultRemoveMethod);
    }

    @Override
    public Build getLastChangesSuccessfullyFinished() {
        if (!this.myLastSuccessfullyFinishedLoaded) {
            try {
                this.myLastSuccessfullyFinished = this.getRemoteServer().getLastSuccessfullyFinished(this);
            }
            finally {
                this.myLastSuccessfullyFinishedLoaded = true;
            }
        }
        return this.myLastSuccessfullyFinished;
    }

    @Override
    @NotNull
    public String getProjectId() {
        String string = ((BuildTypeData)this.getData()).getProjectId();
        if (string == null) {
            BuildTypeProxy.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String getProjectExternalId() {
        String string = ((BuildTypeData)this.getData()).getProjectExternalId();
        if (string == null) {
            BuildTypeProxy.$$$reportNull$$$0(11);
        }
        return string;
    }

    public BuildProject getProject() {
        return this.myProjectsProvider.findProjectById(this.getProjectId());
    }

    @Override
    public boolean isPaused() {
        return ((BuildTypeData)this.getData()).isPaused();
    }

    @Override
    public int compareTo(@NotNull BuildTypeDescriptor o) {
        if (o == null) {
            BuildTypeProxy.$$$reportNull$$$0(12);
        }
        return this.getName().compareToIgnoreCase(o.getName());
    }

    @Override
    public List<? extends VcsRoot> getVcsRoots() {
        return Collections.emptyList();
    }

    private Build getLastFinished(boolean requestFromServer) {
        if (!this.myLastFinishedLoaded && requestFromServer) {
            RemoteBuildServerFacade remoteServer = this.getRemoteServer();
            try {
                this.myLastFinished = remoteServer.getLastFinished(this);
            }
            finally {
                this.myLastFinishedLoaded = true;
            }
        }
        return this.myLastFinished;
    }

    public Build getLastFinishedNoReload() {
        return this.getLastFinished(false);
    }

    @Override
    @NotNull
    public Map<String, String> getBuildParameters() {
        Map<String, String> map = this.getRemoteServer().getBuildParameters(this.getBuildTypeId());
        if (map == null) {
            BuildTypeProxy.$$$reportNull$$$0(13);
        }
        return map;
    }

    @Override
    @NotNull
    public Map<String, String> getParameters() {
        Map<String, String> map = this.getRemoteServer().getParameters(this.getBuildTypeId());
        if (map == null) {
            BuildTypeProxy.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    public Map<String, String> getInternalConfigParameters() {
        Map<String, String> map = ((BuildTypeData)this.getData()).getInternalConfigParameters();
        if (map == null) {
            BuildTypeProxy.$$$reportNull$$$0(15);
        }
        return map;
    }

    @NotNull
    public Collection<Option> getOptions() {
        Set<Option> set = ((BuildTypeData)this.getData()).getOptions().keySet();
        if (set == null) {
            BuildTypeProxy.$$$reportNull$$$0(16);
        }
        return set;
    }

    @NotNull
    public <T> T getOption(@NotNull Option<T> option) {
        if (option == null) {
            BuildTypeProxy.$$$reportNull$$$0(17);
        }
        T t = ((BuildTypeData)this.getData()).getOption(option);
        if (t == null) {
            BuildTypeProxy.$$$reportNull$$$0(18);
        }
        return t;
    }

    public String toString() {
        return this.getFullName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverProxy/BuildTypeProxy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responsibleUser";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningBuilds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverProxy/BuildTypeProxy";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponsibilityInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectExternalId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildParameters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalConfigParameters";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOption";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBuildByBuildNumber";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBuildRunnerByType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setResponsible";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

