/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverProxy;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.Build;
import jetbrains.buildServer.BuildInstanceData;
import jetbrains.buildServer.BuildProject;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.BuildTypeData;
import jetbrains.buildServer.ProjectData;
import jetbrains.buildServer.TeamServerSummary;
import jetbrains.buildServer.TeamServerSummaryData;
import jetbrains.buildServer.UserChangeInfo;
import jetbrains.buildServer.UserChangeInfoData;
import jetbrains.buildServer.serverProxy.BuildProjectProxy;
import jetbrains.buildServer.serverProxy.BuildProxy;
import jetbrains.buildServer.serverProxy.BuildTypeProxy;
import jetbrains.buildServer.serverProxy.ProjectsProvider;
import jetbrains.buildServer.serverProxy.ProxyFactoryListener;
import jetbrains.buildServer.serverProxy.RemoteBuildServerFacade;
import jetbrains.buildServer.serverProxy.VcsModificationProxy;
import jetbrains.buildServer.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyFactory {
    private final Map<String, BuildTypeData> myBuildTypeId2Data = new HashMap<String, BuildTypeData>();
    private final Map<BuildTypeData, BuildType> myTypes = new HashMap<BuildTypeData, BuildType>();
    private final Map<BuildInstanceData, Build> myInstances = new HashMap<BuildInstanceData, Build>();
    private final Map<ProjectData, BuildProject> myProjects = new HashMap<ProjectData, BuildProject>();
    private final RemoteBuildServerFacade myFacade;
    private ProjectsProvider myProjectsProviderForTests;
    private final EventDispatcher<ProxyFactoryListener> myDispatcher = EventDispatcher.create(ProxyFactoryListener.class);

    public ProxyFactory(RemoteBuildServerFacade facade) {
        this.myFacade = facade;
    }

    public void setProjectsProviderForTests(@NotNull ProjectsProvider projectsProvider) {
        if (projectsProvider == null) {
            ProxyFactory.$$$reportNull$$$0(0);
        }
        this.myProjectsProviderForTests = projectsProvider;
    }

    public BuildType getOrCreateBuildType(BuildTypeData data, ProjectsProvider projectsProvider) {
        this.registerBuildTypeData(data);
        return this.getTypeById(data.getId(), projectsProvider);
    }

    BuildType getTypeById(String buildTypeId, ProjectsProvider projectsProvider) {
        BuildTypeData buildTypeData = this.myBuildTypeId2Data.get(buildTypeId);
        if (buildTypeData == null) {
            return null;
        }
        if (this.myTypes.get(buildTypeData) == null) {
            BuildTypeProxy result = new BuildTypeProxy(this.myFacade, buildTypeData, this, projectsProvider);
            this.registerBuildType(result);
            ((ProxyFactoryListener)this.myDispatcher.getMulticaster()).onConfigurationCreated(result);
        }
        return this.myTypes.get(buildTypeData);
    }

    public void registerBuildType(@NotNull BuildTypeProxy buildType) {
        if (buildType == null) {
            ProxyFactory.$$$reportNull$$$0(1);
        }
        this.registerBuildType((BuildTypeData)buildType.getData(), buildType);
    }

    public void registerBuildType(@NotNull BuildTypeData data, @Nullable BuildTypeProxy buildType) {
        if (data == null) {
            ProxyFactory.$$$reportNull$$$0(2);
        }
        this.myTypes.put(data, buildType);
        this.myBuildTypeId2Data.put(data.getId(), data);
    }

    Build getInstanceById(long id, BuildType buildType, ProjectsProvider projectsProvider) {
        for (BuildInstanceData data : this.myInstances.keySet()) {
            if (data.getBuildId() != id) continue;
            if (this.myInstances.get(data) == null) {
                BuildType type;
                BuildType buildType2 = type = buildType == null ? this.getTypeById(data.getBuildTypeId(), projectsProvider) : buildType;
                if (type != null) {
                    BuildProxy result = new BuildProxy(this.myFacade, data, type);
                    ((ProxyFactoryListener)this.myDispatcher.getMulticaster()).onInstanceCreated(result);
                    this.myInstances.put(data, result);
                }
            }
            return this.myInstances.get(data);
        }
        return null;
    }

    void registerBuildTypeData(BuildTypeData buildTypeData) {
        if (!this.myTypes.containsKey(buildTypeData)) {
            this.registerBuildType(buildTypeData, null);
        }
    }

    public TeamServerSummary createSummary(TeamServerSummaryData data) {
        if (data == null) {
            return null;
        }
        ProjectsProvider projectsProvider = this.myProjectsProviderForTests == null ? this.myFacade.getProjectsProvider() : this.myProjectsProviderForTests;
        return new TeamServerSummary(this.convertProjectDataToList(data.getProjects(), projectsProvider), this.convertProjectDataToList(data.getFilteredOutProjectsWithInvetsigations(), projectsProvider), data.getVisibleProjects(), this.convertDataToList(data.getChanges(), projectsProvider), this.convertDataToList(data.getPersonalChanges(), projectsProvider), data.getWatchedConfigurationIds(), data.getWatchedBuildStatus(), data.getProjectStatuses(), data.getTestsWithInvestigation(), data.getResponsibleExists(), data.getChangesStatus(), data.getFilteredOutProjectsCount(), data.getFilteredOutChangesCount(), data.getSummaryCounter());
    }

    public List<BuildType> convertConfigurationDataToList(List<BuildTypeData> buildTypes, ProjectsProvider projectsProvider) {
        ArrayList<BuildType> result = new ArrayList<BuildType>();
        for (BuildTypeData buildType : buildTypes) {
            result.add(this.getOrCreateBuildType(buildType, projectsProvider));
        }
        return result;
    }

    List<BuildProject> convertProjectDataToList(List<ProjectData> projects, ProjectsProvider projectsProvider) {
        ArrayList<BuildProject> result = new ArrayList<BuildProject>();
        for (ProjectData project : projects) {
            result.add(this.getOrCreateProject(project, projectsProvider));
        }
        return result;
    }

    List<UserChangeInfo> convertDataToList(List<UserChangeInfoData> datas, ProjectsProvider projectsProvider) {
        ArrayList<UserChangeInfo> result = new ArrayList<UserChangeInfo>();
        for (UserChangeInfoData data : datas) {
            UserChangeInfo change = this.createChange(data, this, projectsProvider);
            result.add(change);
        }
        return result;
    }

    private UserChangeInfo createChange(UserChangeInfoData data, ProxyFactory factory, ProjectsProvider projectsProvider) {
        UserChangeInfo result = new UserChangeInfo(new VcsModificationProxy(this.myFacade, data.getModificationData()), data.getUserIds(), data.getPersonalDesc());
        result.setChangeStatus(data.getChangeStatus());
        Map<BuildTypeData, BuildInstanceData> map = data.getTypeToInstanceMap();
        Map<BuildTypeData, BuildInstanceData> fixedIn = data.getFixedInMap();
        Map<BuildTypeData, BuildInstanceData> current = data.getCurrentMap();
        for (BuildTypeData typeData : map.keySet()) {
            BuildInstanceData buildInstanceData;
            BuildType buildType = factory.getOrCreateBuildType(typeData, projectsProvider);
            result.addBuildType(buildType);
            if (map.get(typeData) != null) {
                result.setFirstRunIn(buildType, this.getOrCreateInstance(map.get(typeData), buildType, projectsProvider));
            }
            if (fixedIn.get(typeData) != null) {
                result.setFixedIn(buildType, this.getOrCreateInstance(fixedIn.get(typeData), buildType, projectsProvider));
            }
            if ((buildInstanceData = current.get(typeData)) == null) continue;
            result.setCurrent(buildType, this.getOrCreateInstance(buildInstanceData, buildType, projectsProvider));
        }
        return result;
    }

    public Build getOrCreateInstance(BuildInstanceData instanceData, BuildType buildType, ProjectsProvider projectsProvider) {
        if (instanceData == null) {
            return null;
        }
        if (!this.myInstances.containsKey(instanceData)) {
            this.myInstances.put(instanceData, null);
        }
        return this.getInstanceById(instanceData.getBuildId(), buildType, projectsProvider);
    }

    BuildProject getProjectById(String projectId, ProjectsProvider projectsProvider) {
        for (ProjectData data : this.myProjects.keySet()) {
            if (!data.getProjectId().equals(projectId)) continue;
            if (this.myProjects.get(data) == null) {
                BuildProjectProxy result = new BuildProjectProxy(this.myFacade, data, this, projectsProvider);
                this.myProjects.put(data, result);
                ((ProxyFactoryListener)this.myDispatcher.getMulticaster()).onProjectCreated(result);
            }
            return this.myProjects.get(data);
        }
        return null;
    }

    public BuildProject getOrCreateProject(ProjectData projectData, ProjectsProvider projectsProvider) {
        if (!this.myProjects.containsKey(projectData)) {
            this.myProjects.put(projectData, null);
        }
        return this.getProjectById(projectData.getProjectId(), projectsProvider);
    }

    public void addListener(ProxyFactoryListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/serverProxy/ProxyFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setProjectsProviderForTests";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBuildType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

