/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverProxy;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import jetbrains.buildServer.AddToQueueRequest;
import jetbrains.buildServer.AddToQueueResult;
import jetbrains.buildServer.AgentPoolData;
import jetbrains.buildServer.Build;
import jetbrains.buildServer.BuildAgent;
import jetbrains.buildServer.BuildAgentData;
import jetbrains.buildServer.BuildInstanceData;
import jetbrains.buildServer.BuildProject;
import jetbrains.buildServer.BuildRunnerData;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.IncompatiblePluginError;
import jetbrains.buildServer.ProjectData;
import jetbrains.buildServer.RootUrlHolder;
import jetbrains.buildServer.RunningBuild;
import jetbrains.buildServer.TeamServerSummary;
import jetbrains.buildServer.TeamServerSummaryData;
import jetbrains.buildServer.artifacts.ArtifactDependencyInfo;
import jetbrains.buildServer.http.HttpUserAgent;
import jetbrains.buildServer.log.LogUtil;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.messages.XStreamHolder;
import jetbrains.buildServer.notification.NotificationMessage;
import jetbrains.buildServer.responsibility.ResponsibilityEntry;
import jetbrains.buildServer.responsibility.ResponsibilityId;
import jetbrains.buildServer.serverProxy.ApplicationFacade;
import jetbrains.buildServer.serverProxy.ArtifactProvider;
import jetbrains.buildServer.serverProxy.AuthenticatedHttpClient;
import jetbrains.buildServer.serverProxy.BuildAgentProxy;
import jetbrains.buildServer.serverProxy.ClientXmlRpcExecutorFacade;
import jetbrains.buildServer.serverProxy.IdePluginUtil;
import jetbrains.buildServer.serverProxy.ProjectsProvider;
import jetbrains.buildServer.serverProxy.ProxyFactory;
import jetbrains.buildServer.serverProxy.ProxySettings;
import jetbrains.buildServer.serverProxy.RemoteBuildServer;
import jetbrains.buildServer.serverProxy.RemoteBuildServerImpl;
import jetbrains.buildServer.serverProxy.RemoteFacadeListener;
import jetbrains.buildServer.serverProxy.SessionXmlRpcTarget;
import jetbrains.buildServer.serverProxy.VcsModificationProxy;
import jetbrains.buildServer.serverProxy.VersionChecker;
import jetbrains.buildServer.serverProxy.impl.CancelableXmlRpcTargetImpl;
import jetbrains.buildServer.serverProxy.impl.SessionXmlRpcTargetImpl;
import jetbrains.buildServer.serverSide.BuildRunnerDescriptor;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.serverSide.WebLinks;
import jetbrains.buildServer.serverSide.auth.AccessDeniedException;
import jetbrains.buildServer.serverSide.auth.AuthenticationFailedException;
import jetbrains.buildServer.serverSide.tracker.SubscriptionsCollection;
import jetbrains.buildServer.tests.BuildTestsData;
import jetbrains.buildServer.tests.TestData;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.users.UserData;
import jetbrains.buildServer.users.UserSet;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.ExceptionUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.vcs.SelectPrevBuildPolicy;
import jetbrains.buildServer.vcs.VcsChangeInfo;
import jetbrains.buildServer.vcs.VcsException;
import jetbrains.buildServer.vcs.VcsModification;
import jetbrains.buildServer.vcs.VcsModificationData;
import jetbrains.buildServer.version.ServerVersionHolder;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import jetbrains.buildServer.xmlrpc.XmlRpcTarget;
import jetbrains.buildServer.xmlrpc.impl.CommonsXmlRpcTargetImpl;
import jetbrains.buildServer.xstream.ServerXStreamFormat;
import jetbrains.buildServer.xstream.XStreamWrapper;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteBuildServerFacade
implements VersionChecker,
ArtifactProvider {
    private static final Logger LOG = Logger.getLogger(RemoteBuildServerFacade.class);
    private static final XStreamHolder ourXStreamHolder = new XStreamHolder(){

        protected void configureXStream(XStream xStream) {
            ServerXStreamFormat.formatXStream(xStream);
        }
    };
    private RemoteBuildServer myServer;
    private ClientXmlRpcExecutorFacade myStatusFacade;
    private ClientXmlRpcExecutorFacade myAuthenticationFacade;
    private ClientXmlRpcExecutorFacade myNotificationFacade;
    private SessionXmlRpcTarget myTarget;
    private XmlRpcTarget mySimpleTarget;
    private final ApplicationFacade myApplicationFacade;
    private String myUrl;
    private final String myUserAgent;
    private final EventDispatcher<RemoteFacadeListener> myDispatcher = this.createEventDispatcher();
    private final ProjectsProvider myProjectsProvider;
    private String myServerBuildNumber = "<logged out>";
    private String myServerProtocolVersion = null;
    private ClientXmlRpcExecutorFacade myVcsFacade;
    private final ProxySettings myProxySettings;
    private static final int SERVER_COMMUNICATION_TIMEOUT = (int)Dates.ONE_MINUTE;
    private static final boolean myCheckPluginCompatibility = TeamCityProperties.getBooleanOrTrue((String)"teamcity.ideplugin.checkCompatibility");
    private static List<String> ourSupportedProtocolVersions;
    private final Map<String, AuthenticatedHttpClient> myHttpClients = new WeakHashMap<String, AuthenticatedHttpClient>();

    private EventDispatcher<RemoteFacadeListener> createEventDispatcher() {
        EventDispatcher eventDispatcher = EventDispatcher.create(RemoteFacadeListener.class);
        eventDispatcher.setErrorHandler(new EventDispatcher.ErrorHandler(){

            public void handle(Throwable e) {
                if (IdePluginUtil.isDevMode()) {
                    ExceptionUtil.rethrowAsRuntimeException((Throwable)e);
                } else {
                    LOG.error((Object)("Error dispatching event: " + e.toString()));
                    LOG.debug((Object)e.getMessage(), e);
                }
            }
        });
        return eventDispatcher;
    }

    public static RemoteBuildServerFacade createInstance(String serverUrl, String userAgent, ApplicationFacade applicationFacade, ProxySettings proxySettings, ProjectsProvider projectsProvider) throws MalformedURLException {
        SessionXmlRpcTargetImpl target = new SessionXmlRpcTargetImpl(serverUrl, userAgent, SERVER_COMMUNICATION_TIMEOUT);
        RemoteBuildServerFacade.setProxy(proxySettings, target);
        return RemoteBuildServerFacade.createInstance(target, applicationFacade, proxySettings, projectsProvider);
    }

    public static void setProxy(ProxySettings proxySettings, CommonsXmlRpcTargetImpl target) {
        if (proxySettings == null) {
            return;
        }
        if (proxySettings.useProxy()) {
            target.setProxy(proxySettings.getHost(), proxySettings.getPort());
            if (proxySettings.useAuthentication()) {
                String username = proxySettings.getUser();
                int idx = username.indexOf(92);
                if (idx != -1) {
                    String domain = username.substring(0, idx);
                    username = username.substring(idx + 1);
                    target.setProxyCredentials(domain, username, proxySettings.getPassword());
                } else {
                    target.setProxyCredentials(username, proxySettings.getPassword());
                }
            }
        }
    }

    private static RemoteBuildServerFacade createInstance(SessionXmlRpcTarget target, ApplicationFacade applicationFacade, ProxySettings proxySettings, ProjectsProvider projectsProvider) {
        return new RemoteBuildServerFacade(target, applicationFacade, proxySettings, projectsProvider);
    }

    public RemoteBuildServerFacade(SessionXmlRpcTarget target, ApplicationFacade applicationFacade, ProxySettings proxySettings, ProjectsProvider projectsProvider) {
        this.myTarget = target;
        this.myUrl = target.getServerURL();
        this.myUserAgent = target.getUserAgent();
        this.myApplicationFacade = applicationFacade;
        this.myProxySettings = proxySettings;
        this.myProjectsProvider = projectsProvider;
        this.init();
    }

    public void dispose() {
        if (this.myTarget != null) {
            this.myTarget.dispose();
        }
        if (this.mySimpleTarget != null) {
            this.mySimpleTarget.dispose();
        }
    }

    ProjectsProvider getProjectsProvider() {
        return this.myProjectsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuildAgent> getRegisteredAgents() {
        this.remoteCommandStarted();
        try {
            Vector dataList = this.myServer.getRegisteredAgents();
            ArrayList<BuildAgentProxy> result = new ArrayList<BuildAgentProxy>();
            for (Object agentData : dataList) {
                result.add(new BuildAgentProxy(this, (BuildAgentData)this.deserializeObject(agentData)));
            }
            ArrayList<BuildAgentProxy> arrayList = result;
            return arrayList;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuildAgentData> getCanRunAndCompatibleAgents(@NotNull BuildType buildType) {
        if (buildType == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(0);
        }
        this.remoteCommandStarted();
        try {
            Vector dataList = this.myServer.getCanRunAndCompatibleAgents(buildType.getBuildTypeId(), true);
            ArrayList<BuildAgentData> result = new ArrayList<BuildAgentData>();
            for (Object agentData : dataList) {
                BuildAgentData data = (BuildAgentData)this.deserializeObject(agentData);
                result.add(new BuildAgentData(data.getId(), data.getName(), data.isEnabled(), data.isUpgrading()));
            }
            ArrayList<BuildAgentData> arrayList = result;
            return arrayList;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    public List<Pair<AgentPoolData, List<BuildAgentData>>> getGroupedByPoolCanRunAndCompatibleAgents(@NotNull BuildType buildType) {
        if (buildType == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(1);
        }
        this.remoteCommandStarted();
        try {
            List<Pair<AgentPoolData, List<BuildAgentData>>> list = this.deserializeObjects(this.myServer.getGroupedByPoolCanRunAndCompatibleAgents(buildType.getBuildTypeId(), true));
            return list;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    private void remoteCommandFinished() {
        ((RemoteFacadeListener)this.getDispatcher().getMulticaster()).remoteCommandFinished(this);
    }

    public AddToQueueResult addToQueue(BuildType buildType, String triggeredBy) {
        AddToQueueRequest request = new AddToQueueRequest(buildType.getBuildTypeId());
        return this.addToQueue(Collections.singletonList(request), triggeredBy);
    }

    public AddToQueueResult addToQueue(AddToQueueRequest request, String triggeredBy) {
        return this.addToQueue(Collections.singletonList(request), triggeredBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddToQueueResult addToQueue(List<AddToQueueRequest> dataToAdd, String rawTriggeredBy) {
        this.remoteCommandStarted();
        try {
            AddToQueueResult addToQueueResult = (AddToQueueResult)this.deserializeObject(this.myServer.addToQueue(RemoteBuildServerFacade.makeVector(dataToAdd), rawTriggeredBy));
            return addToQueueResult;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    private static <T> Vector makeVector(List<T> list) {
        return XStreamWrapper.serializeObjects(list, (XStreamHolder)ourXStreamHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuildProject> getRegisteredProjects(Boolean loadInstances) {
        this.remoteCommandStarted();
        try {
            Vector dataList = this.myServer.getRegisteredProjects(loadInstances);
            ProxyFactory factory = new ProxyFactory(this);
            ArrayList<BuildProject> result = new ArrayList<BuildProject>();
            for (Object typeData : dataList) {
                ProjectData projectData = (ProjectData)this.deserializeObject(typeData);
                result.add(factory.getOrCreateProject(projectData, this.myProjectsProvider));
            }
            ArrayList<BuildProject> arrayList = result;
            return arrayList;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    private <T> T deserializeObject(Object typeData) {
        return (T)XStreamWrapper.deserializeObject((String)((String)typeData), (XStreamHolder)ourXStreamHolder);
    }

    private <T> T unzipAndDeserializeObject(Object typeData) throws IOException {
        return (T)XStreamWrapper.unzipAndDeserializeObject((byte[])((byte[])typeData), (XStreamHolder)ourXStreamHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getBuildInstanceLogMessages(long buildId, int skipMessages, int maxCount) {
        this.remoteCommandStarted();
        try {
            Vector messages = this.myServer.getBuildInstanceLogMessages(String.valueOf(buildId), skipMessages, maxCount);
            if (messages != null) {
                ArrayList<String> arrayList = new ArrayList<String>(messages);
                return arrayList;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    private void remoteCommandStarted() {
        ((RemoteFacadeListener)this.myDispatcher.getMulticaster()).remoteCommandStarted(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RunningBuild> getRunningBuilds(BuildType buildType) {
        this.remoteCommandStarted();
        try {
            Vector instances = this.myServer.getRunningBuilds(buildType.getBuildTypeId());
            ArrayList<RunningBuild> result = new ArrayList<RunningBuild>();
            ProxyFactory proxyFactory = new ProxyFactory(this);
            for (Object buildInstanceData : instances) {
                BuildInstanceData instanceData = (BuildInstanceData)this.deserializeObject(buildInstanceData);
                result.add((RunningBuild)proxyFactory.getOrCreateInstance(instanceData, buildType, this.myProjectsProvider));
            }
            ArrayList<RunningBuild> arrayList = result;
            return arrayList;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteBuildServerFacade that = (RemoteBuildServerFacade)o;
        return this.myServer.equals(that.myServer);
    }

    public int hashCode() {
        return this.myServer.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TestData> getBuildFailedTests(long buildId, int startFromIdx, int maxTests) {
        this.remoteCommandStarted();
        try {
            Vector result = this.myServer.getBuildFailedTests(String.valueOf(buildId), startFromIdx, maxTests);
            List<TestData> list = this.deserializeObjects(result);
            return list;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsModification> getBuildInstanceModifications(long buildId, SelectPrevBuildPolicy policy, boolean includeModificationsIfPreviousBuildIsAbsent) {
        this.remoteCommandStarted();
        try {
            Vector xmlVector = this.myServer.getBuildInstanceModifications(String.valueOf(buildId), policy.getId(), includeModificationsIfPreviousBuildIsAbsent);
            List datas = this.deserializeObjects(xmlVector);
            ArrayList<VcsModificationProxy> result = new ArrayList<VcsModificationProxy>();
            for (VcsModificationData data : datas) {
                result.add(new VcsModificationProxy(this, data));
            }
            ArrayList<VcsModificationProxy> arrayList = result;
            return arrayList;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    private <T> List<T> deserializeObjects(Vector xmlVector) {
        return XStreamWrapper.deserializeObjects((Collection)xmlVector, (XStreamHolder)ourXStreamHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContentAfter(VcsModification vcsModification, VcsChangeInfo change) throws VcsException {
        this.remoteCommandStarted();
        try {
            if (!vcsModification.isPersonal()) {
                byte[] byArray = this.myServer.getContentAfter(String.valueOf(vcsModification.getId()), change.getFileName());
                return byArray;
            }
            byte[] byArray = this.myServer.getPersonalContentAfter(String.valueOf(vcsModification.getId()), change.getFileName());
            return byArray;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalNumberOfEvents(@NotNull SubscriptionsCollection subscription) {
        if (subscription == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(2);
        }
        this.remoteCommandStarted();
        try {
            Object result = this.myStatusFacade.callXmlRpc("getTotalNumberOfEvents", subscription.serialize());
            if (result instanceof Integer) {
                int n = (Integer)result;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    @NotNull
    public Map<String, List<ArtifactDependencyInfo>> getResolvedArtifactDependencies(@NotNull List<BuildType> buildTypes) {
        if (buildTypes == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(3);
        }
        this.remoteCommandStarted();
        Map map = (Map)this.deserializeObject(this.myServer.getResolvedArtifactDependencies(this.getBuildTypeIds(buildTypes)));
        Map map2 = map;
        if (map2 == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(4);
        }
        return map2;
        finally {
            this.remoteCommandFinished();
        }
    }

    @NotNull
    public Set<String> getBuildTypesWithArtifactDependencies(@NotNull List<BuildType> buildTypes) {
        if (buildTypes == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(5);
        }
        this.remoteCommandStarted();
        HashSet<String> hashSet = new HashSet<String>(this.myServer.getBuildTypesWithArtifactDependencies(this.getBuildTypeIds(buildTypes)));
        HashSet<String> hashSet2 = hashSet;
        if (hashSet2 == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(6);
        }
        return hashSet2;
        finally {
            this.remoteCommandFinished();
        }
    }

    @NotNull
    public Set<String> getBuildTypesWithTests(@NotNull List<BuildType> buildTypes) {
        if (buildTypes == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(7);
        }
        this.remoteCommandStarted();
        HashSet<String> hashSet = new HashSet<String>(this.myServer.getBuildTypesWithTests(this.getBuildTypeIds(buildTypes)));
        HashSet<String> hashSet2 = hashSet;
        if (hashSet2 == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(8);
        }
        return hashSet2;
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Build> lookUpBuildsWithArtifacts(@NotNull List<BuildType> buildTypes, @NotNull List<String> paths) {
        if (buildTypes == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(9);
        }
        if (paths == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(10);
        }
        this.remoteCommandStarted();
        ArrayList<Build> result = new ArrayList<Build>();
        List builds = (List)this.deserializeObject(this.myServer.lookUpBuildsWithArtifacts(new Vector<String>(paths), this.getBuildTypeIds(buildTypes)));
        if (builds != null) {
            ProxyFactory factory = new ProxyFactory(this);
            for (BuildInstanceData build : builds) {
                result.add(factory.getOrCreateInstance(build, factory.getOrCreateBuildType(build.getBuildType(), this.myProjectsProvider), this.myProjectsProvider));
            }
        }
        ArrayList<Build> arrayList = result;
        ArrayList<Build> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(11);
        }
        return arrayList2;
        finally {
            this.remoteCommandFinished();
        }
    }

    @NotNull
    private Vector getBuildTypeIds(@NotNull Collection<BuildType> buildTypes) {
        if (buildTypes == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(12);
        }
        Vector<String> result = new Vector<String>();
        for (BuildType buildType : buildTypes) {
            result.add(buildType.getBuildTypeId());
        }
        Vector<String> vector = result;
        if (vector == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(13);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContentBefore(VcsModification vcsModification, VcsChangeInfo change) throws VcsException {
        this.remoteCommandStarted();
        try {
            if (!vcsModification.isPersonal()) {
                byte[] byArray = this.myServer.getContentBefore(String.valueOf(vcsModification.getId()), change.getFileName());
                return byArray;
            }
            byte[] byArray = this.myServer.getPersonalContentBefore(String.valueOf(vcsModification.getId()), change.getFileName());
            return byArray;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    public List<String> getCompilationErrors(Build build) {
        this.remoteCommandStarted();
        try {
            List<String> list = this.deserializeObjects(this.myServer.getCompilationErrors(String.valueOf(build.getBuildId())));
            return list;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Build getLastFinished(BuildType type) {
        this.remoteCommandStarted();
        try {
            BuildInstanceData instanceData = (BuildInstanceData)this.deserializeObject(this.myServer.getLastFinished(type.getBuildTypeId()));
            if (instanceData == null) {
                Build build = null;
                return build;
            }
            Build build = new ProxyFactory(this).getOrCreateInstance(instanceData, type, this.myProjectsProvider);
            return build;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    public boolean haveCommitDecision(List<String> personalChangeIds) {
        this.remoteCommandStarted();
        try {
            boolean bl = this.myServer.haveCommitDecision(new Vector<String>(personalChangeIds)) == Boolean.TRUE;
            return bl;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<Build> getNewFinishedBuilds(@NotNull List<String> buildIds, @NotNull List<String> buildTypeIds) {
        if (buildIds == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(14);
        }
        if (buildTypeIds == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(15);
        }
        this.remoteCommandStarted();
        List builds = (List)this.deserializeObject(this.myServer.getNewFinishedBuilds(new Vector<String>(buildIds), new Vector<String>(buildTypeIds)));
        if (builds == null) {
            List<Build> list = Collections.emptyList();
            List<Build> list2 = list;
            if (list2 == null) {
                RemoteBuildServerFacade.$$$reportNull$$$0(16);
            }
            return list2;
        }
        ProxyFactory factory = new ProxyFactory(this);
        ArrayList<Build> result = new ArrayList<Build>();
        for (BuildInstanceData build : builds) {
            result.add(factory.getOrCreateInstance(build, factory.getOrCreateBuildType(build.getBuildType(), this.myProjectsProvider), this.myProjectsProvider));
        }
        ArrayList<Build> arrayList = result;
        Object object = arrayList;
        if (object == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(17);
        }
        return object;
        finally {
            this.remoteCommandFinished();
        }
    }

    @NotNull
    public Map<String, Integer> getProblemRelatedEventCounters(@NotNull Collection<String> projectIds) {
        if (projectIds == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(18);
        }
        this.remoteCommandStarted();
        Map map = (Map)this.deserializeObject(this.myServer.getProblemRelatedEventCounters(new Vector<String>(projectIds)));
        Map map2 = map;
        if (map2 == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(19);
        }
        return map2;
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsModification> getPendingChanges(BuildType buildType) {
        this.remoteCommandStarted();
        try {
            List datas = this.deserializeObjects(this.myServer.getPendingChanges(buildType.getBuildTypeId()));
            ArrayList<VcsModificationProxy> result = new ArrayList<VcsModificationProxy>();
            for (VcsModificationData data : datas) {
                result.add(new VcsModificationProxy(this, data));
            }
            ArrayList<VcsModificationProxy> arrayList = result;
            return arrayList;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsModification> getModificationsSinceLastSuccessful(BuildType buildType) {
        this.remoteCommandStarted();
        try {
            List datas = this.deserializeObjects(this.myServer.getModificationsSinceLastSuccessful(buildType.getBuildTypeId()));
            ArrayList<VcsModificationProxy> result = new ArrayList<VcsModificationProxy>();
            for (VcsModificationData data : datas) {
                result.add(new VcsModificationProxy(this, data));
            }
            ArrayList<VcsModificationProxy> arrayList = result;
            return arrayList;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Build findBuildInstanceById(long buildId) {
        this.remoteCommandStarted();
        try {
            String serialized = this.myServer.findBuildInstanceById(String.valueOf(buildId));
            BuildInstanceData data = (BuildInstanceData)this.deserializeObject(serialized);
            if (data != null) {
                ProxyFactory factory = new ProxyFactory(this);
                BuildType type = factory.getOrCreateBuildType(data.getBuildType(), this.myProjectsProvider);
                Build build = factory.getOrCreateInstance(data, type, this.myProjectsProvider);
                return build;
            }
            Build build = null;
            return build;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getBuildParameters(String buildTypeId) {
        this.remoteCommandStarted();
        try {
            String serialized = this.myServer.getBuildParameters(buildTypeId);
            Map map = (Map)this.deserializeObject(serialized);
            return map;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getParameters(String buildTypeId) {
        this.remoteCommandStarted();
        try {
            String serialized = this.myServer.getParameters(buildTypeId);
            Map map = (Map)this.deserializeObject(serialized);
            return map;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, List<BuildTestsData>> findFailedTests(@NotNull String fileFullPath, @NotNull Set<String> testNames) {
        if (fileFullPath == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(20);
        }
        if (testNames == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(21);
        }
        this.remoteCommandStarted();
        Map map = (Map)this.deserializeObject(this.myServer.findFailedTests(fileFullPath, new Vector<String>(testNames)));
        Map map2 = map;
        if (map2 == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(22);
        }
        return map2;
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, List<BuildTestsData>> findTests(@NotNull String fileFullPath, @NotNull Set<String> testNames) {
        if (fileFullPath == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(23);
        }
        if (testNames == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(24);
        }
        this.remoteCommandStarted();
        Map map = (Map)this.deserializeObject(this.myServer.findTests(fileFullPath, new Vector<String>(testNames)));
        Map map2 = map;
        if (map2 == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(25);
        }
        return map2;
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void muteProblems(@NotNull List<ResponsibilityId> itemIds, boolean unmuteWhenFixed, @Nullable Date unmuteDate, @NotNull List<String> buildTypeIds, @NotNull List<Long> buildIds, @NotNull User user, @NotNull String comment) {
        if (itemIds == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(26);
        }
        if (buildTypeIds == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(27);
        }
        if (buildIds == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(28);
        }
        if (user == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(29);
        }
        if (comment == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(30);
        }
        this.remoteCommandStarted();
        try {
            this.myServer.muteProblems(new Vector<String>(RemoteBuildServerFacade.asStrings(itemIds)), unmuteWhenFixed, unmuteDate == null ? "-1" : String.valueOf(unmuteDate.getTime()), new Vector<String>(buildTypeIds), new Vector<String>(RemoteBuildServerFacade.stringValuesOf(buildIds)), String.valueOf(user.getId()), comment);
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmuteProblems(@NotNull List<ResponsibilityId> itemIds, @NotNull User user, @NotNull String comment) {
        if (itemIds == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(31);
        }
        if (user == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(32);
        }
        if (comment == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(33);
        }
        this.remoteCommandStarted();
        try {
            this.myServer.unmuteProblems(new Vector<String>(RemoteBuildServerFacade.asStrings(itemIds)), String.valueOf(user.getId()), comment);
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResponsibility(@NotNull List<ResponsibilityId> itemIds, @NotNull ResponsibilityEntry.State newState, @NotNull User responsibleUser, @NotNull User reporterUser, @NotNull String comment, @NotNull ResponsibilityEntry.RemoveMethod removeMethod) {
        if (itemIds == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(34);
        }
        if (newState == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(35);
        }
        if (responsibleUser == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(36);
        }
        if (reporterUser == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(37);
        }
        if (comment == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(38);
        }
        if (removeMethod == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(39);
        }
        this.remoteCommandStarted();
        try {
            this.myServer.updateResponsibility(new Vector<String>(RemoteBuildServerFacade.asStrings(itemIds)), newState.name(), String.valueOf(responsibleUser.getId()), String.valueOf(reporterUser.getId()), comment, removeMethod.name());
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    @NotNull
    private static List<String> asStrings(@NotNull List<ResponsibilityId> itemIds) {
        if (itemIds == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(40);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (ResponsibilityId itemId : itemIds) {
            strings.add(itemId.asString());
        }
        ArrayList<String> arrayList = strings;
        if (arrayList == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    private static List<String> stringValuesOf(@NotNull List<Long> itemIds) {
        if (itemIds == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(42);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Long itemId : itemIds) {
            strings.add(String.valueOf(itemId));
        }
        return strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserData checkPassword(String username, String password) throws AuthenticationFailedException, ProcessCanceledException {
        this.remoteCommandStarted();
        try {
            this.checkServerVersion();
            try {
                this.myTarget.setCredentials(username, password);
                this.myTarget.authenticate(this.myApplicationFacade.createCancelable());
            }
            catch (AuthenticationFailedException e) {
                throw e;
            }
            catch (XmlRpcTarget.ProcessCanceledException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (Throwable e) {
                if (e.getMessage().contains("RPC handler object \"RemoteAuthenticationServer\" not found and no default handler registered")) {
                    throw new IncompatiblePluginError("The server does not support authorization", null, null, null);
                }
                throw new RuntimeException(e);
            }
            UserData userData = (UserData)this.deserializeObject(this.myServer.findUserById(String.valueOf(this.myTarget.getUserId())));
            return userData;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserData findUserById(long userId) {
        this.remoteCommandStarted();
        try {
            String userAsString = this.myServer.findUserById(String.valueOf(userId));
            UserData userData = (UserData)this.deserializeObject(userAsString);
            return userData;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    public UserSet<User> getUsers() {
        this.remoteCommandStarted();
        try {
            final List list = this.deserializeObjects(this.myServer.getUsers());
            UserSet<User> userSet = new UserSet<User>(){

                @Override
                public Set<User> getUsers() {
                    return new HashSet<User>(list);
                }
            };
            return userSet;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSet<User> getProjectCommitters(String projectId) {
        this.remoteCommandStarted();
        try {
            final List list = this.deserializeObjects(this.myServer.getProjectCommitters(projectId));
            UserSet<User> userSet = new UserSet<User>(){

                @Override
                public Set<User> getUsers() {
                    return new HashSet<User>(list);
                }
            };
            return userSet;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBuild(RunningBuild instance, User user, String reason) {
        this.remoteCommandStarted();
        try {
            this.myServer.stopBuild(String.valueOf(instance.getBuildId()), String.valueOf(user.getId()), reason);
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPendingPersonalBuild(VcsModification modification, BuildType buildType, User user, String reason) {
        this.remoteCommandStarted();
        try {
            this.myServer.stopPendingPersonalBuild(String.valueOf(modification.getId()), buildType.getBuildTypeId(), String.valueOf(user.getId()), reason);
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repeatRemoteDebugSession(long personalChangeId, String buildTypeId) {
        this.remoteCommandStarted();
        try {
            this.myServer.repeatRemoteDebugSession(String.valueOf(personalChangeId), buildTypeId);
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repeatRemoteDebugSessionWithNewChanges(long personalChangeId, String buildTypeId, long newChangesPersonalPatchId) {
        this.remoteCommandStarted();
        try {
            this.myServer.repeatRemoteDebugSessionWithNewChanges(String.valueOf(personalChangeId), buildTypeId, String.valueOf(newChangesPersonalPatchId));
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRemoteDebugSession(long personalChangeId, String buildTypeId) {
        this.remoteCommandStarted();
        try {
            this.myServer.finishRemoteDebugSession(String.valueOf(personalChangeId), buildTypeId);
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fetchData(long userId, long buildId, String sourceId, String whatToFetch) {
        this.remoteCommandStarted();
        try {
            byte[] byArray = this.myServer.fetchData(String.valueOf(userId), String.valueOf(buildId), sourceId, whatToFetch);
            return byArray;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSet<User> getCommitters(Build buildInstance, SelectPrevBuildPolicy selectPrevBuildPolicy) {
        this.remoteCommandStarted();
        try {
            List list = this.deserializeObjects(this.myServer.getCommitters(String.valueOf(buildInstance.getBuildId()), selectPrevBuildPolicy.getId()));
            final HashSet users = new HashSet(list);
            UserSet<User> userSet = new UserSet<User>(){

                @Override
                public Set<User> getUsers() {
                    return users;
                }
            };
            return userSet;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamServerSummary getSummary(@NotNull User user, @Nullable Collection<String> samplePaths, ProxyFactory proxyFactory) {
        if (user == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(43);
        }
        this.remoteCommandStarted();
        try {
            TeamServerSummaryData data;
            LOG.debug((Object)("Requesting summary for user " + user.describe(false) + " with sample paths: " + samplePaths));
            byte[] serializedStr = samplePaths == null ? (byte[])this.myStatusFacade.callXmlRpc("getGZippedSummary", String.valueOf(user.getId())) : (byte[])this.myStatusFacade.callXmlRpc("getFilteredGZippedSummaryByVcsUris", String.valueOf(user.getId()), new Vector<String>(samplePaths));
            LOG.debug((Object)("Fetched gzipped summary size is " + serializedStr.length));
            try {
                data = (TeamServerSummaryData)this.unzipAndDeserializeObject(serializedStr);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            TeamServerSummary teamServerSummary = proxyFactory.createSummary(data);
            return teamServerSummary;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    public TeamServerSummary getSummary(User user) {
        return this.getSummary(user, null, new ProxyFactory(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Build getLastSuccessfullyFinished(BuildType buildType) {
        this.remoteCommandStarted();
        try {
            BuildInstanceData data = (BuildInstanceData)this.deserializeObject(this.myServer.getLastSuccessfullyFinished(buildType.getBuildTypeId()));
            Build build = new ProxyFactory(this).getOrCreateInstance(data, buildType, this.myProjectsProvider);
            return build;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildRunnerDescriptor findBuildRunnerByType(String buildTypeId, String runnerType) {
        this.remoteCommandStarted();
        try {
            BuildRunnerDescriptor buildRunnerDescriptor = (BuildRunnerDescriptor)this.deserializeObject(this.myServer.findBuildRunnerByType(buildTypeId, runnerType));
            return buildRunnerDescriptor;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    @NotNull
    public Map<String, List<BuildRunnerData>> getBuildRunners(@NotNull Collection<BuildType> buildTypes) {
        if (buildTypes == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(44);
        }
        this.remoteCommandStarted();
        Map map = (Map)this.deserializeObject(this.myServer.getBuildRunners(this.getBuildTypeIds(buildTypes)));
        Map map2 = map;
        if (map2 == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(45);
        }
        return map2;
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBuildParameter(String buildTypeId, String key) {
        this.remoteCommandStarted();
        try {
            String string = (String)this.deserializeObject(this.myServer.getBuildParameter(buildTypeId, key));
            return string;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsChangeInfo> getModificationFiles(String modId, boolean personalChange) {
        this.remoteCommandStarted();
        try {
            List<VcsChangeInfo> list = this.deserializeObjects(this.myServer.getModificationFiles(modId, personalChange));
            return list;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    @NotNull
    public String getServerUrl() {
        String string = this.myUrl;
        if (string == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(46);
        }
        return string;
    }

    public static XStreamHolder getServerFormatXStreamHolder() {
        return ourXStreamHolder;
    }

    public void logout() {
        this.remoteCommandStarted();
        try {
            this.myTarget.logout();
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    public SessionXmlRpcTarget getSession() {
        return this.myTarget;
    }

    public SessionXmlRpcTarget getWrappedSession(int timeout) {
        try {
            SessionXmlRpcTargetImpl target = new SessionXmlRpcTargetImpl((SessionXmlRpcTargetImpl)this.myTarget, timeout);
            RemoteBuildServerFacade.setProxy(this.myProxySettings, target);
            return target;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void setSession(SessionXmlRpcTarget session, String url, String serverBuildNumber) {
        if (session != this.myTarget) {
            this.myTarget.dispose();
        }
        this.myTarget = session;
        this.myUrl = url;
        this.myServerBuildNumber = serverBuildNumber;
        this.init();
    }

    void init() {
        int statusFacadeTimeout = TeamCityProperties.getInteger((String)"teamcity.ideplugin.xmlrpc.facade.status.timeout.seconds", (int)300) * 1000;
        int vcsFacadeTimeout = TeamCityProperties.getInteger((String)"teamcity.ideplugin.xmlrpc.facade.vcs.timeout.seconds", (int)300) * 1000;
        if (this.mySimpleTarget != null) {
            this.mySimpleTarget.dispose();
        }
        this.mySimpleTarget = this.createSimpleTarget();
        this.myServer = new RemoteBuildServerImpl(this.myTarget, this.myApplicationFacade, this);
        this.myStatusFacade = new ClientXmlRpcExecutorFacade(this.getWrappedSession(statusFacadeTimeout), this.myApplicationFacade, "UserSummaryRemoteManager2", this);
        this.myAuthenticationFacade = new ClientXmlRpcExecutorFacade(this.mySimpleTarget, this.myApplicationFacade, "RemoteAuthenticationServer", new VersionChecker(){

            @Override
            public void checkServerVersion() throws IncompatiblePluginError {
            }
        });
        this.myNotificationFacade = new ClientXmlRpcExecutorFacade(this.mySimpleTarget, this.myApplicationFacade, "IDEPluginNotificator", this);
        this.myVcsFacade = new ClientXmlRpcExecutorFacade(this.getWrappedSession(vcsFacadeTimeout), this.myApplicationFacade, "VersionControlServer", this);
    }

    protected XmlRpcTarget createSimpleTarget() {
        try {
            CancelableXmlRpcTargetImpl result = new CancelableXmlRpcTargetImpl(this.myUrl, this.myUserAgent, SERVER_COMMUNICATION_TIMEOUT, true);
            RemoteBuildServerFacade.setProxy(this.myProxySettings, result);
            return result;
        }
        catch (MalformedURLException e) {
            throw new RemoteCallException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersonalChangeStatus(long id, Status status) {
        this.remoteCommandStarted();
        try {
            this.myServer.setPersonalChangeStatus(String.valueOf(id), status.getPriority());
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getRunningBuildInfoList(final long userId, final boolean filterBySuitableConfigurations, @NotNull Collection<String> collection) {
        void samplePaths;
        if (collection == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(47);
        }
        List<String> list = this.goGetRunningBuildInfoList(new Computable<Object>((Collection)samplePaths){
            final /* synthetic */ Collection val$samplePaths;
            {
                this.val$samplePaths = collection;
            }

            public Object compute() {
                return RemoteBuildServerFacade.this.myStatusFacade.callXmlRpc("getWatchedRunningBuildsStatus", String.valueOf(userId), filterBySuitableConfigurations, new Vector(this.val$samplePaths));
            }
        });
        if (list == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public List<String> getRunningBuildInfoList() {
        List<String> list = this.goGetRunningBuildInfoList(new Computable<Object>(){

            public Object compute() {
                return RemoteBuildServerFacade.this.myStatusFacade.callXmlRpc("getRunningBuildsStatus", new Object[0]);
            }
        });
        if (list == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(49);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<String> goGetRunningBuildInfoList(@NotNull Computable<Object> runningBuildInfoListProvider) {
        if (runningBuildInfoListProvider == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(50);
        }
        ArrayList<String> result = new ArrayList<String>();
        this.remoteCommandStarted();
        try {
            Object fromServer = runningBuildInfoListProvider.compute();
            if (fromServer instanceof Vector) {
                for (Object o : (Vector)fromServer) {
                    if (!(o instanceof String)) continue;
                    result.add((String)o);
                }
            }
        }
        finally {
            this.remoteCommandFinished();
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    public void pingServer() {
        this.remoteCommandStarted();
        try {
            this.checkServerVersion();
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    @Override
    public void checkServerVersion() throws IncompatiblePluginError {
        List<String> supportedVersions;
        String sVersion;
        this.myServerBuildNumber = "loading...";
        this.myServerProtocolVersion = null;
        try {
            sVersion = (String)this.myAuthenticationFacade.callXmlRpc("getServerVersion", new Object[0]);
        }
        catch (RemoteCallException e) {
            Throwable cause = e.getCause();
            String causeLocalizedMessage = cause.getLocalizedMessage();
            if (causeLocalizedMessage != null && causeLocalizedMessage.contains("java.lang.NoSuchMethodException")) {
                throw new IncompatiblePluginError(null, null, null, this.myServerBuildNumber);
            }
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.myServerProtocolVersion = sVersion;
        this.myServerBuildNumber = (String)this.myAuthenticationFacade.callXmlRpc("getServerBuildNumber", new Object[0]);
        if (myCheckPluginCompatibility && !(supportedVersions = RemoteBuildServerFacade.getSupportedProtocolVersions()).contains(sVersion)) {
            throw new IncompatiblePluginError("Plugin supports protocol versions " + supportedVersions + " but server protocol version is " + sVersion, supportedVersions.iterator().next(), sVersion, this.myServerBuildNumber);
        }
    }

    private static List<String> getSupportedProtocolVersions() {
        if (ourSupportedProtocolVersions == null) {
            String version = ServerVersionHolder.getVersion().getPluginProtocolVersion();
            ourSupportedProtocolVersions = version.equals("17.2.0.0") ? Arrays.asList(version, "10.0.0.0", "9.0.0.0") : Collections.singletonList(version);
        }
        return ourSupportedProtocolVersions;
    }

    public EventDispatcher<RemoteFacadeListener> getDispatcher() {
        return this.myDispatcher;
    }

    public ApplicationFacade getApplicationFacade() {
        return this.myApplicationFacade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentNotificationTimestamp() {
        this.remoteCommandStarted();
        try {
            String timestamp = (String)this.myNotificationFacade.callXmlRpc("getCurrentTimestamp", new Object[0]);
            long l = Long.parseLong(timestamp);
            return l;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NotificationMessage> getNotifications(User user, long notificationTimestamp) {
        this.remoteCommandStarted();
        try {
            Vector serializedMessages = (Vector)this.myNotificationFacade.callXmlRpc("getBuildMessages", String.valueOf(user.getId()), String.valueOf(notificationTimestamp));
            List<NotificationMessage> list = this.deserializeObjects(serializedMessages);
            return list;
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedulePersonalChangeForDeletion(long id, User user) {
        this.remoteCommandStarted();
        try {
            this.myServer.schedulePersonalChangeForDeletion(String.valueOf(id), String.valueOf(user.getId()));
        }
        finally {
            this.remoteCommandFinished();
        }
    }

    public String getServerBuildNumber() {
        return this.myServerBuildNumber;
    }

    @Nullable
    public String getServerProtocolVersion() {
        return this.myServerProtocolVersion;
    }

    public Collection<String> getSuitableConfigurationIds(Collection<String> filePaths) {
        Vector ids = (Vector)this.myVcsFacade.callXmlRpc("getSuitableConfigurations", new Vector<String>(filePaths));
        ArrayList<String> result = new ArrayList<String>();
        for (Object id : ids) {
            result.add((String)id);
        }
        return result;
    }

    public void setServerBuildVersion(String serverVersion) {
        this.myServerBuildNumber = serverVersion;
    }

    @Override
    public void downloadArtifact(@NotNull Build build, @NotNull String artifactPath, @NotNull File targetFile) throws IOException {
        if (build == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(52);
        }
        if (artifactPath == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(53);
        }
        if (targetFile == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(54);
        }
        this.checkAuthenticated("User must be authenticated to download artifacts from TeamCity server");
        this.downloadFile(this.getHttpClient(), this.getArtifactUrl(build, artifactPath), targetFile);
    }

    @Override
    public boolean checkArtifactExists(@NotNull Build build, @NotNull String artifactPath) throws IOException {
        if (build == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(55);
        }
        if (artifactPath == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(56);
        }
        this.checkAuthenticated("User must be authenticated to check artifacts existence");
        return this.checkFileExists(this.getHttpClient(), this.getArtifactUrl(build, artifactPath));
    }

    private String getArtifactUrl(Build build, String artifactPath) {
        BuildType bt = build.getBuildType();
        if (bt == null) {
            throw new RuntimeException("Build configuration with internal id " + LogUtil.quote((String)build.getBuildTypeId()) + " does not exist anymore.");
        }
        return this.getBasicAuthWebLinks().getDownloadArtefactUrl(bt.getExternalId(), build.getBuildId(), artifactPath);
    }

    private void checkAuthenticated(@NotNull String message) {
        if (message == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(57);
        }
        if (!this.myTarget.isAuthenticated()) {
            throw new AccessDeniedException(null, message);
        }
    }

    private AuthenticatedHttpClient getHttpClient() throws MalformedURLException {
        AuthenticatedHttpClient client = this.myHttpClients.get(this.getServerUrl());
        if (client == null) {
            String username = this.myTarget.getUsername();
            String password = this.myTarget.getPassword();
            String url = this.getServerUrl();
            client = new AuthenticatedHttpClient(url, username, password, SERVER_COMMUNICATION_TIMEOUT / 1000);
            this.myHttpClients.put(url, client);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(AuthenticatedHttpClient client, String url, File file) throws IOException {
        final XmlRpcTarget.Cancelable cancelable = this.myApplicationFacade.createCancelable();
        GetMethod get = new GetMethod(url);
        HttpUserAgent.addHeader((HttpMethod)get);
        try {
            int statusCode = client.executeMethod((HttpMethod)get);
            if (statusCode == 200) {
                try (BufferedOutputStream target = new BufferedOutputStream(new FileOutputStream(file));){
                    TCStreamUtil.writeBinary((InputStream)new BufferedInputStream(get.getResponseBodyAsStream()), (OutputStream)target, (TCStreamUtil.WriteProgressListener)(cancelable == null ? null : new TCStreamUtil.WriteProgressListener(){

                        public void nextPortionWritten(long writtenSoFar, boolean finished) {
                        }

                        public boolean isInterrupted() {
                            return cancelable != null && cancelable.isCanceled();
                        }
                    }), (long)0L);
                    return;
                }
            }
            if (statusCode == 404) {
                throw new FileNotFoundException("File does not exist on the server: " + url);
            }
            this.processErrorStatus((HttpMethod)get, url);
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFileExists(AuthenticatedHttpClient client, String url) throws IOException {
        HeadMethod head = new HeadMethod(url);
        try {
            int statusCode = client.executeMethod((HttpMethod)head);
            if (statusCode == 200) {
                boolean bl = true;
                return bl;
            }
            if (statusCode == 404) {
                boolean bl = false;
                return bl;
            }
            this.processErrorStatus((HttpMethod)head, url);
        }
        finally {
            head.releaseConnection();
        }
        return false;
    }

    private void processErrorStatus(@NotNull HttpMethod method, @NotNull String url) throws IOException {
        if (method == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(58);
        }
        if (url == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(59);
        }
        switch (method.getStatusCode()) {
            case 403: {
                throw new AccessDeniedException(null, "You do not have enough permissions to access url: " + url);
            }
            case 401: {
                throw new AuthenticationFailedException();
            }
        }
        throw new IOException("Incorrect status code returned: " + method.getStatusCode() + ", status line: " + method.getStatusLine().toString());
    }

    public WebLinks getWebLinks() {
        return new WebLinks(new RootUrlHolder(){

            @Override
            @NotNull
            public String getRootUrl() {
                String string = RemoteBuildServerFacade.this.getServerUrl();
                if (string == null) {
                    10.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void setRootUrl(@NotNull String rootUrl) {
                if (rootUrl == null) {
                    10.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jetbrains/buildServer/serverProxy/RemoteBuildServerFacade$10";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootUrl";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRootUrl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "jetbrains/buildServer/serverProxy/RemoteBuildServerFacade$10";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setRootUrl";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private WebLinks getBasicAuthWebLinks() {
        return new WebLinks(new RootUrlHolder(){

            @Override
            @NotNull
            public String getRootUrl() {
                String serverUrl = RemoteBuildServerFacade.this.getServerUrl();
                if (serverUrl.endsWith("/")) {
                    String string = serverUrl + "httpAuth/";
                    if (string == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = serverUrl + "/httpAuth/";
                if (string == null) {
                    11.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public void setRootUrl(@NotNull String rootUrl) {
                if (rootUrl == null) {
                    11.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jetbrains/buildServer/serverProxy/RemoteBuildServerFacade$11";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootUrl";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRootUrl";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "jetbrains/buildServer/serverProxy/RemoteBuildServerFacade$11";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setRootUrl";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Deprecated
    @NotNull
    public Map<BuildType, Build> getBuildsWithArtifacts(@NotNull List<String> artifactsPaths) {
        if (artifactsPaths == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(60);
        }
        List<Build> builds = this.lookUpBuildsWithArtifacts(Collections.emptyList(), artifactsPaths);
        HashMap<BuildType, Build> result = new HashMap<BuildType, Build>();
        for (Build build : builds) {
            result.put(build.getBuildType(), build);
        }
        HashMap<BuildType, Build> hashMap = result;
        if (hashMap == null) {
            RemoteBuildServerFacade.$$$reportNull$$$0(61);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subscription";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypes";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverProxy/RemoteBuildServerFacade";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 14: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildIds";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeIds";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIds";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFullPath";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 26: 
            case 31: 
            case 34: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemIds";
                break;
            }
            case 29: 
            case 32: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 30: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responsibleUser";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporterUser";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeMethod";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samplePaths";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningBuildInfoListProvider";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPath";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactsPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverProxy/RemoteBuildServerFacade";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedArtifactDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypesWithArtifactDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypesWithTests";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "lookUpBuildsWithArtifacts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeIds";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFinishedBuilds";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemRelatedEventCounters";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findFailedTests";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findTests";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "asStrings";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildRunners";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerUrl";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningBuildInfoList";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "goGetRunningBuildInfoList";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildsWithArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCanRunAndCompatibleAgents";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGroupedByPoolCanRunAndCompatibleAgents";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTotalNumberOfEvents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedArtifactDependencies";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 61: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTypesWithArtifactDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTypesWithTests";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lookUpBuildsWithArtifacts";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTypeIds";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNewFinishedBuilds";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getProblemRelatedEventCounters";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findFailedTests";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findTests";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "muteProblems";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "unmuteProblems";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateResponsibility";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "asStrings";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "stringValuesOf";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSummary";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getBuildRunners";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getRunningBuildInfoList";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "goGetRunningBuildInfoList";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "downloadArtifact";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "checkArtifactExists";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkAuthenticated";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "processErrorStatus";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getBuildsWithArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

