/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverProxy.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import jetbrains.buildServer.serverProxy.InvalidXmlRpcSessionException;
import jetbrains.buildServer.serverProxy.SessionXmlRpcTarget;
import jetbrains.buildServer.serverProxy.impl.CancelableXmlRpcTargetImpl;
import jetbrains.buildServer.serverSide.auth.AuthenticationFailedException;
import jetbrains.buildServer.serverSide.crypt.RSACipher;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import jetbrains.buildServer.xmlrpc.XmlRpcTarget;
import jetbrains.buildServer.xmlrpc.impl.MyXmlRpcTransport;
import org.apache.commons.httpclient.Cookie;
import org.jetbrains.annotations.Nullable;

public class SessionXmlRpcTargetImpl
extends CancelableXmlRpcTargetImpl
implements SessionXmlRpcTarget {
    private static final Logger LOG = Logger.getInstance((String)SessionXmlRpcTargetImpl.class.getName());
    private String myUsername;
    private String myPassword;
    private String mySessionId;
    private Integer myUserId = null;
    private boolean myAutoRelogin = false;

    public SessionXmlRpcTargetImpl(SessionXmlRpcTargetImpl sourceTarget, int connectionTimeout) throws MalformedURLException {
        super(sourceTarget, connectionTimeout);
        this.mySessionId = sourceTarget.mySessionId;
        this.myUsername = sourceTarget.myUsername;
        this.myPassword = sourceTarget.myPassword;
        this.myUserId = sourceTarget.myUserId;
        this.myAutoRelogin = sourceTarget.myAutoRelogin;
    }

    public SessionXmlRpcTargetImpl(String serverURL, String userAgent, int connectionTimeout) throws MalformedURLException {
        super(serverURL, userAgent, connectionTimeout, true, ConcurrencyUtil.newSingleThreadExecutor((String)"TeamCity XML-RPC Session Executor"));
    }

    @Override
    public void setCredentials(String username, String password) {
        assert (username != null);
        assert (password != null);
        this.myUsername = username;
        this.myPassword = password;
    }

    @Override
    public String getUsername() {
        return this.myUsername;
    }

    @Override
    public String getPassword() {
        return this.myPassword;
    }

    @Override
    public void setAutoRelogin(boolean autoRelogin) {
        this.myAutoRelogin = autoRelogin;
    }

    @Override
    public Object call(final String method, final Object[] parameters, final XmlRpcTarget.Cancelable cancelable) throws InvalidXmlRpcSessionException, RemoteCallException, XmlRpcTarget.ProcessCanceledException {
        return this.doRemoteCall(new XmlRpcMethod(){

            @Override
            public Object invoke() {
                return SessionXmlRpcTargetImpl.super.call(method, parameters, cancelable);
            }
        }, cancelable);
    }

    @Override
    public Object call(final String method, final Object[] parameters) throws InvalidXmlRpcSessionException, RemoteCallException {
        return this.doRemoteCall(new XmlRpcMethod(){

            @Override
            public Object invoke() {
                return SessionXmlRpcTargetImpl.super.call(method, parameters);
            }
        }, null);
    }

    @Override
    @Nullable
    public synchronized Integer getUserId() {
        return this.myUserId;
    }

    @Override
    public synchronized String getSessionId() {
        return this.mySessionId;
    }

    @Override
    public synchronized boolean isAuthenticated() {
        return this.mySessionId != null;
    }

    @Override
    public synchronized void authenticate(@Nullable XmlRpcTarget.Cancelable cancelable) throws AuthenticationFailedException, RemoteCallException {
        String publicKey = (String)this.call("RemoteAuthenticationServer.getPublicKey", XmlRpcTarget.EMPTY_PARAMETERS, cancelable);
        if (publicKey == null) {
            throw new AuthenticationFailedException("Failed to retrieve public key");
        }
        String[] parts = publicKey.split(":");
        if (parts.length < 2) {
            throw new AuthenticationFailedException("Failed to retrieve public key");
        }
        try {
            String encryptedPass;
            PublicKey key = RSACipher.recreateKey((String)parts[0], (String)parts[1]);
            try {
                encryptedPass = RSACipher.encryptData((String)this.myPassword, (PublicKey)key, (Charset)StandardCharsets.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("utf-8 is not supported on the machine");
            }
            String result = (String)this.call("RemoteAuthenticationServer.authenticate", new Object[]{this.myUsername, encryptedPass}, cancelable);
            if (result == null) {
                throw new AuthenticationFailedException("Failed to authenticate on server");
            }
            parts = result.split(":");
            if (parts.length < 2) {
                throw new AuthenticationFailedException("Failed to authenticate on server");
            }
            LOG.debug("Session " + parts[0] + " was set");
            this.mySessionId = parts[0];
            try {
                this.myUserId = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                this.invalidateSession();
                throw new AuthenticationFailedException("Failed to authenticate on server");
            }
        }
        catch (InvalidKeyException e) {
            throw new AuthenticationFailedException("Received public key is invalid: " + e.getMessage());
        }
        catch (RemoteCallException e) {
            String message = SessionXmlRpcTargetImpl.extractExceptionMessage(e, AuthenticationFailedException.class);
            if (message != null) {
                throw new AuthenticationFailedException(message);
            }
            throw e;
        }
    }

    @Override
    public synchronized boolean logout() {
        Boolean result = (Boolean)this.call("RemoteAuthenticationServer.logout", XmlRpcTarget.EMPTY_PARAMETERS);
        this.invalidateSession();
        return result;
    }

    protected MyXmlRpcTransport getOrCreateTransport() {
        MyXmlRpcTransport result = super.getOrCreateTransport();
        if (this.mySessionId != null) {
            this.myState.addCookie(new Cookie(this.myServerRpcURL.getHost(), "xmlrpcsessionId", this.mySessionId, "/", -1, false));
        }
        return result;
    }

    private Object doRemoteCall(XmlRpcMethod xmlRpcMethod, @Nullable XmlRpcTarget.Cancelable cancelable) throws InvalidXmlRpcSessionException, AuthenticationFailedException, RemoteCallException {
        try {
            return xmlRpcMethod.invoke();
        }
        catch (RemoteCallException e) {
            String message = SessionXmlRpcTargetImpl.extractExceptionMessage(e, InvalidXmlRpcSessionException.class);
            if (message == null) {
                throw e;
            }
            this.invalidateSession();
            if (!this.myAutoRelogin) {
                throw new InvalidXmlRpcSessionException(message);
            }
            this.authenticate(cancelable);
            try {
                return xmlRpcMethod.invoke();
            }
            catch (RemoteCallException e1) {
                message = SessionXmlRpcTargetImpl.extractExceptionMessage(e1, InvalidXmlRpcSessionException.class);
                if (message != null) {
                    this.invalidateSession();
                    throw new InvalidXmlRpcSessionException(message);
                }
                throw e1;
            }
        }
    }

    private void invalidateSession() {
        LOG.debug("Session is invalidating", new Throwable());
        this.mySessionId = null;
        this.myUserId = null;
    }

    public void disposeConnections() {
        LOG.info("Disposing XML-RPC session connections");
        LOG.debug("Disposing XML-RPC session connections", new Throwable());
        super.disposeConnections();
        this.invalidateSession();
    }

    private static <T> String extractExceptionMessage(RemoteCallException e, Class<T> clazz) {
        String prefix;
        String message;
        Throwable cause = e.getCause();
        if (cause != null && (message = cause.getMessage()) != null && message.contains(prefix = clazz.getName() + ":")) {
            return message.substring(message.indexOf(prefix) + prefix.length());
        }
        return null;
    }

    private static interface XmlRpcMethod {
        public Object invoke();
    }
}

