/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import java.util.Date;
import jetbrains.buildServer.responsibility.ResponsibilityEntry;
import jetbrains.buildServer.responsibility.impl.Util;
import jetbrains.buildServer.users.SimpleUserData;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.util.Dates;
import org.jetbrains.annotations.NotNull;

public class ResponsibilityInfoData {
    private final SimpleUserData myUser;
    private final SimpleUserData myReporterUser;
    private final String myUserComment;
    private final Date myTimestamp;
    private final ResponsibilityEntry.State myState;
    private final ResponsibilityEntry.RemoveMethod myRemoveMethod;

    public ResponsibilityInfoData(User user, String userComment, ResponsibilityEntry.State state, Date lastChangeDate, User reporterUser, ResponsibilityEntry.RemoveMethod removeMethod) {
        this.myUser = user == null ? null : SimpleUserData.createSimpleUserDataOn(user);
        this.myUserComment = userComment;
        this.myReporterUser = reporterUser == null ? null : SimpleUserData.createSimpleUserDataOn(reporterUser);
        this.myState = state;
        this.myTimestamp = Dates.toStandardDate((Date)lastChangeDate);
        this.myRemoveMethod = removeMethod;
    }

    public ResponsibilityEntry.State getState() {
        return this.myState;
    }

    public User getResponsibleUser() {
        return this.myUser;
    }

    public String getComment() {
        return this.myUserComment;
    }

    public Date getTimestamp() {
        return this.myTimestamp;
    }

    public User getReporterUser() {
        return this.myReporterUser;
    }

    public ResponsibilityEntry.RemoveMethod getRemoveMethod() {
        return this.myRemoveMethod;
    }

    public static ResponsibilityInfoData createOn(@NotNull ResponsibilityEntry entry) {
        if (entry == null) {
            ResponsibilityInfoData.$$$reportNull$$$0(0);
        }
        return new ResponsibilityInfoData(Util.getUser(entry), entry.getComment(), entry.getState(), entry.getTimestamp(), entry.getReporterUser(), entry.getRemoveMethod());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "jetbrains/buildServer/serverSide/ResponsibilityInfoData", "createOn"));
    }
}

