/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import jetbrains.buildServer.serverSide.auth.Permission;
import jetbrains.buildServer.serverSide.auth.PermissionsPool;
import jetbrains.buildServer.util.ReadOnlyBitSet;
import org.jetbrains.annotations.NotNull;

public class Permissions {
    public static final Permissions NO_PERMISSIONS = PermissionsPool.getFromPool(new ReadOnlyBitSet());
    private final BitSet myMask;

    public Permissions(BitSet mask) {
        this.myMask = new ReadOnlyBitSet(mask);
    }

    public Permissions(Permission ... permissions) {
        if (permissions == null) {
            Permissions.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(permissions));
    }

    public Permissions(@NotNull Collection<Permission> permissions) {
        if (permissions == null) {
            Permissions.$$$reportNull$$$0(1);
        }
        BitSet mask = new BitSet(64);
        for (Permission p : permissions) {
            mask.set(p.getIndex());
        }
        this.myMask = new ReadOnlyBitSet(mask);
    }

    public boolean contains(@NotNull Permission permission) {
        if (permission == null) {
            Permissions.$$$reportNull$$$0(2);
        }
        return this.myMask.get(permission.getIndex());
    }

    public boolean containsAny(@NotNull Permissions permissions) {
        if (permissions == null) {
            Permissions.$$$reportNull$$$0(3);
        }
        return this.myMask.intersects(permissions.getMask());
    }

    public boolean containsAll(@NotNull Permissions permissions) {
        if (permissions == null) {
            Permissions.$$$reportNull$$$0(4);
        }
        BitSet result = new BitSet();
        result.or(this.myMask);
        result.and(permissions.getMask());
        return result.equals(permissions.getMask());
    }

    @NotNull
    public Permission[] toArray() {
        List<Permission> list = this.toList();
        Permission[] permissionArray = list.toArray(new Permission[list.size()]);
        if (permissionArray == null) {
            Permissions.$$$reportNull$$$0(5);
        }
        return permissionArray;
    }

    @NotNull
    public List<Permission> toList() {
        ArrayList<Permission> result = new ArrayList<Permission>(50);
        int i = this.myMask.nextSetBit(0);
        while (i >= 0) {
            Permission p = Permission.lookupPermission(i);
            result.add(p);
            i = this.myMask.nextSetBit(i + 1);
        }
        ArrayList<Permission> arrayList = result;
        if (arrayList == null) {
            Permissions.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public BitSet getMask() {
        BitSet bitSet = this.myMask;
        if (bitSet == null) {
            Permissions.$$$reportNull$$$0(7);
        }
        return bitSet;
    }

    @NotNull
    public Permissions mergeWith(@NotNull Permissions permissions) {
        if (permissions == null) {
            Permissions.$$$reportNull$$$0(8);
        }
        BitSet bitSet = new BitSet();
        bitSet.or(this.myMask);
        bitSet.or(permissions.getMask());
        Permissions permissions2 = new Permissions(bitSet);
        if (permissions2 == null) {
            Permissions.$$$reportNull$$$0(9);
        }
        return permissions2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permissions that = (Permissions)o;
        return this.myMask.equals(that.myMask);
    }

    public int hashCode() {
        return this.myMask.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Permission p : this.toList()) {
            builder.append(p.name()).append(";");
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permissions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permission";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/auth/Permissions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/auth/Permissions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMask";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsAny";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

