/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.tracker;

import java.util.HashMap;
import java.util.Map;

public enum TrackerEventType {
    BUILD_STARTED('a', true),
    BUILD_CHANGES_LOADED('b', true),
    BUILD_FINISHED('c', true),
    BUILD_CHANGED_STATUS('d', true),
    BUILD_PROBLEM_CHANGED('P', true),
    BUILD_INTERRUPTED('e', true),
    BUILD_REMOVED('f', true),
    BUILD_TAGS_CHANGED('N', true),
    PERSONAL_BUILD_STARTED('g', true),
    PERSONAL_BUILD_FINISHED('h', true),
    PERSONAL_BUILD_CHANGED_STATUS('i', true),
    PERSONAL_BUILD_INTERRUPTED('j', true),
    PERSONAL_BUILD_ADDED_TO_QUEUE('k', true),
    PROJECT_RESTORED('l', true),
    PROJECT_PERSISTED('m', true),
    PROJECT_REMOVED('n', true),
    PROJECT_CREATED('o', true),
    PROJECT_ARCHIVED('p', true),
    PROJECT_DEARCHIVED('q', true),
    BUILD_TYPE_REGISTERED('r', true),
    BUILD_TYPE_UNREGISTERED('s', true),
    BUILD_TYPE_ADDED_TO_QUEUE('t', true),
    BUILD_TYPE_REMOVED_FROM_QUEUE('u', true),
    BUILD_TYPE_ACTIVE_STATUS_CHANGED('v', true),
    BUILD_TYPE_RESPONSIBILITY_CHANGES('w', true),
    BUILD_TYPE_PERSISTED('L', true),
    BUILD_TYPE_TEMPLATE_PERSISTED('M', true),
    BUILD_TYPE_BRANCHES_CHANGED('X', true),
    CHANGE_ADDED('x', true),
    BUILD_QUEUE_ORDER_CHANGED('y'),
    AGENT_REGISTERED('z'),
    AGENT_UNREGISTERED('A'),
    AGENT_REMOVED('B'),
    AGENT_STATUS_CHANGED('C'),
    USER_ACCOUNT_CREATED('D'),
    USER_ACCOUNT_REMOVED('E'),
    USER_ACCOUNT_CHANGED('F'),
    USER_PERMISSIONS_CHANGED('O'),
    NOTIFICATION_RULES_CHANGED('G'),
    SERVER_SHUTDOWN('H'),
    TEST_RESPONSIBILITY_CHANGED('I', true),
    BUILD_PROBLEM_RESPONSIBILITY_CHANGED('S', true),
    AGENT_PARAMETERS_UPDATED('J'),
    TEST_MUTE_UPDATED('K', true),
    BUILD_PROBLEM_MUTE_UPDATED('R', true),
    AGENT_POOLS_UPDATED('T', false);

    private final boolean myProjectRelated;
    private final char myId;
    private static final Map<Character, TrackerEventType> myShortCodesMap;

    private TrackerEventType(char shortCode) {
        this.myId = shortCode;
        this.myProjectRelated = false;
    }

    private TrackerEventType(char shortCode, boolean projectRelated) {
        this.myId = shortCode;
        this.myProjectRelated = projectRelated;
    }

    public boolean isProjectRelated() {
        return this.myProjectRelated;
    }

    public char getShortCode() {
        return this.myId;
    }

    public static TrackerEventType findByCode(char code) {
        return myShortCodesMap.get(Character.valueOf(code));
    }

    static {
        myShortCodesMap = new HashMap<Character, TrackerEventType>();
        for (TrackerEventType tet : TrackerEventType.values()) {
            myShortCodesMap.put(Character.valueOf(tet.getShortCode()), tet);
        }
    }
}

