/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.userChanges;

import org.jetbrains.annotations.Nullable;

public class CanceledInfo {
    @Nullable
    private final Long myUserId;
    @Nullable
    private final String myComment;
    private final long myCreatedAt;

    private CanceledInfo(@Nullable Long userId, @Nullable String comment) {
        this.myUserId = userId;
        this.myComment = comment;
        this.myCreatedAt = System.currentTimeMillis();
    }

    public CanceledInfo(long userId, @Nullable String comment) {
        this((Long)userId, comment);
    }

    public CanceledInfo(@Nullable String comment) {
        this(null, comment);
    }

    @Nullable
    public String getComment() {
        return this.myComment;
    }

    @Nullable
    public Long getUserId() {
        return this.myUserId;
    }

    public boolean isCanceledByUser() {
        return this.myUserId != null;
    }

    public long getCreatedAt() {
        return this.myCreatedAt;
    }

    public boolean isOutdated() {
        return System.currentTimeMillis() - this.myCreatedAt > 300000L;
    }

    public String toString() {
        return "[comment: " + this.myComment + (this.myUserId != null ? ", userId:" + this.myUserId : "") + "]";
    }
}

