/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.tests;

import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.tests.TestName;
import jetbrains.buildServer.tests.TestStartInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestInfo {
    private final String myName;
    private final String myStdOutput;
    private final String myErrOutput;
    private String myStacktrace;
    private String myStacktraceMessage;
    private String myExpected;
    private String myActual;
    private Status myStatus;
    private final int mySequenceNumber;
    private final boolean myIsFinished;
    private final TestStartInfo myTestStartInfo;

    public TestInfo(@NotNull String name, @Nullable String stdOutput, @Nullable String errOutput, @Nullable String stacktrace, @Nullable String expected, @Nullable String actual, @NotNull Status status, int sequenceNumber, boolean finished, @Nullable String stacktraceMessage, @Nullable String locationHint) {
        if (name == null) {
            TestInfo.$$$reportNull$$$0(0);
        }
        if (status == null) {
            TestInfo.$$$reportNull$$$0(1);
        }
        this(name, stdOutput, errOutput, stacktrace, expected, actual, status, sequenceNumber, finished, stacktraceMessage, new TestStartInfo(true, null, locationHint));
    }

    public TestInfo(@NotNull String name, @Nullable String stdOutput, @Nullable String errOutput, @Nullable String stacktrace, @Nullable String expected, @Nullable String actual, @NotNull Status status, int sequenceNumber, boolean finished, @Nullable String stacktraceMessage, @Nullable TestStartInfo testStartInfo) {
        if (name == null) {
            TestInfo.$$$reportNull$$$0(2);
        }
        if (status == null) {
            TestInfo.$$$reportNull$$$0(3);
        }
        this.myStatus = Status.NORMAL;
        this.myName = name;
        this.myStdOutput = stdOutput;
        this.myErrOutput = errOutput;
        this.myStacktrace = stacktrace;
        this.myStacktraceMessage = stacktraceMessage;
        this.myExpected = expected;
        this.myActual = actual;
        this.myStatus = status;
        this.mySequenceNumber = sequenceNumber;
        this.myIsFinished = finished;
        this.myTestStartInfo = testStartInfo;
    }

    public boolean isCaptureStandardOutput() {
        return this.myTestStartInfo.isCaptureStandardOutput();
    }

    public Long getStartTimestamp() {
        return this.myTestStartInfo.getStartTimestamp();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            TestInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    public TestName getTestName() {
        return new TestName(this.myName);
    }

    public String getStdOutput() {
        return this.myStdOutput;
    }

    public String getErrOutput() {
        return this.myErrOutput;
    }

    public String getStacktrace() {
        return this.myStacktrace;
    }

    public String getExpected() {
        return this.myExpected;
    }

    public String getActual() {
        return this.myActual;
    }

    @NotNull
    public Status getStatus() {
        Status status = this.myStatus;
        if (status == null) {
            TestInfo.$$$reportNull$$$0(5);
        }
        return status;
    }

    public int getSequenceNumber() {
        return this.mySequenceNumber;
    }

    public boolean isFinished() {
        return this.myIsFinished;
    }

    public String getStacktraceMessage() {
        return this.myStacktraceMessage;
    }

    public void updateFailureData(String stackTrace, String stacktraceMessage, String expected, String actual) {
        this.myStacktrace = stackTrace;
        this.myStacktraceMessage = stacktraceMessage;
        this.myExpected = expected;
        this.myActual = actual;
    }

    public String toString() {
        return this.myName;
    }

    public String getLocationHint() {
        return this.myTestStartInfo.getLocationHint();
    }

    public void setStatus(Status status) {
        this.myStatus = status;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/tests/TestInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/tests/TestInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

