/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.tests;

import com.intellij.openapi.util.Comparing;
import java.util.Arrays;
import jetbrains.buildServer.serverSide.TestGroupName;
import jetbrains.buildServer.tests.TestNameParser;
import jetbrains.buildServer.util.StringPoolInstance;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TestName
implements Comparable<TestName> {
    private static final StringPoolInstance ourPool = new StringPoolInstance(3000);
    @NonNls
    public static final String SUITE_SEPARATOR = ": ";
    static final int PACKAGE_REF = 0;
    static final int CLASS_REF = 1;
    static final int TEST_METHOD_REF = 2;
    static final int PARAMS_REF = 3;
    private final String[] myTestParts;
    private final String mySuite;

    public TestName(@NotNull String testName) {
        if (testName == null) {
            TestName.$$$reportNull$$$0(0);
        }
        this(testName, ourPool);
    }

    public TestName(@NotNull String testName, @NotNull StringPoolInstance stringPool) {
        if (testName == null) {
            TestName.$$$reportNull$$$0(1);
        }
        if (stringPool == null) {
            TestName.$$$reportNull$$$0(2);
        }
        int suiteIdx = TestName.findSuiteEnd(testName);
        String finalTestName = testName;
        if (suiteIdx > 0) {
            finalTestName = testName.substring(suiteIdx);
            this.mySuite = stringPool.getFromPool(testName.substring(0, suiteIdx));
        } else {
            this.mySuite = "";
        }
        String[] parsed = new TestNameParser(finalTestName).doParse();
        if (parsed != null) {
            this.myTestParts = new String[parsed.length];
            for (int i = 0; i < parsed.length; ++i) {
                this.myTestParts[i] = stringPool.getFromPool(parsed[i]);
            }
        } else {
            this.myTestParts = new String[]{stringPool.getFromPool(finalTestName)};
        }
    }

    @NotNull
    public TestGroupName getGroupName() {
        TestGroupName testGroupName = new TestGroupName(this.getSuite(), this.getPackageName(), this.getClassName());
        if (testGroupName == null) {
            TestName.$$$reportNull$$$0(3);
        }
        return testGroupName;
    }

    public boolean isJavaLikeTestName() {
        return this.myTestParts.length > 1;
    }

    public String getTestClass() {
        if (!this.isJavaLikeTestName()) {
            return "";
        }
        return this.hasPackage() ? this.getPackageName() + "." + this.getClassName() : this.getClassName();
    }

    @NotNull
    public String getShortName() {
        if (!this.isJavaLikeTestName()) {
            String string = this.getTestNameWithoutPrefix();
            if (string == null) {
                TestName.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder result = new StringBuilder();
        String classNameUnparsed = this.getClassNameUnparsed();
        result.append(classNameUnparsed).append(this.getTestMethodName());
        String paramsUnparsed = this.getParametersUnparsed();
        if (paramsUnparsed.length() > 2) {
            result.append(paramsUnparsed);
        }
        String string = result.toString();
        if (string == null) {
            TestName.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getPrefixWithSeparator() {
        String string = this.mySuite + this.getPackageName();
        if (string == null) {
            TestName.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getPrefix() {
        String prefix = this.getPrefixWithSeparator();
        String string = prefix.endsWith(SUITE_SEPARATOR) ? prefix.substring(0, prefix.length() - SUITE_SEPARATOR.length()) : prefix;
        if (string == null) {
            TestName.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getSuite() {
        String string = this.mySuite;
        if (string == null) {
            TestName.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getPackageName() {
        String string = this.parsedPart(0);
        if (string == null) {
            TestName.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private String getPackageNameUnparsed() {
        String string = this.unparsedPart(0);
        if (string == null) {
            TestName.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean hasPackage() {
        return this.myTestParts[0] != null;
    }

    @NotNull
    public String getClassName() {
        String string = this.parsedPart(1);
        if (string == null) {
            TestName.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private String getClassNameUnparsed() {
        String string = this.unparsedPart(1);
        if (string == null) {
            TestName.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getTestMethodName() {
        String string = this.parsedPart(2);
        if (string == null) {
            TestName.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private String getTestMethodNameUnparsed() {
        String string = this.unparsedPart(2);
        if (string == null) {
            TestName.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getParameters() {
        String string = this.parsedPart(3);
        if (string == null) {
            TestName.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private String getParametersUnparsed() {
        String string = this.unparsedPart(3);
        if (string == null) {
            TestName.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getNameWithoutParameters() {
        if (this.isJavaLikeTestName()) {
            StringBuilder result = new StringBuilder();
            this.appendPackage(result);
            this.appendClassName(result);
            this.appendTestMethodName(result);
            String string = result.toString();
            if (string == null) {
                TestName.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = this.getUnparsedTestName();
        if (string == null) {
            TestName.$$$reportNull$$$0(18);
        }
        return string;
    }

    public boolean equalsByNameWithoutParameters(@NotNull TestName that) {
        boolean thisIsJavaLikeTestName;
        if (that == null) {
            TestName.$$$reportNull$$$0(19);
        }
        if ((thisIsJavaLikeTestName = this.isJavaLikeTestName()) != that.isJavaLikeTestName()) {
            return false;
        }
        if (!thisIsJavaLikeTestName) {
            return this.getUnparsedTestName().equals(that.getUnparsedTestName());
        }
        return Comparing.equal((String)this.myTestParts[0], (String)that.myTestParts[0]) && Comparing.equal((String)this.myTestParts[1], (String)that.myTestParts[1]) && Comparing.equal((String)this.myTestParts[2], (String)that.myTestParts[2]);
    }

    @NotNull
    public String getNameWithoutSuite() {
        if (this.isJavaLikeTestName()) {
            StringBuilder result = new StringBuilder();
            this.appendPackage(result);
            this.appendClassName(result);
            this.appendTestMethodName(result);
            this.appendParameters(result);
            String string = result.toString();
            if (string == null) {
                TestName.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = this.getUnparsedTestName();
        if (string == null) {
            TestName.$$$reportNull$$$0(21);
        }
        return string;
    }

    public String getTestNameWithParameters() {
        if (this.isJavaLikeTestName()) {
            StringBuilder result = new StringBuilder();
            this.appendTestMethodName(result);
            this.appendParameters(result);
            return result.toString();
        }
        return this.getTestNameWithoutPrefix();
    }

    @NotNull
    public String getAsString() {
        String testName;
        if (this.isJavaLikeTestName()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getNameWithoutParameters());
            this.appendParameters(sb);
            testName = sb.toString();
        } else {
            testName = this.getUnparsedTestName();
        }
        String string = this.mySuite + testName;
        if (string == null) {
            TestName.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getTestNameWithoutPrefix() {
        String prefix = this.getPrefixWithSeparator();
        String fullName = this.getAsString();
        String string = fullName.substring(prefix.length());
        if (string == null) {
            TestName.$$$reportNull$$$0(23);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestName name = (TestName)o;
        return (this.mySuite == null ? name.mySuite == null : this.mySuite.equals(name.mySuite)) && Arrays.equals(this.myTestParts, name.myTestParts);
    }

    public int hashCode() {
        int result = this.myTestParts != null ? Arrays.hashCode(this.myTestParts) : 0;
        result = 31 * result + (this.mySuite != null ? this.mySuite.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(TestName n2) {
        int res = this.getSuite().compareTo(n2.getSuite());
        if (res != 0) {
            return res;
        }
        res = this.getPackageName().compareTo(n2.getPackageName());
        if (res != 0) {
            return res;
        }
        res = this.getClassName().compareTo(n2.getClassName());
        if (res != 0) {
            return res;
        }
        res = this.getTestMethodName().compareTo(n2.getTestMethodName());
        if (res != 0) {
            return res;
        }
        res = this.getParameters().compareTo(n2.getParameters());
        if (res != 0) {
            return res;
        }
        return this.getAsString().compareTo(n2.getAsString());
    }

    public String toString() {
        return this.getAsString();
    }

    private static int findSuiteEnd(String testName) {
        int pos = 0;
        int idx;
        while ((idx = testName.indexOf(SUITE_SEPARATOR, pos)) >= 0) {
            String suitePart = testName.substring(pos, idx);
            if (!TestName.isGoodSuiteName(suitePart)) {
                return pos;
            }
            pos = idx + SUITE_SEPARATOR.length();
        }
        return pos;
    }

    private static boolean isGoodSuiteName(String suitePart) {
        if (suitePart.length() == 0) {
            return true;
        }
        int counter = 0;
        block4: for (int i = 0; i < suitePart.length(); ++i) {
            char c = suitePart.charAt(i);
            switch (c) {
                case '(': 
                case '[': 
                case '{': {
                    ++counter;
                    continue block4;
                }
                case ')': 
                case ']': 
                case '}': {
                    --counter;
                }
            }
        }
        return counter == 0;
    }

    private void appendParameters(StringBuilder result) {
        String params = this.getParameters();
        if (params.length() > 0) {
            result.append(this.getParametersUnparsed());
        }
    }

    private void appendTestMethodName(StringBuilder result) {
        result.append(this.getTestMethodNameUnparsed());
    }

    private void appendClassName(StringBuilder result) {
        if (this.myTestParts[1] != null) {
            result.append(this.getClassNameUnparsed());
        }
    }

    private void appendPackage(StringBuilder result) {
        if (this.hasPackage()) {
            result.append(this.getPackageNameUnparsed());
        }
    }

    private int unparsedTestRef() {
        return this.myTestParts.length - 1;
    }

    private String parsedPart(int idx) {
        String part = this.unparsedPart(idx);
        int partLength = part.length();
        if (partLength == 0) {
            return "";
        }
        if (idx == 3) {
            if (!(part.charAt(0) != '[' && part.charAt(0) != '(' || part.charAt(partLength - 1) != ']' && part.charAt(partLength - 1) != ')')) {
                return part.substring(1, partLength - 1);
            }
            return part;
        }
        char lastChar = part.charAt(partLength - 1);
        if (lastChar == ':' || lastChar == '.') {
            if (partLength > 1 && part.charAt(partLength - 2) == ':') {
                return part.substring(0, partLength - 2);
            }
            return part.substring(0, partLength - 1);
        }
        return part;
    }

    private String unparsedPart(int idx) {
        if (!this.isJavaLikeTestName()) {
            return "";
        }
        if (idx >= this.myTestParts.length) {
            return "";
        }
        String part = this.myTestParts[idx];
        if (part == null) {
            return "";
        }
        return part;
    }

    private String getUnparsedTestName() {
        return this.myTestParts[this.unparsedTestRef()];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringPool";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/tests/TestName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/tests/TestName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixWithSeparator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuite";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNameUnparsed";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNameUnparsed";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethodName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethodNameUnparsed";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersUnparsed";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutParameters";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutSuite";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsString";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNameWithoutPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "equalsByNameWithoutParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

