/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.users;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.serverSide.auth.AuthorityHolder;
import jetbrains.buildServer.serverSide.auth.Permission;
import jetbrains.buildServer.serverSide.auth.Permissions;
import jetbrains.buildServer.serverSide.auth.PermissionsHolder;
import jetbrains.buildServer.users.SimpleUserData;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.util.Dates;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserData
extends SimpleUserData
implements AuthorityHolder {
    private final String myRealm;
    private final Date myLastLoginTimestamp;
    private Permissions myGlobalPermissions;
    private Map<String, Permissions> myProjectsPermissions;
    private PermissionsHolder myPermissionsHolder;

    public UserData(long id, String realm, String username, String name, Date lastLoginTimestamp) {
        super(id, username, name);
        this.myRealm = realm;
        this.myLastLoginTimestamp = lastLoginTimestamp == null ? null : Dates.toStandardDate((Date)lastLoginTimestamp);
    }

    public void setPermissions(@NotNull PermissionsHolder permissionsHolder) {
        if (permissionsHolder == null) {
            UserData.$$$reportNull$$$0(0);
        }
        this.myGlobalPermissions = new Permissions(permissionsHolder.getGlobalPermissions().getMask());
        this.myProjectsPermissions = new HashMap<String, Permissions>(permissionsHolder.getProjectsPermissions());
        this.myPermissionsHolder = null;
    }

    @Override
    public String getRealm() {
        return this.myRealm;
    }

    @Override
    public Date getLastLoginTimestamp() {
        return this.myLastLoginTimestamp;
    }

    @NotNull
    public static UserData createOn(@NotNull User user) {
        if (user == null) {
            UserData.$$$reportNull$$$0(1);
        }
        UserData userData = new UserData(user.getId(), user.getRealm(), user.getUsername(), user.getName(), user.getLastLoginTimestamp());
        if (userData == null) {
            UserData.$$$reportNull$$$0(2);
        }
        return userData;
    }

    @Override
    public boolean isPermissionGrantedGlobally(@NotNull Permission permission) {
        if (permission == null) {
            UserData.$$$reportNull$$$0(3);
        }
        return this.getPermissionsHolder().isPermissionGrantedGlobally(permission);
    }

    @Override
    @NotNull
    public Permissions getGlobalPermissions() {
        Permissions permissions = this.getPermissionsHolder().getGlobalPermissions();
        if (permissions == null) {
            UserData.$$$reportNull$$$0(4);
        }
        return permissions;
    }

    @Override
    @NotNull
    public Map<String, Permissions> getProjectsPermissions() {
        Map<String, Permissions> map = this.getPermissionsHolder().getProjectsPermissions();
        if (map == null) {
            UserData.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Override
    public boolean isPermissionGrantedForProject(@NotNull String projectId, @NotNull Permission permission) {
        if (projectId == null) {
            UserData.$$$reportNull$$$0(6);
        }
        if (permission == null) {
            UserData.$$$reportNull$$$0(7);
        }
        return this.getPermissionsHolder().isPermissionGrantedForProject(projectId, permission);
    }

    @Override
    public boolean isPermissionGrantedForAllProjects(@NotNull Collection<String> projectIds, @NotNull Permission permission) {
        if (projectIds == null) {
            UserData.$$$reportNull$$$0(8);
        }
        if (permission == null) {
            UserData.$$$reportNull$$$0(9);
        }
        return this.getPermissionsHolder().isPermissionGrantedForAllProjects(projectIds, permission);
    }

    @Override
    public boolean isPermissionGrantedForAnyProject(@NotNull Permission permission) {
        if (permission == null) {
            UserData.$$$reportNull$$$0(10);
        }
        return this.getPermissionsHolder().isPermissionGrantedForAnyProject(permission);
    }

    @Override
    public boolean isPermissionGrantedForAnyOfProjects(@NotNull Collection<String> projectIds, @NotNull Permission permission) {
        if (projectIds == null) {
            UserData.$$$reportNull$$$0(11);
        }
        if (permission == null) {
            UserData.$$$reportNull$$$0(12);
        }
        return this.getPermissionsHolder().isPermissionGrantedForAnyOfProjects(projectIds, permission);
    }

    @Override
    @NotNull
    public Permissions getPermissionsGrantedForProject(@NotNull String projectId) {
        if (projectId == null) {
            UserData.$$$reportNull$$$0(13);
        }
        Permissions permissions = this.getPermissionsHolder().getPermissionsGrantedForProject(projectId);
        if (permissions == null) {
            UserData.$$$reportNull$$$0(14);
        }
        return permissions;
    }

    @Override
    @NotNull
    public Permissions getPermissionsGrantedForAllProjects(@NotNull Collection<String> projectIds) {
        if (projectIds == null) {
            UserData.$$$reportNull$$$0(15);
        }
        Permissions permissions = this.getPermissionsHolder().getPermissionsGrantedForAllProjects(projectIds);
        if (permissions == null) {
            UserData.$$$reportNull$$$0(16);
        }
        return permissions;
    }

    @Override
    @NotNull
    public Permissions getPermissionsGrantedForAnyOfProjects(@NotNull Collection<String> projectIds) {
        if (projectIds == null) {
            UserData.$$$reportNull$$$0(17);
        }
        Permissions permissions = this.getPermissionsHolder().getPermissionsGrantedForAnyOfProjects(projectIds);
        if (permissions == null) {
            UserData.$$$reportNull$$$0(18);
        }
        return permissions;
    }

    @Override
    @Nullable
    public User getAssociatedUser() {
        return this;
    }

    private PermissionsHolder getPermissionsHolder() {
        if (this.myPermissionsHolder == null) {
            this.myPermissionsHolder = new PermissionsHolder();
            this.myPermissionsHolder.setPermissions(this.myGlobalPermissions, this.myProjectsPermissions);
        }
        return this.myPermissionsHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permissionsHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/users/UserData";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permission";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/users/UserData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createOn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalPermissions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsPermissions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermissionsGrantedForProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermissionsGrantedForAllProjects";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermissionsGrantedForAnyOfProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPermissions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createOn";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPermissionGrantedGlobally";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPermissionGrantedForProject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPermissionGrantedForAllProjects";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPermissionGrantedForAnyProject";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPermissionGrantedForAnyOfProjects";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPermissionsGrantedForProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPermissionsGrantedForAllProjects";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPermissionsGrantedForAnyOfProjects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

