/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.browser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import jetbrains.buildServer.util.browser.Behaviour;
import jetbrains.buildServer.util.browser.Browser;
import jetbrains.buildServer.util.browser.BrowserException;
import jetbrains.buildServer.util.browser.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserWithNewRoot
implements Browser {
    private final Browser myDelegate;
    private final String myRootName;

    public BrowserWithNewRoot(@NotNull String rootName, @NotNull Browser delegate) {
        if (rootName == null) {
            BrowserWithNewRoot.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            BrowserWithNewRoot.$$$reportNull$$$0(1);
        }
        this.myRootName = rootName;
        this.myDelegate = delegate;
    }

    @Override
    @NotNull
    public Element getRoot() throws BrowserException {
        RootElement rootElement = new RootElement();
        if (rootElement == null) {
            BrowserWithNewRoot.$$$reportNull$$$0(2);
        }
        return rootElement;
    }

    @Override
    @Nullable
    public Element getElement(@NotNull String path) throws BrowserException {
        if (path == null) {
            BrowserWithNewRoot.$$$reportNull$$$0(3);
        }
        if (path.startsWith(this.myRootName)) {
            String subPath = path.substring(this.myRootName.length());
            if (subPath.startsWith("/")) {
                subPath = subPath.substring(1);
            }
            return this.myDelegate.getElement(subPath);
        }
        return this.myDelegate.getElement(path);
    }

    @Override
    @NotNull
    public Behaviour getBehaviour() {
        Behaviour behaviour = this.myDelegate.getBehaviour();
        if (behaviour == null) {
            BrowserWithNewRoot.$$$reportNull$$$0(4);
        }
        return behaviour;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/browser/BrowserWithNewRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/browser/BrowserWithNewRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBehaviour";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PrefixedElement
    implements Element {
        private final Element myDelegate;
        private final String myPrefix;
        private final String myName;

        private PrefixedElement(@NotNull String prefix, @NotNull String elemName, Element delegate) {
            if (prefix == null) {
                PrefixedElement.$$$reportNull$$$0(0);
            }
            if (elemName == null) {
                PrefixedElement.$$$reportNull$$$0(1);
            }
            if (delegate == null) {
                PrefixedElement.$$$reportNull$$$0(2);
            }
            this.myPrefix = prefix;
            this.myDelegate = delegate;
            this.myName = elemName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                PrefixedElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFullName() {
            String path = this.myDelegate.getFullName();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!(path = this.myPrefix + path).startsWith("/")) {
                path = "/" + path;
            }
            String string = path;
            if (string == null) {
                PrefixedElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public boolean isLeaf() {
            return this.myDelegate.isLeaf();
        }

        @Override
        @Nullable
        public Iterable<Element> getChildren() throws BrowserException {
            Iterable<Element> children = this.myDelegate.getChildren();
            if (children == null) {
                return null;
            }
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element e : children) {
                elements.add(new PrefixedElement(this.myPrefix, e.getName(), e));
            }
            return elements;
        }

        @Override
        public boolean isContentAvailable() {
            return this.myDelegate.isContentAvailable();
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IllegalStateException, IOException, BrowserException {
            InputStream inputStream = this.myDelegate.getInputStream();
            if (inputStream == null) {
                PrefixedElement.$$$reportNull$$$0(5);
            }
            return inputStream;
        }

        @Override
        public long getSize() throws IllegalStateException {
            return this.myDelegate.getSize();
        }

        @Override
        @NotNull
        public Browser getBrowser() {
            Browser browser = BrowserWithNewRoot.this.myDelegate;
            if (browser == null) {
                PrefixedElement.$$$reportNull$$$0(6);
            }
            return browser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrefixedElement that = (PrefixedElement)o;
            return this.myDelegate.equals(that.myDelegate);
        }

        public int hashCode() {
            return this.myDelegate.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elemName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/browser/BrowserWithNewRoot$PrefixedElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/browser/BrowserWithNewRoot$PrefixedElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class RootElement
    implements Element {
        private RootElement() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("" == null) {
                RootElement.$$$reportNull$$$0(0);
            }
            return "";
        }

        @Override
        @NotNull
        public String getFullName() {
            if ("/" == null) {
                RootElement.$$$reportNull$$$0(1);
            }
            return "/";
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        @Nullable
        public Iterable<Element> getChildren() throws BrowserException {
            return Collections.singleton(new PrefixedElement(BrowserWithNewRoot.this.myRootName, BrowserWithNewRoot.this.myRootName, BrowserWithNewRoot.this.myDelegate.getRoot()));
        }

        @Override
        public boolean isContentAvailable() {
            return false;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IllegalStateException, IOException, BrowserException {
            throw new IllegalStateException();
        }

        @Override
        public long getSize() throws IllegalStateException {
            return 0L;
        }

        @Override
        @NotNull
        public Browser getBrowser() {
            BrowserWithNewRoot browserWithNewRoot = BrowserWithNewRoot.this;
            if (browserWithNewRoot == null) {
                RootElement.$$$reportNull$$$0(2);
            }
            return browserWithNewRoot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element that = (Element)o;
            return this.getFullName().equals(that.getFullName());
        }

        public int hashCode() {
            return this.getFullName().hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "jetbrains/buildServer/util/browser/BrowserWithNewRoot$RootElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBrowser";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

