/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.browser;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import jetbrains.buildServer.util.ArchiveType;
import jetbrains.buildServer.util.ArchiveUtil;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.browser.Behaviour;
import jetbrains.buildServer.util.browser.Browser;
import jetbrains.buildServer.util.browser.BrowserException;
import jetbrains.buildServer.util.browser.Element;
import jetbrains.buildServer.util.browser.ZipElement;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipAwareBrowser
implements Browser {
    private final Browser myDelegateBrowser;
    private final Element myRoot;
    public static final Behaviour BEHAVIOUR = new Behaviour(){

        @Override
        public boolean isOpenWhenOnlyChild(@NotNull Element element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            boolean isArchive = element instanceof ZipElement && ((ZipElement)element).isArchive();
            return !isArchive && !element.isLeaf();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/browser/ZipAwareBrowser$1", "isOpenWhenOnlyChild"));
        }
    };

    public ZipAwareBrowser(@NotNull Browser browser) {
        if (browser == null) {
            ZipAwareBrowser.$$$reportNull$$$0(0);
        }
        this(browser, true);
    }

    public ZipAwareBrowser(@NotNull Browser browser, boolean expandNestedArchives) {
        if (browser == null) {
            ZipAwareBrowser.$$$reportNull$$$0(1);
        }
        this.myDelegateBrowser = browser;
        this.myRoot = new ZipAwareElement(this, browser.getRoot(), expandNestedArchives);
    }

    @Override
    @NotNull
    public Element getRoot() {
        Element element = this.myRoot;
        if (element == null) {
            ZipAwareBrowser.$$$reportNull$$$0(2);
        }
        return element;
    }

    @Override
    @Nullable
    public Element getElement(@NotNull String path) throws BrowserException {
        int archiveMark;
        if (path == null) {
            ZipAwareBrowser.$$$reportNull$$$0(3);
        }
        if ((archiveMark = path.indexOf("!/")) != -1) {
            throw new UnsupportedOperationException();
        }
        Element element = this.myDelegateBrowser.getElement(path);
        return element == null ? null : new ZipAwareElement(this, element, false);
    }

    @Override
    @NotNull
    public Behaviour getBehaviour() {
        Behaviour behaviour = BEHAVIOUR;
        if (behaviour == null) {
            ZipAwareBrowser.$$$reportNull$$$0(4);
        }
        return behaviour;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/browser/ZipAwareBrowser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/browser/ZipAwareBrowser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBehaviour";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ZipAwareElement
    implements ZipElement {
        @NotNull
        private final Element myElement;
        private final boolean myExpandNestedArchives;
        private final Browser myBrowser;

        public ZipAwareElement(@NotNull Browser browser, @NotNull Element element, boolean expandSubArchives) {
            if (browser == null) {
                ZipAwareElement.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ZipAwareElement.$$$reportNull$$$0(1);
            }
            this.myBrowser = browser;
            this.myElement = element;
            this.myExpandNestedArchives = expandSubArchives;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myElement.getName();
            if (string == null) {
                ZipAwareElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFullName() {
            String string = this.myElement.getFullName();
            if (string == null) {
                ZipAwareElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean isLeaf() {
            if (!this.myElement.isLeaf()) {
                return false;
            }
            return !this.isArchive();
        }

        @Override
        public Iterable<Element> getChildren() throws BrowserException {
            if (this.isArchive()) {
                try {
                    return this.readZipChildren("");
                }
                catch (Exception e) {
                    throw new BrowserException(e.getMessage(), e);
                }
            }
            if (!this.myElement.isLeaf()) {
                return CollectionsUtil.convertCollection(this.myElement.getChildren(), (Converter)new Converter<Element, Element>(){

                    public Element createFrom(@NotNull Element source) {
                        if (source == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return new ZipAwareElement(myBrowser, source, myExpandNestedArchives);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/util/browser/ZipAwareBrowser$ZipAwareElement$1", "createFrom"));
                    }
                });
            }
            return null;
        }

        @Override
        public boolean isContentAvailable() {
            return this.myElement.isContentAvailable();
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IllegalStateException, IOException {
            InputStream inputStream = this.myElement.getInputStream();
            if (inputStream == null) {
                ZipAwareElement.$$$reportNull$$$0(4);
            }
            return inputStream;
        }

        @Override
        public long getSize() throws IllegalStateException {
            return this.myElement.getSize();
        }

        @Override
        @NotNull
        public Browser getBrowser() {
            Browser browser = this.myBrowser;
            if (browser == null) {
                ZipAwareElement.$$$reportNull$$$0(5);
            }
            return browser;
        }

        @Override
        public boolean isArchive() {
            return this.isContentAvailable() && this.getArchiveType() != ArchiveType.NOT_ARCHIVE;
        }

        @Override
        public boolean isInsideArchive() {
            return this.myElement instanceof ZipElement && ((ZipElement)this.myElement).isInsideArchive();
        }

        @NotNull
        private ArchiveType getArchiveType() {
            ArchiveType archiveType = ArchiveUtil.getArchiveType((String)this.getName());
            if (archiveType == null) {
                ZipAwareElement.$$$reportNull$$$0(6);
            }
            return archiveType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private Iterable<Element> readZipChildren(final @NotNull String prefix) throws IOException {
            if (prefix == null) {
                ZipAwareElement.$$$reportNull$$$0(7);
            }
            ArchiveInputStream stream = this.openArchiveStream();
            HashMap<String, ArchiveEntryData> children = new HashMap<String, ArchiveEntryData>();
            boolean[] temp = new boolean[1];
            try {
                ArchiveEntry entry = stream.getNextEntry();
                while (entry != null) {
                    String childName;
                    String name = entry.getName().replace('\\', '/');
                    if (name.startsWith(prefix) && (childName = this.extractChild(name, prefix, temp)).length() > 0) {
                        boolean isLeaf = temp[0] && !entry.isDirectory();
                        long size = isLeaf ? entry.getSize() : -42L;
                        children.put(childName, new ArchiveEntryData(name, childName, isLeaf, size));
                    }
                    entry = stream.getNextEntry();
                }
            }
            finally {
                stream.close();
            }
            ArrayList entries = new ArrayList(children.values());
            Collections.sort(entries, new Comparator<ArchiveEntryData>(){

                @Override
                public int compare(ArchiveEntryData leftEntry, ArchiveEntryData rightEntry) {
                    boolean rightIsDirectory;
                    boolean leftIsDirectory = !leftEntry.isLeaf();
                    boolean bl = rightIsDirectory = !rightEntry.isLeaf();
                    if (leftIsDirectory && !rightIsDirectory) {
                        return -1;
                    }
                    if (!leftIsDirectory && rightIsDirectory) {
                        return 1;
                    }
                    return leftEntry.getChildName().compareToIgnoreCase(rightEntry.getChildName());
                }
            });
            List list = CollectionsUtil.convertCollection(entries, (Converter)new Converter<Element, ArchiveEntryData>(){

                public Element createFrom(final @NotNull ArchiveEntryData entry) {
                    if (entry == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ZipElement insideZipElement = new ZipElement(){

                        @Override
                        @NotNull
                        public String getName() {
                            String string = entry.getChildName();
                            if (string == null) {
                                ZipAwareElement.1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        @Override
                        @NotNull
                        public String getFullName() {
                            String string = myElement.getFullName() + "!/" + prefix + this.getName();
                            if (string == null) {
                                ZipAwareElement.1.$$$reportNull$$$0(1);
                            }
                            return string;
                        }

                        @Override
                        public boolean isLeaf() {
                            return entry.isLeaf();
                        }

                        @Override
                        @Nullable
                        public Iterable<Element> getChildren() throws BrowserException {
                            if (this.isLeaf()) {
                                return null;
                            }
                            try {
                                return this.readZipChildren(prefix + this.getName() + "/");
                            }
                            catch (IOException e) {
                                throw new BrowserException(e.getMessage(), e);
                            }
                        }

                        @Override
                        public boolean isContentAvailable() {
                            return this.isLeaf();
                        }

                        @Override
                        public long getSize() throws IllegalStateException {
                            return entry.getSize();
                        }

                        @Override
                        @NotNull
                        public Browser getBrowser() {
                            Browser browser = myBrowser;
                            if (browser == null) {
                                ZipAwareElement.1.$$$reportNull$$$0(2);
                            }
                            return browser;
                        }

                        @Override
                        @NotNull
                        public InputStream getInputStream() throws IllegalStateException, IOException {
                            ArchiveEntry nextEntry;
                            if (!this.isLeaf()) {
                                throw new IllegalStateException("Content of zip element is unavailable");
                            }
                            ArchiveInputStream archiveInputStream = this.openArchiveStream();
                            while ((nextEntry = archiveInputStream.getNextEntry()) != null) {
                                if (!nextEntry.getName().equals(entry.getOriginalName())) continue;
                                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)archiveInputStream);
                                if (bufferedInputStream == null) {
                                    ZipAwareElement.1.$$$reportNull$$$0(3);
                                }
                                return bufferedInputStream;
                            }
                            FileUtil.close((Closeable)archiveInputStream);
                            throw new IOException("Failed to open sub-archive: " + this.getFullName());
                        }

                        @Override
                        public boolean isArchive() {
                            return false;
                        }

                        @Override
                        public boolean isInsideArchive() {
                            return true;
                        }

                        public boolean equals(Object obj) {
                            return obj instanceof Element && ((Element)obj).getFullName().equals(this.getFullName());
                        }

                        public int hashCode() {
                            return this.getFullName().hashCode();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = "jetbrains/buildServer/util/browser/ZipAwareBrowser$ZipAwareElement$3$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getName";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getFullName";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getBrowser";
                                    break;
                                }
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getInputStream";
                                    break;
                                }
                            }
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                        }
                    };
                    if (myExpandNestedArchives) {
                        return new ZipAwareElement(myBrowser, insideZipElement, myExpandNestedArchives);
                    }
                    return insideZipElement;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "jetbrains/buildServer/util/browser/ZipAwareBrowser$ZipAwareElement$3", "createFrom"));
                }
            });
            if (list == null) {
                ZipAwareElement.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        private ArchiveInputStream openArchiveStream() throws IOException {
            InputStream inputStream = this.getInputStream();
            ArchiveInputStream stream = ArchiveUtil.getArchiveInputStream((ArchiveType)this.getArchiveType(), (InputStream)inputStream);
            if (stream == null) {
                FileUtil.close((Closeable)inputStream);
                throw new IOException("Cannot open archive");
            }
            ArchiveInputStream archiveInputStream = stream;
            if (archiveInputStream == null) {
                ZipAwareElement.$$$reportNull$$$0(9);
            }
            return archiveInputStream;
        }

        @NotNull
        private String extractChild(@NotNull String name, @NotNull String prefix, boolean[] endReached) {
            if (name == null) {
                ZipAwareElement.$$$reportNull$$$0(10);
            }
            if (prefix == null) {
                ZipAwareElement.$$$reportNull$$$0(11);
            }
            if (name.equals(prefix)) {
                if ("" == null) {
                    ZipAwareElement.$$$reportNull$$$0(12);
                }
                return "";
            }
            int prefixLength = prefix.length();
            int slash = name.indexOf(47, prefixLength);
            int end = slash == -1 ? name.length() : slash;
            endReached[0] = slash == -1;
            String string = name.substring(prefixLength, end);
            if (string == null) {
                ZipAwareElement.$$$reportNull$$$0(13);
            }
            return string;
        }

        public boolean equals(Object other) {
            return other instanceof ZipAwareElement && ((ZipAwareElement)other).myElement.equals(this.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/browser/ZipAwareBrowser$ZipAwareElement";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/browser/ZipAwareBrowser$ZipAwareElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBrowser";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArchiveType";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readZipChildren";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "openArchiveStream";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extractChild";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "readZipChildren";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "extractChild";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ArchiveEntryData {
            private final String myOriginalName;
            private final String myChildName;
            private final boolean myIsLeaf;
            private final long mySize;

            private ArchiveEntryData(String originalName, String childName, boolean isLeaf, long size) {
                this.myOriginalName = originalName;
                this.myChildName = childName;
                this.myIsLeaf = isLeaf;
                this.mySize = size;
            }

            public String getOriginalName() {
                return this.myOriginalName;
            }

            public String getChildName() {
                return this.myChildName;
            }

            public boolean isLeaf() {
                return this.myIsLeaf;
            }

            public long getSize() {
                return this.mySize;
            }
        }
    }
}

