/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import jetbrains.buildServer.util.graph.BFSVisitor;
import jetbrains.buildServer.util.graph.BreadthFirstSearch;
import jetbrains.buildServer.util.graph.Vertex;
import org.jetbrains.annotations.NotNull;

class BFS<T>
implements BreadthFirstSearch<T> {
    private final Queue<Vertex<T>> myQueue;
    private final Set<Vertex<T>> myVisitedVertices;
    private final BFSVisitor<T> myCallback;
    private final Set<Vertex<T>> myStarts;
    private final boolean myForward;

    BFS(@NotNull Vertex<T> start, @NotNull BFSVisitor<T> callback, boolean forward) {
        if (start == null) {
            BFS.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            BFS.$$$reportNull$$$0(1);
        }
        this(Collections.singleton(start), callback, forward);
    }

    BFS(@NotNull Set<Vertex<T>> starts, @NotNull BFSVisitor<T> callback, boolean forward) {
        if (starts == null) {
            BFS.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            BFS.$$$reportNull$$$0(3);
        }
        this.myQueue = new LinkedList<Vertex<T>>();
        this.myVisitedVertices = new HashSet<Vertex<T>>();
        this.myStarts = starts;
        this.myCallback = callback;
        this.myForward = forward;
    }

    @Override
    public void run() {
        for (Vertex<T> start : this.myStarts) {
            this.enqueue(start);
        }
        this.visit();
    }

    private void visit() {
        while (!this.isEmpty()) {
            Vertex<T> v = this.dequeue();
            T node = v.getValue();
            if (!this.myCallback.discover(node)) continue;
            for (Vertex<T> n : this.getNeighbours(v)) {
                if (!this.myVisitedVertices.add(n)) continue;
                this.enqueue(n);
            }
        }
        this.myCallback.searchFinished();
    }

    private List<Vertex<T>> getNeighbours(Vertex<T> v) {
        return this.myForward ? v.getParents() : v.getChildren();
    }

    private boolean isEmpty() {
        return this.myQueue.isEmpty();
    }

    private void enqueue(@NotNull Vertex<T> v) {
        if (v == null) {
            BFS.$$$reportNull$$$0(4);
        }
        this.myQueue.add(v);
    }

    private Vertex<T> dequeue() {
        return this.myQueue.remove();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starts";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/graph/BFS";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "enqueue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

