/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.util.ItemProcessor;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.graph.BFSVisitor;
import jetbrains.buildServer.util.graph.CycleDetectedException;
import jetbrains.buildServer.util.graph.DAGIterator;
import jetbrains.buildServer.util.graph.DAGIteratorImpl;
import jetbrains.buildServer.util.graph.DAGs;
import jetbrains.buildServer.util.graph.DFSVisitor;
import jetbrains.buildServer.util.graph.DFSVisitorAdapter;
import jetbrains.buildServer.util.graph.DepthFirstSearch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DAG<T> {
    @NotNull
    public abstract List<T> toposort();

    @NotNull
    public final List<T> getCommonAncestors(T ... nodes) {
        if (nodes == null) {
            DAG.$$$reportNull$$$0(0);
        }
        List<T> list = this.getCommonAncestors(Arrays.asList(nodes));
        if (list == null) {
            DAG.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public abstract List<T> getCommonAncestors(@NotNull List<T> var1);

    @NotNull
    public abstract List<T> getParents(@NotNull T var1);

    public boolean hasParents(@NotNull T node) {
        if (node == null) {
            DAG.$$$reportNull$$$0(2);
        }
        return !this.getParents(node).isEmpty();
    }

    @NotNull
    public final List<T> getChildren(@NotNull T node) {
        if (node == null) {
            DAG.$$$reportNull$$$0(3);
        }
        ArrayList children = new ArrayList();
        DAG<T> dag = this;
        while (!dag.isEmpty()) {
            dag.fillSelfChildren(node, children);
            dag = dag.getTail();
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            DAG.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    protected abstract void fillSelfChildren(@NotNull T var1, @NotNull List<T> var2);

    @NotNull
    public DAGIterator<T> iterator() {
        DAGIterator<T> dAGIterator = this.iterator((Collection<T>)this.getNodesWithoutChildren());
        if (dAGIterator == null) {
            DAG.$$$reportNull$$$0(5);
        }
        return dAGIterator;
    }

    @NotNull
    public DAGIterator<T> iterator(@NotNull T startNode) {
        if (startNode == null) {
            DAG.$$$reportNull$$$0(6);
        }
        DAGIteratorImpl<T> dAGIteratorImpl = new DAGIteratorImpl<T>(this, startNode);
        if (dAGIteratorImpl == null) {
            DAG.$$$reportNull$$$0(7);
        }
        return dAGIteratorImpl;
    }

    @NotNull
    public DAGIterator<T> iterator(@NotNull Collection<T> startNodes) {
        if (startNodes == null) {
            DAG.$$$reportNull$$$0(8);
        }
        DAGIteratorImpl<T> dAGIteratorImpl = new DAGIteratorImpl<T>(this, startNodes);
        if (dAGIteratorImpl == null) {
            DAG.$$$reportNull$$$0(9);
        }
        return dAGIteratorImpl;
    }

    @NotNull
    public DAG<T> exclude(final @NotNull Collection<T> nodesToExclude) {
        if (nodesToExclude == null) {
            DAG.$$$reportNull$$$0(10);
        }
        DAG<T> dAG = this.filter(new Filter<T>(){

            public boolean accept(@NotNull T data) {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !nodesToExclude.contains(data);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/graph/DAG$1", "accept"));
            }
        });
        if (dAG == null) {
            DAG.$$$reportNull$$$0(11);
        }
        return dAG;
    }

    @NotNull
    public DAG<T> include(@NotNull Collection<T> nodesToInclude) {
        if (nodesToInclude == null) {
            DAG.$$$reportNull$$$0(12);
        }
        DAG<T> dAG = this.include(nodesToInclude, true);
        if (dAG == null) {
            DAG.$$$reportNull$$$0(13);
        }
        return dAG;
    }

    @NotNull
    public DAG<T> include(final @NotNull Collection<T> nodesToInclude, boolean extrapolateEdges) {
        if (nodesToInclude == null) {
            DAG.$$$reportNull$$$0(14);
        }
        DAG<T> dAG = this.filter(new Filter<T>(){

            public boolean accept(@NotNull T data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                return nodesToInclude.contains(data);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/graph/DAG$2", "accept"));
            }
        }, false, extrapolateEdges);
        if (dAG == null) {
            DAG.$$$reportNull$$$0(15);
        }
        return dAG;
    }

    @NotNull
    public DAG<T> filter(@NotNull Filter<T> filter) {
        if (filter == null) {
            DAG.$$$reportNull$$$0(16);
        }
        DAG<T> dAG = this.filter(filter, false);
        if (dAG == null) {
            DAG.$$$reportNull$$$0(17);
        }
        return dAG;
    }

    public DAG<T> filter(@NotNull Filter<T> filter, boolean includeAcceptedNodeParents) {
        if (filter == null) {
            DAG.$$$reportNull$$$0(18);
        }
        return this.filter(filter, includeAcceptedNodeParents, true);
    }

    public abstract DAG<T> filter(@NotNull Filter<T> var1, boolean var2, boolean var3);

    public abstract boolean containsNode(@NotNull T var1);

    @NotNull
    public abstract List<T> getNodesWithoutParents();

    public final Set<T> getNodesWithMissingParents() {
        HashSet result = new HashSet();
        this.fillNodesWithMissingParents(result);
        return result;
    }

    abstract void fillNodesWithMissingParents(@NotNull Collection<T> var1);

    @NotNull
    public abstract List<T> getNodesWithoutChildren();

    public final void depthFirstSearch(@NotNull T start, @NotNull DFSVisitor<T> visitor) {
        if (start == null) {
            DAG.$$$reportNull$$$0(19);
        }
        if (visitor == null) {
            DAG.$$$reportNull$$$0(20);
        }
        this.getDepthFirstSearch(start, visitor).run();
    }

    public abstract void breadthFirstSearch(@NotNull T var1, @NotNull BFSVisitor<T> var2);

    public abstract void breadthFirstSearch(@NotNull Set<T> var1, @NotNull BFSVisitor<T> var2);

    public abstract void reverseBreadthFirstSearch(@NotNull T var1, @NotNull BFSVisitor<T> var2);

    public abstract void reverseBreadthFirstSearch(@NotNull Set<T> var1, @NotNull BFSVisitor<T> var2);

    public abstract DepthFirstSearch<T> getDepthFirstSearch(@NotNull T var1, @NotNull DFSVisitor<T> var2);

    public abstract DepthFirstSearch<T> getReverseDepthFirstSearch(@NotNull T var1, @NotNull DFSVisitor<T> var2);

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    abstract int selfSize();

    @NotNull
    abstract Collection<Pair<T, T>> getInitialEdges();

    @NotNull
    abstract DAG<T> getTail();

    @NotNull
    public abstract Set<T> getAllNodes();

    protected void ensureContainsNode(@NotNull T node) {
        if (node == null) {
            DAG.$$$reportNull$$$0(21);
        }
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("Cannot find a node: " + node);
        }
    }

    @Nullable
    protected abstract List<T> getSelfParents(@NotNull T var1);

    protected abstract void processNodesWithoutChildren(@NotNull ItemProcessor<T> var1);

    @NotNull
    Collection<Pair<T, T>> getAllEdges() {
        ArrayList<Pair<T, T>> edges = new ArrayList<Pair<T, T>>();
        DAG<T> dag = this;
        while (!dag.isEmpty()) {
            edges.addAll(dag.getInitialEdges());
            dag = dag.getTail();
        }
        ArrayList<Pair<T, T>> arrayList = edges;
        if (arrayList == null) {
            DAG.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    void checkCycles(@NotNull List<T> acyclicNodes) throws CycleDetectedException {
        if (acyclicNodes == null) {
            DAG.$$$reportNull$$$0(23);
        }
        if (acyclicNodes.size() < this.size()) {
            HashSet<T> visited = new HashSet<T>(acyclicNodes);
            for (T node : this.getAllNodes()) {
                if (visited.contains(node)) continue;
                this.depthFirstSearch(node, new DFSVisitorAdapter<T>(){});
            }
        }
    }

    public List<DAG<T>> splitIsolatedDAGs() {
        ArrayList<DAG<T>> res = new ArrayList<DAG<T>>();
        HashSet visitedVertices = new HashSet();
        List<T> tips = this.getNodesWithoutParents();
        for (T tip : tips) {
            ArrayList<Pair<T, T>> isolatedDAGEdges = new ArrayList<Pair<T, T>>();
            if (!this.doTraverseSplit(tip, this.getChildren(tip), Collections.emptyList(), isolatedDAGEdges, visitedVertices, new HashSet())) continue;
            res.add(DAGs.createFromEdges(isolatedDAGEdges));
        }
        if (res.isEmpty()) {
            res.add(DAGs.emptyDAG());
        }
        return res;
    }

    private boolean doTraverseSplit(@NotNull T from, @NotNull List<T> children, @NotNull List<T> parents, @NotNull List<Pair<T, T>> collectingEdges, @NotNull Set<T> globallyVisitedVertices, @NotNull HashSet<T> localVisitedVertices) {
        if (from == null) {
            DAG.$$$reportNull$$$0(24);
        }
        if (children == null) {
            DAG.$$$reportNull$$$0(25);
        }
        if (parents == null) {
            DAG.$$$reportNull$$$0(26);
        }
        if (collectingEdges == null) {
            DAG.$$$reportNull$$$0(27);
        }
        if (globallyVisitedVertices == null) {
            DAG.$$$reportNull$$$0(28);
        }
        if (localVisitedVertices == null) {
            DAG.$$$reportNull$$$0(29);
        }
        if (!children.isEmpty() || !parents.isEmpty()) {
            return this.doTraverseDirection(from, children, collectingEdges, globallyVisitedVertices, localVisitedVertices, true) && this.doTraverseDirection(from, parents, collectingEdges, globallyVisitedVertices, localVisitedVertices, false);
        }
        collectingEdges.add(Pair.create(from, null));
        return true;
    }

    private boolean doTraverseDirection(@NotNull T from, @NotNull List<T> children, @NotNull List<Pair<T, T>> collectingEdges, @NotNull Set<T> globallyVisitedVertices, @NotNull HashSet<T> localVisitedVertices, boolean direction) {
        if (from == null) {
            DAG.$$$reportNull$$$0(30);
        }
        if (children == null) {
            DAG.$$$reportNull$$$0(31);
        }
        if (collectingEdges == null) {
            DAG.$$$reportNull$$$0(32);
        }
        if (globallyVisitedVertices == null) {
            DAG.$$$reportNull$$$0(33);
        }
        if (localVisitedVertices == null) {
            DAG.$$$reportNull$$$0(34);
        }
        for (T vertex : children) {
            if (direction) {
                collectingEdges.add(Pair.create(vertex, from));
            } else {
                collectingEdges.add(Pair.create(from, vertex));
            }
            if (!localVisitedVertices.add(vertex)) continue;
            if (!globallyVisitedVertices.add(vertex)) {
                return false;
            }
            if (this.doTraverseSplit(vertex, this.getChildren(vertex), this.getParents(vertex), collectingEdges, globallyVisitedVertices, localVisitedVertices)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/DAG";
                break;
            }
            case 2: 
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNodes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToExclude";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToInclude";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acyclicNodes";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectingEdges";
                break;
            }
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globallyVisitedVertices";
                break;
            }
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localVisitedVertices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/DAG";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonAncestors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "exclude";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "include";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEdges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestors";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasParents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "iterator";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "include";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "depthFirstSearch";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "ensureContainsNode";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkCycles";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doTraverseSplit";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doTraverseDirection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

