/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import gnu.trove.set.hash.TLongHashSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import jetbrains.buildServer.util.graph.BFSVisitor;
import jetbrains.buildServer.util.graph.BreadthFirstSearch;
import jetbrains.buildServer.util.graph.DAG;
import org.jetbrains.annotations.NotNull;

public class ModificationDagBFS
implements BreadthFirstSearch<Long> {
    private final Queue<Long> myQueue;
    private final TLongHashSet myVisitedNodes;
    private final DAG<Long> myDag;
    private final Set<Long> myStarts;
    private final BFSVisitor<Long> myCallback;
    private final boolean myForward;

    ModificationDagBFS(@NotNull DAG<Long> dag, @NotNull Long start, @NotNull BFSVisitor<Long> callback, boolean forward) {
        if (dag == null) {
            ModificationDagBFS.$$$reportNull$$$0(0);
        }
        if (start == null) {
            ModificationDagBFS.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            ModificationDagBFS.$$$reportNull$$$0(2);
        }
        this(dag, Collections.singleton(start), callback, forward);
    }

    ModificationDagBFS(@NotNull DAG<Long> dag, @NotNull Set<Long> starts, @NotNull BFSVisitor<Long> callback, boolean forward) {
        if (dag == null) {
            ModificationDagBFS.$$$reportNull$$$0(3);
        }
        if (starts == null) {
            ModificationDagBFS.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            ModificationDagBFS.$$$reportNull$$$0(5);
        }
        this.myQueue = new LinkedList<Long>();
        this.myVisitedNodes = new TLongHashSet();
        this.myDag = dag;
        this.myStarts = starts;
        this.myCallback = callback;
        this.myForward = forward;
    }

    @Override
    public void run() {
        for (Long start : this.myStarts) {
            this.enqueue(start);
        }
        this.visit();
    }

    private void visit() {
        while (!this.isEmpty()) {
            Long node = this.dequeue();
            if (!this.myCallback.discover(node)) continue;
            for (Long n : this.getNeighbours(node)) {
                if (!this.myVisitedNodes.add(n.longValue())) continue;
                this.enqueue(n);
            }
        }
        this.myCallback.searchFinished();
    }

    private List<Long> getNeighbours(@NotNull Long node) {
        if (node == null) {
            ModificationDagBFS.$$$reportNull$$$0(6);
        }
        return this.myForward ? this.myDag.getParents(node) : this.myDag.getChildren(node);
    }

    private boolean isEmpty() {
        return this.myQueue.isEmpty();
    }

    private void enqueue(Long v) {
        this.myQueue.add(v);
    }

    private Long dequeue() {
        return this.myQueue.remove();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starts";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/graph/ModificationDagBFS";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getNeighbours";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

