/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.util.graph.CycleDetectedException;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.DFSVisitor;
import jetbrains.buildServer.util.graph.DepthFirstSearch;
import org.jetbrains.annotations.NotNull;

public class ModificationDagDFS
implements DepthFirstSearch<Long> {
    private final TLongObjectHashMap<Color> myColors;
    private final ArrayList<Long> myStack;
    private final TLongArrayList myPaused;
    private final DAG<Long> myDag;
    private final long myStart;
    private final DFSVisitor<Long> myCallback;
    private boolean myFinished;
    private final boolean myForward;

    /*
     * WARNING - void declaration
     */
    ModificationDagDFS(@NotNull DAG<Long> dag, long start, @NotNull DFSVisitor<Long> callback, boolean bl) {
        void forward;
        if (dag == null) {
            ModificationDagDFS.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            ModificationDagDFS.$$$reportNull$$$0(1);
        }
        this.myColors = new TLongObjectHashMap();
        this.myStack = new ArrayList();
        this.myPaused = new TLongArrayList();
        this.myDag = dag;
        this.myStart = start;
        this.myCallback = callback;
        this.myForward = forward;
    }

    @Override
    @NotNull
    public Long getStart() {
        Long l = this.myStart;
        if (l == null) {
            ModificationDagDFS.$$$reportNull$$$0(2);
        }
        return l;
    }

    @Override
    public void run() {
        this.forgetPausedSearch();
        this.runWhile(this.allNodesAreVisited());
    }

    @Override
    public void runWhile(@NotNull DepthFirstSearch.Predicate<Long> predicate) {
        if (predicate == null) {
            ModificationDagDFS.$$$reportNull$$$0(3);
        }
        if (this.isFinished()) {
            return;
        }
        if (this.notInPausedSearch()) {
            this.pauseAt(this.myStart);
        }
        this.restorePausedSearch();
        this.visit(predicate);
    }

    private void forgetPausedSearch() {
        this.myPaused.clear();
        this.myFinished = false;
    }

    private boolean notInPausedSearch() {
        return this.myPaused.isEmpty();
    }

    private void pauseAt(long v) {
        this.myPaused.add(v);
    }

    private boolean isFinished() {
        return this.myFinished;
    }

    private void restorePausedSearch() {
        for (int i = this.myPaused.size() - 1; i >= 0; --i) {
            this.push(this.myPaused.getQuick(i));
        }
        this.myPaused.clear();
    }

    private void visit(@NotNull DepthFirstSearch.Predicate<Long> predicate) {
        if (predicate == null) {
            ModificationDagDFS.$$$reportNull$$$0(4);
        }
        while (!this.isEmpty()) {
            Long value = this.peek();
            if (predicate.apply(value)) {
                switch (this.getColor(value)) {
                    case WHITE: {
                        this.setColor(value, Color.GREY);
                        if (!this.myCallback.discover(value)) break;
                        this.pushNeighbours(value);
                        break;
                    }
                    case GREY: {
                        this.pop();
                        this.setColor(value, Color.BLACK);
                        this.myCallback.finish(value);
                        break;
                    }
                    case BLACK: {
                        this.pop();
                    }
                }
                continue;
            }
            this.pop();
            this.pauseAt(value);
        }
        if (this.myPaused.isEmpty()) {
            this.myFinished = true;
        }
    }

    private void pushNeighbours(Long vertex) {
        List<Long> neighbours = this.myForward ? this.myDag.getParents(vertex) : this.myDag.getChildren(vertex);
        block4: for (int i = neighbours.size() - 1; i >= 0; --i) {
            Long n = neighbours.get(i);
            switch (this.getColor(n)) {
                case WHITE: {
                    this.push(n);
                    continue block4;
                }
                case GREY: {
                    throw new CycleDetectedException(vertex, n);
                }
            }
        }
    }

    private void setColor(Long v, Color color) {
        this.myColors.put(v.longValue(), (Object)color);
    }

    private Color getColor(Long v) {
        Color result = (Color)((Object)this.myColors.get(v.longValue()));
        if (result == null) {
            result = Color.WHITE;
            this.myColors.put(v.longValue(), (Object)result);
        }
        return result;
    }

    private boolean isEmpty() {
        return this.myStack.isEmpty();
    }

    private Long peek() {
        return this.myStack.get(this.myStack.size() - 1);
    }

    private Long pop() {
        return this.myStack.remove(this.myStack.size() - 1);
    }

    private void push(Long v) {
        this.myStack.add(v);
    }

    private DepthFirstSearch.Predicate<Long> allNodesAreVisited() {
        return new AlwaysTrue<Long>();
    }

    public String toString() {
        return "DFS from " + this.myStart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/ModificationDagDFS";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/ModificationDagDFS";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runWhile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AlwaysTrue<T>
    implements DepthFirstSearch.Predicate<T> {
        private AlwaysTrue() {
        }

        @Override
        public boolean apply(@NotNull T node) {
            if (node == null) {
                AlwaysTrue.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/ModificationDagDFS$AlwaysTrue", "apply"));
        }
    }

    private static enum Color {
        WHITE,
        GREY,
        BLACK;

    }
}

