/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.vcs.api.CommitData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCommitData
implements CommitData {
    private final Date myVcsDate;
    private final String myVersion;
    private final String myDisplayVersion;
    private List<String> myParentRevisions;
    private Map<String, String> myAttributes;

    protected BaseCommitData(@NotNull String version, @Nullable String displayVersion, @NotNull Date vcsDate) {
        if (version == null) {
            BaseCommitData.$$$reportNull$$$0(0);
        }
        if (vcsDate == null) {
            BaseCommitData.$$$reportNull$$$0(1);
        }
        this.myVersion = version;
        displayVersion = displayVersion != null ? displayVersion : "";
        this.myDisplayVersion = this.myVersion.equals(displayVersion) ? this.myVersion : displayVersion;
        this.myVcsDate = new Date(vcsDate.getTime());
    }

    @NotNull
    public Date getVcsDate() {
        Date date = this.myVcsDate;
        if (date == null) {
            BaseCommitData.$$$reportNull$$$0(2);
        }
        return date;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            BaseCommitData.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getDisplayVersion() {
        String string = this.myDisplayVersion;
        if (string == null) {
            BaseCommitData.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void addParentRevision(@NotNull String parentRevision) {
        if (parentRevision == null) {
            BaseCommitData.$$$reportNull$$$0(5);
        }
        if (this.myParentRevisions == null) {
            this.myParentRevisions = new ArrayList<String>(1);
        }
        this.myParentRevisions.add(parentRevision);
    }

    public void setParentRevisions(@NotNull Collection<String> parentRevisions) {
        if (parentRevisions == null) {
            BaseCommitData.$$$reportNull$$$0(6);
        }
        if (this.myParentRevisions == null) {
            this.myParentRevisions = new ArrayList<String>(parentRevisions);
        } else {
            this.myParentRevisions.clear();
            this.myParentRevisions.addAll(parentRevisions);
        }
    }

    @NotNull
    public List<String> getParentRevisions() {
        if (this.myParentRevisions == null) {
            ArrayList<String> arrayList = new ArrayList<String>(0);
            if (arrayList == null) {
                BaseCommitData.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.myParentRevisions);
        if (arrayList == null) {
            BaseCommitData.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public void setAttributes(@NotNull Map<String, String> attributes) {
        if (attributes == null) {
            BaseCommitData.$$$reportNull$$$0(9);
        }
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap<String, String>(attributes);
        } else {
            this.myAttributes.clear();
            this.myAttributes.putAll(attributes);
        }
    }

    public void setAttribute(@NotNull String name, @NotNull String value) {
        if (name == null) {
            BaseCommitData.$$$reportNull$$$0(10);
        }
        if (value == null) {
            BaseCommitData.$$$reportNull$$$0(11);
        }
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap<String, String>(0);
        }
        this.myAttributes.put(name, value);
    }

    @NotNull
    public Map<String, String> getAttributes() {
        if (this.myAttributes == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(0);
            if (hashMap == null) {
                BaseCommitData.$$$reportNull$$$0(12);
            }
            return hashMap;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(this.myAttributes);
        if (hashMap == null) {
            BaseCommitData.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseCommitData that = (BaseCommitData)o;
        return this.equalsImpl(that);
    }

    protected boolean equalsImpl(@NotNull BaseCommitData that) {
        if (that == null) {
            BaseCommitData.$$$reportNull$$$0(14);
        }
        return this.myDisplayVersion.equals(that.myDisplayVersion) && (this.myVcsDate == null ? that.myVcsDate == null : this.myVcsDate.equals(that.myVcsDate)) && this.myVersion.equals(that.myVersion) && (this.myParentRevisions == null ? that.myParentRevisions == null : this.myParentRevisions.equals(that.myParentRevisions));
    }

    public int hashCode() {
        int result = 42;
        result = 31 * result + (this.myVcsDate != null ? this.myVcsDate.hashCode() : 0);
        result = 31 * result + this.myVersion.hashCode();
        result = 31 * result + this.myDisplayVersion.hashCode();
        result = 31 * result + (this.myParentRevisions != null ? this.myParentRevisions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CommitData{, myVcsDate=" + this.myVcsDate + ", myVersion='" + this.myVersion + '\'' + ", myDisplayVersion='" + this.myDisplayVersion + '\'' + ", myParentRevisions=" + this.myParentRevisions + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/BaseCommitData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRevision";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRevisions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/BaseCommitData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsDate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentRevisions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addParentRevision";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setParentRevisions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setAttributes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "equalsImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

