/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import jetbrains.buildServer.vcs.VcsChange;
import jetbrains.buildServer.vcs.VcsException;
import jetbrains.buildServer.vcs.VcsFileModification;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilteredVcsChange
extends VcsChange
implements VcsFileModification {
    private final VcsFileModification myDelegate;
    private final ExcludeReason myExcludeReason;

    public FilteredVcsChange(@NotNull VcsFileModification delegate, @Nullable ExcludeReason excludeReason, String relativeFileName) {
        if (delegate == null) {
            FilteredVcsChange.$$$reportNull$$$0(0);
        }
        super(delegate.getType(), delegate.getChangeTypeName(), delegate.getFileName(), relativeFileName, delegate.getBeforeChangeRevisionNumber(), delegate.getAfterChangeRevisionNumber());
        this.myDelegate = delegate;
        this.myExcludeReason = excludeReason;
    }

    public boolean isExcluded() {
        return this.myExcludeReason != null;
    }

    public boolean isExcludedByCheckoutRules() {
        return this.isExcluded() && this.myExcludeReason == ExcludeReason.EXCLUDED_BY_CHECKOUT_RULES;
    }

    @Nullable
    public String getExcludeReason() {
        return this.myExcludeReason != null ? this.myExcludeReason.getDescription() : null;
    }

    @Override
    public byte[] getContentBefore() throws VcsException {
        return this.myDelegate.getContentBefore();
    }

    @Override
    public byte[] getContentAfter() throws VcsException {
        return this.myDelegate.getContentAfter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "jetbrains/buildServer/vcs/FilteredVcsChange", "<init>"));
    }

    public static enum ExcludeReason {
        EXCLUDED_BY_CHECKOUT_RULES("excluded by checkout rules"),
        NO_MATCHING_VCS_ROOT_FOUND("no matching VCS root found");

        private final String myDescription;

        private ExcludeReason(String description) {
            this.myDescription = description;
        }

        public String getDescription() {
            return this.myDescription;
        }
    }
}

