/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.vcs.api.data.VcsRepositoryState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryStateData
implements VcsRepositoryState {
    public static final String SPECIAL_BRANCH_NAME = "";
    private final Map<String, String> myRevisions;
    private final String myDefaultBranchName;

    private RepositoryStateData(@NotNull String defaultBranchName, @NotNull Map<String, String> revisions) {
        if (defaultBranchName == null) {
            RepositoryStateData.$$$reportNull$$$0(0);
        }
        if (revisions == null) {
            RepositoryStateData.$$$reportNull$$$0(1);
        }
        this.myRevisions = revisions;
        this.myDefaultBranchName = defaultBranchName;
    }

    @NotNull
    public Map<String, String> getBranchRevisions() {
        Map<String, String> map = Collections.unmodifiableMap(this.myRevisions);
        if (map == null) {
            RepositoryStateData.$$$reportNull$$$0(2);
        }
        return map;
    }

    public boolean isEmpty() {
        return this.myRevisions.isEmpty();
    }

    @NotNull
    public String getDefaultBranchName() {
        String string = this.myDefaultBranchName;
        if (string == null) {
            RepositoryStateData.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getDefaultBranchRevision() {
        return this.myRevisions.get(this.myDefaultBranchName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryStateData that = (RepositoryStateData)o;
        if (!this.myDefaultBranchName.equals(that.myDefaultBranchName)) {
            return false;
        }
        return this.myRevisions.equals(that.myRevisions);
    }

    public int hashCode() {
        int result = this.myRevisions.hashCode();
        result = 31 * result + this.myDefaultBranchName.hashCode();
        return result;
    }

    public String toString() {
        return "RepositoryStateData{myRevisions=" + this.myRevisions + ", myDefaultBranchName='" + this.myDefaultBranchName + '\'' + '}';
    }

    @NotNull
    public static RepositoryStateData createSingleVersionState(@Nullable String version) {
        if (StringUtil.isEmptyOrSpaces((String)version)) {
            RepositoryStateData repositoryStateData = new RepositoryStateData(SPECIAL_BRANCH_NAME, Collections.emptyMap());
            if (repositoryStateData == null) {
                RepositoryStateData.$$$reportNull$$$0(4);
            }
            return repositoryStateData;
        }
        RepositoryStateData repositoryStateData = new RepositoryStateData(SPECIAL_BRANCH_NAME, Collections.singletonMap(SPECIAL_BRANCH_NAME, version));
        if (repositoryStateData == null) {
            RepositoryStateData.$$$reportNull$$$0(5);
        }
        return repositoryStateData;
    }

    @NotNull
    public static RepositoryStateData createVersionState(@NotNull String defaultBranchName, @NotNull Map<String, String> state) {
        if (defaultBranchName == null) {
            RepositoryStateData.$$$reportNull$$$0(6);
        }
        if (state == null) {
            RepositoryStateData.$$$reportNull$$$0(7);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : state.entrySet()) {
            if (entry.getValue() == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        if (map.isEmpty()) {
            RepositoryStateData repositoryStateData = new RepositoryStateData(defaultBranchName, Collections.emptyMap());
            if (repositoryStateData == null) {
                RepositoryStateData.$$$reportNull$$$0(8);
            }
            return repositoryStateData;
        }
        RepositoryStateData repositoryStateData = new RepositoryStateData(defaultBranchName, Collections.unmodifiableMap(map));
        if (repositoryStateData == null) {
            RepositoryStateData.$$$reportNull$$$0(9);
        }
        return repositoryStateData;
    }

    @NotNull
    public static RepositoryStateData createFromState(VcsRepositoryState state) {
        RepositoryStateData repositoryStateData = RepositoryStateData.createVersionState(state.getDefaultBranchName(), state.getBranchRevisions());
        if (repositoryStateData == null) {
            RepositoryStateData.$$$reportNull$$$0(10);
        }
        return repositoryStateData;
    }

    @NotNull
    public static RepositoryStateData createVersionState(@NotNull String branch, @NotNull String revision) {
        if (branch == null) {
            RepositoryStateData.$$$reportNull$$$0(11);
        }
        if (revision == null) {
            RepositoryStateData.$$$reportNull$$$0(12);
        }
        RepositoryStateData repositoryStateData = RepositoryStateData.createVersionState(branch, Collections.singletonMap(branch, revision));
        if (repositoryStateData == null) {
            RepositoryStateData.$$$reportNull$$$0(13);
        }
        return repositoryStateData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultBranchName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/RepositoryStateData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/RepositoryStateData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchRevisions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBranchName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleVersionState";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createVersionState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createVersionState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

