/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.vcs.SubrepoConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubrepoRevisionAttributesBuilder {
    private static final String REVISION = "revision";
    private static final String VCS_ROOT_PARAMS_PREFIX = "vcsRootParams.";
    private static final String SUBREPO_PATH = "teamcity.internal.subrepo.path";
    private static final String SUBREPO_ATTRIBUTE_PREFIX = "subrepoConfig.";
    private final List<SubrepoConfig> mySubrepos = new ArrayList<SubrepoConfig>(0);

    @NotNull
    public static List<SubrepoConfig> readAttributes(@NotNull Map<String, String> attrs) {
        if (attrs == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(0);
        }
        ArrayList<SubrepoConfig> subrepos = new ArrayList<SubrepoConfig>(0);
        for (Map<String, String> subrepoAttrs : SubrepoRevisionAttributesBuilder.groupBySubrepoPrefix(attrs)) {
            subrepos.add(SubrepoRevisionAttributesBuilder.createSubrepoConfig(subrepoAttrs));
        }
        ArrayList<SubrepoConfig> arrayList = subrepos;
        if (arrayList == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public Map<String, String> buildAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>(0);
        for (int i = 0; i < this.mySubrepos.size(); ++i) {
            attrs.putAll(this.buildAttributes(this.mySubrepos.get(i), i));
        }
        HashMap<String, String> hashMap = attrs;
        if (hashMap == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    public void addSubrepo(@NotNull SubrepoConfig subrepoConfig) {
        if (subrepoConfig == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(3);
        }
        this.mySubrepos.add(subrepoConfig);
    }

    private Map<String, String> buildAttributes(@NotNull SubrepoConfig subrepoConfig, int subrepoId) {
        if (subrepoConfig == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(4);
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        this.addSubrepoRootProperties(attrs, subrepoConfig, subrepoId);
        this.addPath(attrs, subrepoConfig, subrepoId);
        this.addRevision(attrs, subrepoConfig, subrepoId);
        return attrs;
    }

    private void addSubrepoRootProperties(@NotNull Map<String, String> attrs, @NotNull SubrepoConfig subrepoConfig, int subrepoId) {
        if (attrs == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(5);
        }
        if (subrepoConfig == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(6);
        }
        for (Map.Entry<String, String> e : subrepoConfig.getSubrepoRootParams().entrySet()) {
            attrs.put(SUBREPO_ATTRIBUTE_PREFIX + subrepoId + "." + VCS_ROOT_PARAMS_PREFIX + e.getKey(), e.getValue());
        }
        attrs.put(SUBREPO_ATTRIBUTE_PREFIX + subrepoId + "." + VCS_ROOT_PARAMS_PREFIX + "teamcity.internal.subrepo", "true");
    }

    private void addRevision(@NotNull Map<String, String> attrs, @NotNull SubrepoConfig subrepoConfig, int subrepoId) {
        String revision;
        if (attrs == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(7);
        }
        if (subrepoConfig == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(8);
        }
        if ((revision = subrepoConfig.getSubrepoRevision()) != null) {
            attrs.put(SUBREPO_ATTRIBUTE_PREFIX + subrepoId + "." + REVISION, revision);
        }
    }

    private void addPath(@NotNull Map<String, String> attrs, @NotNull SubrepoConfig subrepoConfig, int subrepoId) {
        String subrepoPath;
        if (attrs == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(9);
        }
        if (subrepoConfig == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(10);
        }
        if ((subrepoPath = subrepoConfig.getSubrepoPath()) != null) {
            attrs.put(SUBREPO_ATTRIBUTE_PREFIX + subrepoId + "." + VCS_ROOT_PARAMS_PREFIX + SUBREPO_PATH, subrepoPath);
        }
    }

    @NotNull
    private static Collection<Map<String, String>> groupBySubrepoPrefix(@NotNull Map<String, String> attrs) {
        if (attrs == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(11);
        }
        HashMap<String, HashMap<String, String>> groupByPrefix = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            String name = e.getKey();
            String prefix = SubrepoRevisionAttributesBuilder.getSubrepoPrefix(name);
            if (prefix == null) continue;
            HashMap<String, String> attributes = (HashMap<String, String>)groupByPrefix.get(prefix);
            if (attributes == null) {
                attributes = new HashMap<String, String>();
                groupByPrefix.put(prefix, attributes);
            }
            attributes.put(name.substring(prefix.length()), e.getValue());
        }
        Collection<Map<String, String>> collection = groupByPrefix.values();
        if (collection == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Nullable
    private static String getSubrepoPrefix(@NotNull String name) {
        if (name == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(13);
        }
        if (!SubrepoRevisionAttributesBuilder.isSubrepoAttribute(name)) {
            return null;
        }
        int idx = name.indexOf(".", SUBREPO_ATTRIBUTE_PREFIX.length());
        if (idx < 0) {
            return null;
        }
        return name.substring(0, idx + 1);
    }

    public static boolean isSubrepoAttribute(@NotNull String attributeName) {
        if (attributeName == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(14);
        }
        return attributeName.startsWith(SUBREPO_ATTRIBUTE_PREFIX);
    }

    @Nullable
    private static SubrepoConfig createSubrepoConfig(@NotNull Map<String, String> attrs) {
        if (attrs == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(15);
        }
        HashMap<String, String> subrepoRootParams = new HashMap<String, String>();
        ArrayList oldRevisions = new ArrayList();
        String revision = null;
        String path = null;
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            String attrName = e.getKey();
            if (attrName.startsWith(VCS_ROOT_PARAMS_PREFIX)) {
                subrepoRootParams.put(attrName.substring(VCS_ROOT_PARAMS_PREFIX.length()), e.getValue());
                if (!attrName.equals("vcsRootParams.teamcity.internal.subrepo.path")) continue;
                path = e.getValue();
                continue;
            }
            if (!attrName.equals(REVISION)) continue;
            revision = e.getValue();
        }
        subrepoRootParams.put("teamcity.internal.subrepo", "true");
        return new SubrepoConfig(subrepoRootParams).setSubrepoPath(path).setSubrepoRevision(revision);
    }

    public static boolean isSuprepoAttribute(@NotNull String attrName) {
        if (attrName == null) {
            SubrepoRevisionAttributesBuilder.$$$reportNull$$$0(16);
        }
        return attrName.startsWith(SUBREPO_ATTRIBUTE_PREFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/SubrepoRevisionAttributesBuilder";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subrepoConfig";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/SubrepoRevisionAttributesBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readAttributes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBySubrepoPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readAttributes";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSubrepo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildAttributes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSubrepoRootProperties";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRevision";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "groupBySubrepoPrefix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSubrepoPrefix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSubrepoAttribute";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSubrepoConfig";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSuprepoAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

