/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jetbrains.buildServer.vcs.Credentials;
import jetbrains.buildServer.vcs.MavenVcsUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUrl {
    private static final Set<String> URL_PROTOCOLS = new HashSet<String>(Arrays.asList("http", "ftp", "https", "file"));
    protected final String myUrl;
    protected final Credentials myCredentials;
    private final String myProtocol;

    public VcsUrl(@NotNull String url, @Nullable Credentials credentials) {
        if (url == null) {
            VcsUrl.$$$reportNull$$$0(0);
        }
        this.myUrl = url.trim();
        this.myCredentials = credentials;
        String protocol = null;
        for (String proto : URL_PROTOCOLS) {
            if (!url.startsWith(proto + "://")) continue;
            protocol = proto;
        }
        this.myProtocol = protocol;
    }

    public VcsUrl(@NotNull String url) {
        if (url == null) {
            VcsUrl.$$$reportNull$$$0(1);
        }
        this(url, null);
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            VcsUrl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Credentials getCredentials() {
        return this.myCredentials;
    }

    @Nullable
    public MavenVcsUrl asMavenVcsUrl() {
        try {
            return new MavenVcsUrl(this.myUrl, this.myCredentials);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Nullable
    public String getProtocol() {
        return this.myProtocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof VcsUrl)) {
            return false;
        }
        VcsUrl vcsUrl = (VcsUrl)o;
        if (this.myCredentials != null ? !this.myCredentials.equals((Object)vcsUrl.myCredentials) : vcsUrl.myCredentials != null) {
            return false;
        }
        return this.myUrl.equals(vcsUrl.myUrl);
    }

    public int hashCode() {
        int result = this.myUrl.hashCode();
        result = 31 * result + (this.myCredentials != null ? this.myCredentials.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "VcsUrl{myUrl='" + this.myUrl + '\'' + ", myCredentials=" + (Object)((Object)this.myCredentials) + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/VcsUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/VcsUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

