/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.vcs.patches.AbstractFSPatcherCallback;
import jetbrains.buildServer.vcs.patches.AbstractPatcher;
import jetbrains.buildServer.vcs.patches.LocalFileUtil;
import jetbrains.buildServer.vcs.patches.LowLevelPatcherListener;
import jetbrains.buildServer.vcs.patches.PatchListener;
import jetbrains.buildServer.vcs.patches.Patcher;
import jetbrains.buildServer.vcs.patches.PatcherEventDispatcher;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFSPatcher
implements Patcher,
PatcherEventDispatcher {
    private final DataInputStream myInputStream;
    protected final LocalFileUtil myLocalFile;
    private final EventDispatcher<PatchListener> myDispatcher;
    private Bridge myBridge;

    protected AbstractFSPatcher(@NotNull DataInputStream input, @NotNull File dir) {
        if (input == null) {
            AbstractFSPatcher.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            AbstractFSPatcher.$$$reportNull$$$0(1);
        }
        this.myDispatcher = EventDispatcher.create(PatchListener.class);
        this.myInputStream = input;
        this.myLocalFile = new LocalFileUtil(dir);
    }

    @NotNull
    private Bridge getBridge() {
        if (this.myBridge == null) {
            this.myBridge = new Bridge(this.myInputStream, this.createCallback());
        }
        Bridge bridge = this.myBridge;
        if (bridge == null) {
            AbstractFSPatcher.$$$reportNull$$$0(2);
        }
        return bridge;
    }

    @NotNull
    protected abstract AbstractFSPatcherCallback createCallback();

    public void applyPatch() throws IOException {
        this.getBridge().applyPatch();
    }

    public void close() {
        this.getBridge().close();
    }

    public void interrupt() {
        this.getBridge().interrupt();
    }

    protected File getLocalFile(@NotNull String path) {
        if (path == null) {
            AbstractFSPatcher.$$$reportNull$$$0(3);
        }
        return this.myLocalFile.getFile(path);
    }

    @Override
    public void addListener(@NotNull PatchListener listener) {
        if (listener == null) {
            AbstractFSPatcher.$$$reportNull$$$0(4);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeListener(@NotNull PatchListener listener) {
        if (listener == null) {
            AbstractFSPatcher.$$$reportNull$$$0(5);
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/AbstractFSPatcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/AbstractFSPatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBridge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Bridge
    extends AbstractPatcher {
        private final AbstractFSPatcherCallback myCallback;

        public Bridge(DataInputStream input, AbstractFSPatcherCallback callback) {
            super(input);
            this.myCallback = callback;
        }

        @Override
        protected final void addDirectory(@NotNull String filePath) throws IOException {
            if (filePath == null) {
                Bridge.$$$reportNull$$$0(0);
            }
            File file = AbstractFSPatcher.this.getLocalFile(filePath);
            ((PatchListener)AbstractFSPatcher.this.myDispatcher.getMulticaster()).fileOrDirectoryAdded(file);
            this.myCallback.addDirectory(file);
        }

        @Override
        protected final void deleteFile(@NotNull String filePath, boolean deleteParentDirectoryIfEmpty, boolean isFile) throws IOException {
            if (filePath == null) {
                Bridge.$$$reportNull$$$0(1);
            }
            File path = AbstractFSPatcher.this.getLocalFile(filePath);
            ((PatchListener)AbstractFSPatcher.this.myDispatcher.getMulticaster()).fileOrDirectoryDeleted(path);
            this.myCallback.deleteFile(path, deleteParentDirectoryIfEmpty, isFile);
        }

        @Override
        protected final void renameFile(@NotNull String filePath, @NotNull String newPath, boolean deleteParentDirectoryIfEmpty, boolean isFile) throws IOException {
            if (filePath == null) {
                Bridge.$$$reportNull$$$0(2);
            }
            if (newPath == null) {
                Bridge.$$$reportNull$$$0(3);
            }
            File file = AbstractFSPatcher.this.getLocalFile(filePath);
            ((PatchListener)AbstractFSPatcher.this.myDispatcher.getMulticaster()).fileOrDirectoryRenamed(file);
            this.myCallback.renameFile(file, AbstractFSPatcher.this.getLocalFile(newPath), deleteParentDirectoryIfEmpty, isFile);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void replaceBinary(@NotNull String filePath, long length, boolean newFile, @NotNull LowLevelPatcherListener.ReadFileContent readFileContent) throws IOException {
            void content;
            if (filePath == null) {
                Bridge.$$$reportNull$$$0(4);
            }
            if (readFileContent == null) {
                Bridge.$$$reportNull$$$0(5);
            }
            File file = AbstractFSPatcher.this.getLocalFile(filePath);
            if (newFile) {
                ((PatchListener)AbstractFSPatcher.this.myDispatcher.getMulticaster()).fileOrDirectoryAdded(file);
            } else {
                ((PatchListener)AbstractFSPatcher.this.myDispatcher.getMulticaster()).fileOrDirectoryChanged(file);
            }
            this.myCallback.replaceBinary(file, length, newFile, (LowLevelPatcherListener.ReadFileContent)content);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void replaceTextUsingBytes(@NotNull String filePath, long size, @NotNull byte[] sep, boolean newFile, @NotNull LowLevelPatcherListener.ReadFileContent readFileContent) throws IOException {
            void content;
            if (filePath == null) {
                Bridge.$$$reportNull$$$0(6);
            }
            if (sep == null) {
                Bridge.$$$reportNull$$$0(7);
            }
            if (readFileContent == null) {
                Bridge.$$$reportNull$$$0(8);
            }
            File file = AbstractFSPatcher.this.getLocalFile(filePath);
            if (newFile) {
                ((PatchListener)AbstractFSPatcher.this.myDispatcher.getMulticaster()).fileOrDirectoryAdded(file);
            } else {
                ((PatchListener)AbstractFSPatcher.this.myDispatcher.getMulticaster()).fileOrDirectoryChanged(file);
            }
            this.myCallback.replaceTextUsingBytes(file, size, sep, newFile, (LowLevelPatcherListener.ReadFileContent)content);
        }

        @Override
        protected final void setFileMode(@NotNull String filePath, @NotNull String fileMode) throws IOException {
            if (filePath == null) {
                Bridge.$$$reportNull$$$0(9);
            }
            if (fileMode == null) {
                Bridge.$$$reportNull$$$0(10);
            }
            this.myCallback.setFileMode(AbstractFSPatcher.this.getLocalFile(filePath), fileMode);
        }

        @Override
        protected final void setTimeStamp(@NotNull String filePath, long timeStamp) throws IOException {
            if (filePath == null) {
                Bridge.$$$reportNull$$$0(11);
            }
            this.myCallback.setTimeStamp(AbstractFSPatcher.this.getLocalFile(filePath), timeStamp);
        }

        @Override
        protected void patchFailed(@NotNull String message) {
            if (message == null) {
                Bridge.$$$reportNull$$$0(12);
            }
            super.patchFailed(message);
            ((PatchListener)AbstractFSPatcher.this.myDispatcher.getMulticaster()).patchFailed(message);
        }

        @Override
        protected void patchSucceeded(@NotNull String message) {
            if (message == null) {
                Bridge.$$$reportNull$$$0(13);
            }
            super.patchSucceeded(message);
            ((PatchListener)AbstractFSPatcher.this.myDispatcher.getMulticaster()).patchFinished(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newPath";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sep";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileMode";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/vcs/patches/AbstractFSPatcher$Bridge";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDirectory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renameFile";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceBinary";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceTextUsingBytes";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFileMode";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTimeStamp";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "patchFailed";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "patchSucceeded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

