/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import com.intellij.openapi.diagnostic.Logger;
import java.io.DataInputStream;
import java.io.IOException;
import jetbrains.buildServer.vcs.patches.InterruptablePatcherBase;
import jetbrains.buildServer.vcs.patches.InterruptedPatchException;
import jetbrains.buildServer.vcs.patches.LowLevelPatcher;
import jetbrains.buildServer.vcs.patches.LowLevelPatcherListener;
import jetbrains.buildServer.vcs.patches.Patcher;
import jetbrains.buildServer.vcs.patches.UnsuccessfulPatchException;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPatcher
extends InterruptablePatcherBase
implements Patcher {
    private static final Logger LOG = Logger.getInstance((String)AbstractPatcher.class.getName());
    private final LowLevelPatcher myPatcher;

    protected AbstractPatcher(@NotNull DataInputStream input) {
        if (input == null) {
            AbstractPatcher.$$$reportNull$$$0(0);
        }
        this(new LowLevelPatcher(input));
    }

    protected AbstractPatcher(@NotNull LowLevelPatcher input) {
        if (input == null) {
            AbstractPatcher.$$$reportNull$$$0(1);
        }
        this.myPatcher = input;
    }

    protected abstract void replaceTextUsingBytes(@NotNull String var1, long var2, @NotNull byte[] var4, boolean var5, @NotNull LowLevelPatcherListener.ReadFileContent var6) throws IOException;

    protected abstract void setFileMode(@NotNull String var1, @NotNull String var2) throws IOException;

    protected abstract void replaceBinary(@NotNull String var1, long var2, boolean var4, @NotNull LowLevelPatcherListener.ReadFileContent var5) throws IOException;

    protected abstract void setTimeStamp(@NotNull String var1, long var2) throws IOException;

    protected abstract void deleteFile(@NotNull String var1, boolean var2, boolean var3) throws IOException;

    protected abstract void renameFile(@NotNull String var1, @NotNull String var2, boolean var3, boolean var4) throws IOException;

    protected abstract void addDirectory(@NotNull String var1) throws IOException;

    public void applyPatch() throws IOException {
        this.myPatcher.applyPatch(new LowLevelPatcherListener(){

            @Override
            public void delete(@NotNull String file, boolean isFile, boolean emptyParent) throws IOException {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractPatcher.this.deleteFile(file, emptyParent, isFile);
            }

            @Override
            public void rename(@NotNull String oldName, @NotNull String newName, boolean isFile, boolean emptyParent) throws IOException {
                if (oldName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (newName == null) {
                    1.$$$reportNull$$$0(2);
                }
                AbstractPatcher.this.renameFile(oldName, newName, emptyParent, isFile);
            }

            @Override
            public void setTimeStamp(@NotNull String file, long timestamp) throws IOException {
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                AbstractPatcher.this.setTimeStamp(file, timestamp);
            }

            @Override
            public void setFileMode(@NotNull String file, @NotNull String mode) throws IOException {
                if (file == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (mode == null) {
                    1.$$$reportNull$$$0(5);
                }
                AbstractPatcher.this.setFileMode(file, mode);
            }

            @Override
            public void addDirectory(@NotNull String file) throws IOException {
                if (file == null) {
                    1.$$$reportNull$$$0(6);
                }
                AbstractPatcher.this.addDirectory(file);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void changeBinary(@NotNull String file, long length, @NotNull LowLevelPatcherListener.ReadFileContent content, boolean bl) throws IOException {
                void create;
                if (file == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (content == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (create != false) {
                    AbstractPatcher.this.replaceBinary(file, length, true, content);
                } else {
                    AbstractPatcher.this.replaceBinary(file, length, false, content);
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void changeTextUsingBytes(@NotNull String file, @NotNull byte[] lineSeparator, long length, @NotNull LowLevelPatcherListener.ReadFileContent content, boolean bl) throws IOException {
                void create;
                if (file == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (lineSeparator == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (content == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (create != false) {
                    AbstractPatcher.this.replaceTextUsingBytes(file, length, lineSeparator, true, content);
                } else {
                    AbstractPatcher.this.replaceTextUsingBytes(file, length, lineSeparator, false, content);
                }
            }

            @Override
            public void exit(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(12);
                }
                AbstractPatcher.this.patchSucceeded(message);
            }

            @Override
            public void fail(@NotNull String message) throws IOException {
                if (message == null) {
                    1.$$$reportNull$$$0(13);
                }
                AbstractPatcher.this.patchFailed(message);
                if ("interrupted".equals(message)) {
                    throw new InterruptedPatchException();
                }
                LOG.info("Cannot apply patch: " + message);
                throw new UnsuccessfulPatchException(message);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mode";
                        break;
                    }
                    case 8: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "content";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lineSeparator";
                        break;
                    }
                    case 12: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/AbstractPatcher$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "delete";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rename";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setTimeStamp";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setFileMode";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addDirectory";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "changeBinary";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "changeTextUsingBytes";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "exit";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fail";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected void patchFailed(@NotNull String message) {
        if (message == null) {
            AbstractPatcher.$$$reportNull$$$0(2);
        }
    }

    protected void patchSucceeded(@NotNull String message) {
        if (message == null) {
            AbstractPatcher.$$$reportNull$$$0(3);
        }
    }

    public void close() {
        this.myPatcher.close();
    }

    @Override
    public void interrupt() {
        this.myPatcher.interrupt();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/vcs/patches/AbstractPatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "patchFailed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "patchSucceeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

